/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.log;

import cn.pconline.search.common.Configuration;
import cn.pconline.search.common.log.LogIO;
import cn.pconline.search.common.log.LogSaveThread;
import cn.pconline.search.common.log.SearchLog;
import java.io.Closeable;
import org.apache.commons.io.IOUtils;

public class SearchLogger {
    private LogIO logIO;
    private LogSaveThread saveThread;
    protected Configuration config;

    public SearchLogger(Configuration config) {
        this.config = config;
        this.logIO = new LogIO(config.getConfig("logSaveFloder", null));
        this.saveThread = new LogSaveThread(this.logIO, config);
        if (config.getBooleanConfig("enableLogSave", true).booleanValue()) {
            this.saveThread.start();
        }
    }

    public void logSearch(String app, String key, int result) {
        try {
            if (key == null || key.trim().equals("")) {
                return;
            }
            if (app == null || app.trim().equals("")) {
                return;
            }
            if (key.length() > 20) {
                return;
            }
            this.logIO.writeLog(new SearchLog(app, key, result));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        IOUtils.closeQuietly((Closeable)this.logIO);
        this.saveThread.interrupt();
        try {
            this.saveThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

