/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.query.elements;

import cn.pconline.search.common.query.Operator;
import cn.pconline.search.common.query.elements.Element;
import cn.pconline.search.common.query.elements.FieldQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class Tree
extends Element
implements Iterable<QueryNode> {
    private List<QueryNode> elements;

    public Tree() {
    }

    public Tree(float boost) {
        super(boost);
    }

    @Override
    public Iterator<QueryNode> iterator() {
        List<QueryNode> list = this.getElements(false);
        if (list == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return list.iterator();
    }

    public void addNode(QueryNode element) {
        this.getElements(true).add(element);
    }

    public void addNode(Element element) {
        this.getElements(true).add(new QueryNode(element));
    }

    public void addNode(Element element, Operator operator) {
        this.getElements(true).add(new QueryNode(element, operator));
    }

    public boolean removeElement(QueryNode element) {
        List<QueryNode> list = this.getElements(false);
        if (list != null) {
            return list.remove(element);
        }
        return false;
    }

    public boolean isEmpty() {
        return CollectionUtils.isNotEmpty(this.getElements(false));
    }

    public void clear() {
        if (this.getElements(false) != null) {
            this.getElements(false).clear();
        }
    }

    private List<QueryNode> getElements(boolean init) {
        if (init && this.elements == null) {
            this.elements = new LinkedList<QueryNode>();
            return this.elements;
        }
        return this.elements;
    }

    @Override
    public String toString() {
        List<QueryNode> els = this.getElements(false);
        String boost = this.getBoostString();
        if (CollectionUtils.isEmpty(els)) {
            String ret = "*:*";
            return ret + (boost == null ? "" : "^" + boost);
        }
        StringBuilder out = new StringBuilder();
        out.append("(");
        if (els.size() == 1) {
            out.append(els.get(0));
        } else {
            Iterator<QueryNode> nodes = this.iterator();
            ArrayList<QueryNode> require = new ArrayList<QueryNode>();
            ArrayList<QueryNode> should = new ArrayList<QueryNode>();
            QueryNode node = null;
            while (nodes.hasNext()) {
                node = nodes.next();
                if (node.operator == Operator.SHOULD) {
                    should.add(node);
                    continue;
                }
                require.add(node);
            }
            int index = 0;
            if (require.size() > 0) {
                for (QueryNode n : require) {
                    if (++index == 1) {
                        if (n.operator == Operator.MUST_NOT) {
                            out.append("NOT ");
                        }
                    } else {
                        out.append(" ").append(n.operator.toConnectString()).append(" ");
                    }
                    out.append(n.element);
                }
                if (should.size() > 0) {
                    out.append(" AND ");
                    out.append(FieldQuery.newMatchFieldQ("*"));
                }
            }
            if (should.size() > 0) {
                index = 0;
                for (QueryNode n : should) {
                    if (++index == 1) {
                        if (require.size() > 0) {
                            out.append(" ").append(n.operator.toConnectString()).append(" ");
                        }
                    } else {
                        out.append(" ").append(n.operator.toConnectString()).append(" ");
                    }
                    out.append(n.element);
                }
            }
        }
        out.append(")");
        if (boost != null) {
            out.append("^").append(boost);
        }
        return out.toString();
    }

    public static final class QueryNode {
        public Element element;
        public Operator operator = Operator.MUST;

        public QueryNode(Element element) {
            this.element = element;
        }

        public QueryNode(Element element, Operator operator) {
            this.element = element;
            this.operator = operator;
        }

        public String toString() {
            return this.operator.toString() + this.element;
        }
    }
}

