/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.taglib;

import cn.pconline.search.common.SearchFrame;
import cn.pconline.search.common.SolrSearcher;
import cn.pconline.search.common.ks.KSResult;
import cn.pconline.search.common.taglib.BaseTag;
import cn.pconline.search.common.util.HttpUrl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class NoResultTag
extends BaseTag {
    private SolrSearcher searcher;
    private String appName;
    private String keyword;
    private String var;
    private String index = "SearchedKeyword";
    private String host;
    private Integer suggestCount;
    private HttpUrl baseUrl;
    private Iterator<Map<String, Object>> suggestList;
    private List<String> list;
    private static final long serialVersionUID = 539243727621427688L;

    public void setSearcher(SolrSearcher searcher) {
        this.searcher = searcher;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public int doStartTag() throws JspException {
        if (StringUtils.isBlank((String)this.keyword)) {
            return 0;
        }
        if (StringUtils.isBlank((String)this.var)) {
            this.var = "suggest";
        }
        this.keyword = this.keyword.trim();
        String _q = "domain:(" + this.keyword.replaceAll("\u3000", " ").replaceAll("", " ").replaceAll("\\s+", " ").trim().replaceAll(" ", " OR ") + ")";
        String indexName = "APP:(zh)";
        if (this.appName != null && this.appName.trim().length() > 0) {
            indexName = "APP:(" + this.appName + ")";
        }
        _q = indexName + " AND  " + _q;
        int _pageSize = this.suggestCount == null || this.suggestCount <= 0 ? 20 : this.suggestCount;
        this.list = new ArrayList<String>();
        String retStr = SearchFrame.get().getHomonynsWords(this.keyword);
        this.list.addAll(Arrays.asList(retStr.split(";")));
        this.list.remove("");
        this.list.remove(this.keyword);
        HttpUrl holder = new HttpUrl();
        holder.setHostAndPort(this.host);
        holder.setRequestUri("search.jsp");
        holder.replaceParam("appName", this.index);
        holder.replaceParam("return", "url,keyword");
        holder.replaceParam("pageNo", 1);
        holder.replaceParam("perPage", _pageSize);
        holder.replaceParam("sort", "score");
        holder.replaceParam("q", _q);
        if (this.searcher == null) {
            this.searcher = SearchFrame.get().getSearcher();
        }
        KSResult result = null;
        try {
            result = this.searcher.searchKs(holder);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        if (CollectionUtils.isEmpty(result.getDocuments())) {
            return 0;
        }
        this.suggestList = result.getDocuments().iterator();
        Map<String, Object> doc = this.getDoc();
        if (doc == null) {
            return 0;
        }
        this.pageContext.setAttribute(this.var, doc);
        return 1;
    }

    public int doAfterBody() throws JspException {
        Map<String, Object> doc = this.getDoc();
        if (doc == null) {
            return 6;
        }
        this.pageContext.setAttribute(this.var, doc);
        return 2;
    }

    private Map<String, Object> getDoc() {
        Map<String, Object> tdoc;
        while (true) {
            if (this.suggestList == null || !this.suggestList.hasNext()) {
                return null;
            }
            tdoc = this.suggestList.next();
            if (tdoc == null || tdoc.get("url") == null) continue;
            String url = ((String)tdoc.get("url")).toLowerCase().replaceAll("\u3000| ", "");
            this.baseUrl.replaceParam("q", tdoc.get("keyword"));
            tdoc.put("url", this.baseUrl.toString());
            if (!url.equalsIgnoreCase(this.keyword) && !this.list.contains(url)) break;
        }
        this.list.add((String)tdoc.get("keyword"));
        return tdoc;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setSuggestCount(Integer suggestCount) {
        this.suggestCount = suggestCount;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = HttpUrl.fromUrl(baseUrl, null);
    }

    public void setBaseUrl(HttpUrl baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

