/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.sensitive;

import cn.pconline.search.common.tools.sensitive.SensitiveWord;
import cn.pconline.search.common.tools.sensitive.SensitiveWordSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;

public class OracleSensitiveWordSource
implements SensitiveWordSource {
    private Connection dbConn;
    private boolean loaded;
    private Iterator<SensitiveWord> iterator;
    private String domain;

    public OracleSensitiveWordSource(String connStr, String domain) {
        this.initConnection(connStr);
        this.domain = domain;
    }

    @Override
    public SensitiveWord nextWord() {
        if (!this.loaded) {
            this.load();
            this.loaded = true;
        }
        if (this.iterator == null || !this.iterator.hasNext()) {
            return null;
        }
        return this.iterator.next();
    }

    private void load() {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.dbConn.prepareStatement("select k.term,l.levelid from csr_keyword k,csr_keyword_level l where k.keywordId = l.keywordId and l.domain = ? and (k.expiryAt is null or k.expiryAt is not null and  round(to_number(sysdate-k.expiryAt)*24*60*60)<0) and (l.levelid=1 or l.levelid=2) ");
            ps.setString(1, this.domain);
            rs = ps.executeQuery();
            ArrayList<SensitiveWord> list = new ArrayList<SensitiveWord>();
            String kw = null;
            while (rs.next()) {
                kw = rs.getString("term");
                if (StringUtils.isBlank((String)kw)) continue;
                list.add(new SensitiveWord(kw, rs.getInt("levelid")));
            }
            this.iterator = list.iterator();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void initConnection(String connStr) {
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            this.dbConn = DriverManager.getConnection(connStr);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.dbConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

