/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.log;

import cn.pconline.search.common.Configuration;
import cn.pconline.search.common.log.LogIO;
import cn.pconline.search.common.log.LogIterator;
import cn.pconline.search.common.log.SearchLog;
import cn.pconline.search.common.log.SearchLogHelper;
import cn.pconline.search.common.log.SearchLogReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

public class HttpSearchLogReader
implements SearchLogReader {
    private static Logger logger = Logger.getLogger(HttpSearchLogReader.class);
    private HttpClient client = new DefaultHttpClient();
    private List<String> providers;

    public HttpSearchLogReader(Configuration config) {
        String urlStr = config.getConfig("providerUrls");
        if (StringUtils.isNotBlank((String)urlStr)) {
            String[] arr = urlStr.split(",");
            this.providers = Arrays.asList(arr);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public LogIterator getIterator(final Date date) throws IOException {
        if (CollectionUtils.isEmpty(this.providers)) {
            return null;
        }
        ArrayList<HttpPost> postMethods = new ArrayList<HttpPost>(this.providers.size());
        for (String str : this.providers) {
            postMethods.add(new HttpPost(str));
        }
        final Iterator iterator = postMethods.iterator();
        return new LogIterator(){
            private SingleProviderReader reader = null;
            private boolean finished = false;

            @Override
            public void close() throws IOException {
                if (this.reader != null) {
                    this.finished = true;
                    this.reader.close();
                    this.reader = null;
                }
            }

            @Override
            public SearchLog readNext() {
                if (this.finished) {
                    return null;
                }
                while (true) {
                    if (this.reader == null) {
                        if (iterator.hasNext()) {
                            this.reader = new SingleProviderReader((HttpPost)iterator.next(), date);
                            continue;
                        }
                        this.finished = true;
                        return null;
                    }
                    if (this.reader.hasNext()) {
                        return this.reader.next();
                    }
                    IOUtils.closeQuietly((Closeable)this.reader);
                    this.reader = null;
                }
            }
        };
    }

    @Override
    public LogIterator getYesterdayLogs() throws IOException {
        return this.getIterator(LogIO.getYesterday());
    }

    private class SingleProviderReader
    implements Closeable {
        private HttpPost post;
        private SearchLog current;
        private boolean eof = false;
        private InputStream in;
        private Date date;

        public SingleProviderReader(HttpPost post, Date date) {
            this.post = post;
            this.date = date;
        }

        public boolean hasNext() {
            if (this.current != null) {
                return true;
            }
            if (this.eof) {
                return false;
            }
            try {
                if (this.in == null) {
                    this.post.setHeader("X-SearchLog-Date", new SimpleDateFormat("yyyy-MM-dd").format(this.date));
                    HttpResponse rsp = HttpSearchLogReader.this.client.execute((HttpUriRequest)this.post);
                    if (rsp.getStatusLine().getStatusCode() != 200) {
                        logger.error((Object)("Execute method:[" + this.post + "]return a error code:" + rsp.getStatusLine()));
                        this.eof = true;
                        return false;
                    }
                    Object[] msg = rsp.getHeaders("X-SearchLog-Ret");
                    if (ArrayUtils.isNotEmpty((Object[])msg)) {
                        logger.error((Object)("Provider[" + this.post + "] ret a error msg:" + Arrays.toString(msg)));
                        this.eof = true;
                        return false;
                    }
                    if (rsp.getEntity() == null || rsp.getEntity().getContent() == null) {
                        this.eof = true;
                        return false;
                    }
                    this.in = rsp.getEntity().getContent();
                }
                this.current = SearchLogHelper.read(this.in);
                if (this.current == null) {
                    this.eof = true;
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                logger.error((Object)("Read provider:[" + this.post + "] occur a error"), (Throwable)e);
                return false;
            }
        }

        public SearchLog next() {
            if (this.current != null) {
                SearchLog ret = this.current;
                this.current = null;
                return ret;
            }
            return this.current;
        }

        @Override
        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
            }
            this.post.abort();
        }
    }
}

