/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.log;

import cn.pconline.search.common.log.LogIterator;
import cn.pconline.search.common.log.SearchLog;
import cn.pconline.search.common.log.SearchLogHelper;
import cn.pconline.search.common.log.SearchLogReader;
import cn.pconline.search.common.log.SearchLogWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class LogIO
implements SearchLogReader,
SearchLogWriter {
    private static final String LOG_FILE_PREFIX = "SearchLog.";
    private static final Charset CHARSET = Charset.forName("GBK");
    private Map<String, OutWrapper> outMap = new ConcurrentHashMap<String, OutWrapper>();
    private Object writeLock = new Object();
    private String logFileFloder;

    public LogIO(String logFileFloder) {
        this.logFileFloder = logFileFloder;
    }

    public LogIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLog(SearchLog log) throws IOException {
        OutWrapper wrapper = null;
        try {
            wrapper = this.getOut(log);
            byte[] content = log.getKey().getBytes(CHARSET);
            byte[] app = log.getApp().getBytes(CHARSET);
            ByteBuffer buffer = ByteBuffer.allocate(content.length + 1 + app.length + 1 + 4 + 8);
            buffer.put((byte)app.length);
            buffer.put(app);
            buffer.put((byte)content.length);
            buffer.put(content);
            buffer.putInt(log.getRetCount());
            buffer.putLong(log.getSearchTime().getTime());
            Object object = this.writeLock;
            synchronized (object) {
                wrapper.out.write(buffer.array());
            }
        }
        finally {
            this.releaseOut(wrapper);
        }
    }

    @Override
    public LogIterator getYesterdayLogs() throws IOException {
        return this.getIterator(LogIO.getYesterday());
    }

    File getLogFile(Date date) {
        File f = null;
        f = StringUtils.isNotEmpty((String)this.logFileFloder) ? new File(this.logFileFloder, LOG_FILE_PREFIX + LogIO.getFileKey(date)) : new File(LOG_FILE_PREFIX + LogIO.getFileKey(date));
        if (f.exists() && f.isFile() && f.length() > 0L) {
            return f;
        }
        return null;
    }

    @Override
    public LogIterator getIterator(Date date) throws IOException {
        File f = this.getLogFile(date);
        if (f != null) {
            final FileInputStream in = new FileInputStream(f);
            return new LogIterator(){
                private boolean EOF = false;

                @Override
                public void close() throws IOException {
                    in.close();
                    this.EOF = true;
                }

                @Override
                public SearchLog readNext() {
                    if (this.EOF) {
                        return null;
                    }
                    try {
                        SearchLog log = SearchLogHelper.read(in);
                        if (log == null) {
                            this.EOF = true;
                            return null;
                        }
                        return log;
                    }
                    catch (IOException e) {
                        this.EOF = true;
                        return null;
                    }
                }
            };
        }
        return null;
    }

    private static Date getToday() {
        Calendar c = Calendar.getInstance();
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getYesterday() {
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static String getFileKey(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String key = sdf.format(date);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutWrapper getOut(SearchLog log) throws IOException {
        String key = LogIO.getFileKey(log.getSearchTime());
        OutWrapper wrapper = this.outMap.get(key);
        if (wrapper == null) {
            Map<String, OutWrapper> map = this.outMap;
            synchronized (map) {
                wrapper = this.outMap.get(key);
                if (wrapper == null) {
                    String yesterdayKey = LogIO.getFileKey(LogIO.getYesterday());
                    OutWrapper yesterday = this.outMap.get(yesterdayKey);
                    if (yesterday != null) {
                        IOUtils.closeQuietly((OutputStream)yesterday.out);
                        this.outMap.remove(yesterdayKey);
                    }
                    wrapper = new OutWrapper();
                    wrapper.file = StringUtils.isEmpty((String)this.logFileFloder) ? new File(LOG_FILE_PREFIX + key) : new File(this.logFileFloder, LOG_FILE_PREFIX + key);
                    this.createFolder(wrapper.file.getParentFile());
                    wrapper.out = new FileOutputStream(wrapper.file, true);
                    wrapper.out = new BufferedOutputStream(wrapper.out, 524288);
                    wrapper.dateFor = LogIO.getToday();
                    this.outMap.put(key, wrapper);
                }
            }
        }
        wrapper.refCount.incrementAndGet();
        return wrapper;
    }

    private void createFolder(File file) throws IOException {
        if (file == null || file.exists()) {
            return;
        }
        this.createFolder(file.getParentFile());
        if (!file.mkdir()) {
            throw new IOException("create folder [" + file + "] fail");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseOut(OutWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        wrapper.refCount.decrementAndGet();
        if (wrapper.refCount.get() == 0L && wrapper.dateFor.getTime() < LogIO.getToday().getTime()) {
            Map<String, OutWrapper> map = this.outMap;
            synchronized (map) {
                IOUtils.closeQuietly((OutputStream)wrapper.out);
                this.outMap.remove(LogIO.getFileKey(wrapper.dateFor));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<String, OutWrapper> map = this.outMap;
        synchronized (map) {
            Iterator<Map.Entry<String, OutWrapper>> it = this.outMap.entrySet().iterator();
            while (it.hasNext()) {
                IOUtils.closeQuietly((OutputStream)it.next().getValue().out);
                it.remove();
            }
        }
    }

    private class OutWrapper {
        private Date dateFor;
        private File file;
        private OutputStream out;
        private AtomicLong refCount = new AtomicLong(0L);

        private OutWrapper() {
        }
    }
}

