/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.log;

import cn.pconline.search.common.log.GroupCounter;
import cn.pconline.search.common.log.LogIterator;
import cn.pconline.search.common.log.SearchLog;
import cn.pconline.search.common.log.SearchLogReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SearchLogHelper {
    private static final Charset CHARSET = Charset.forName("GBK");

    public static List<GroupCounter.Item> getTop(List<SearchLogReader> readers, int top, Map<SearchLog, Integer> keyOccurMap) throws Exception {
        GroupCounter groupCounter = SearchLogHelper.getGroupCounter(readers, keyOccurMap);
        if (groupCounter == null) {
            return Collections.EMPTY_LIST;
        }
        return groupCounter.getTop(top);
    }

    public static GroupCounter getGroupCounter(List<SearchLogReader> readers, Map<SearchLog, Integer> keyOccurMap) throws Exception {
        GroupCounter groupCounter = null;
        for (SearchLogReader reader : readers) {
            LogIterator iterator = reader.getYesterdayLogs();
            if (iterator == null) continue;
            if (groupCounter == null) {
                groupCounter = new GroupCounter();
            }
            SearchLog searchLog = null;
            while ((searchLog = iterator.readNext()) != null) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                Integer result = keyOccurMap.get(searchLog);
                if (result == null) {
                    keyOccurMap.put(searchLog, searchLog.getRetCount());
                } else if (searchLog.getRetCount() >= 0) {
                    keyOccurMap.put(searchLog, searchLog.getRetCount());
                }
                groupCounter.add(searchLog);
            }
            iterator.close();
        }
        return groupCounter;
    }

    public static SearchLog read(InputStream in) throws IOException {
        SearchLog log = new SearchLog();
        if (in.available() <= 0) {
            return null;
        }
        byte appLength = (byte)in.read();
        if (appLength <= 0) {
            return null;
        }
        byte[] app = new byte[appLength];
        if (in.available() <= 0 || in.read(app) < appLength) {
            return null;
        }
        log.setApp(new String(app, CHARSET));
        if (in.available() <= 0) {
            return null;
        }
        byte contentLength = (byte)in.read();
        if (contentLength <= 0) {
            return null;
        }
        byte[] content = new byte[contentLength];
        if (in.available() <= 0 || in.read(content) < contentLength) {
            return null;
        }
        log.setKey(new String(content, CHARSET));
        byte[] arr = new byte[12];
        if (in.available() <= 0 || in.read(arr) < arr.length) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(arr);
        log.setRetCount(buffer.getInt());
        log.setSearchTime(new Date(buffer.getLong()));
        return log;
    }
}

