/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;

public class Mailer {
    private static Logger logger = Logger.getLogger(Mailer.class);

    public static void sendMail(String title, String msg, String host, String from, String tolist, final String user, final String pwd, String[] proxyInfo) {
        ArrayList<String> maillist;
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        if (proxyInfo != null) {
            props.setProperty("proxySet", "true");
            props.setProperty("ProxyHost", proxyInfo[0]);
            props.setProperty("ProxyPort", proxyInfo[1]);
        }
        if ((maillist = null) == null) {
            logger.warn((Object)"WARN: mail list is NULL !");
            if (tolist == null || tolist.isEmpty()) {
                return;
            }
            String[] tos = tolist.split(",");
            maillist = new ArrayList<String>(3);
            for (String to : tos) {
                maillist.add(to);
            }
        }
        Authenticator authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, pwd);
            }
        };
        Session session = Session.getInstance((Properties)props, (Authenticator)authenticator);
        MimeMessage message = new MimeMessage(session);
        try {
            for (String to : maillist) {
                message.setFrom((Address)new InternetAddress(from));
                InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
                message.setRecipients(Message.RecipientType.TO, (Address[])address);
                message.setSubject(title);
                message.setSentDate(new Date());
                MimeBodyPart mdp = new MimeBodyPart();
                mdp.setContent((Object)msg, "text/html;charset=gb2312");
                MimeMultipart mm = new MimeMultipart();
                mm.addBodyPart((BodyPart)mdp);
                message.setContent((Multipart)mm);
                message.saveChanges();
                Transport.send((Message)message);
            }
        }
        catch (AddressException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (MessagingException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

