/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class StringHtmlUtil {
    public static final String PATTERNS = "[^0-9]*([0-9]+\\.?[0-9]*)[^0-9]*";
    private static final String NUMPATTERN = "(\\d+\\.*\\d*)";
    private static final Pattern pattern = Pattern.compile("(\\d+\u5143\u4ee5(\u4e0a|\u4e0b))", 32);
    private static final String PICSIZE = "_100x50";

    public static void main(String[] args) {
        System.out.println(StringHtmlUtil.returnBrandPic("http://img.pconline.com.cn/images/upload/upc/tx/babylib/1008/09/c0/4784774_1281324915125.gif"));
    }

    public static String getFirstNumber(String str) {
        StringBuilder ret = new StringBuilder();
        if (str != null) {
            char c;
            for (int i = 0; i < str.length() && ((c = str.charAt(i)) >= '0' && c <= '9' || c == '.'); ++i) {
                ret.append(c);
            }
        }
        return ret.toString();
    }

    public static String returnBrandPic(String bpic) {
        if (bpic == null || bpic.isEmpty()) {
            return "";
        }
        int index = bpic.lastIndexOf(".");
        String substrstart = bpic.substring(0, index);
        String subend = bpic.substring(index, bpic.length());
        StringBuffer sb = new StringBuffer();
        sb.append(substrstart);
        sb.append(PICSIZE);
        sb.append(subend);
        return sb.toString();
    }

    public static String encodeClusterQuery(String url) {
        String[] urlParts;
        String encodedUrl = "";
        if (url != null && (urlParts = (url = StringHtmlUtil.changeDomainToSlash(url)).split("clusterQuery=")) != null) {
            String[] urlParts2;
            encodedUrl = urlParts[0] + "clusterQuery=";
            if (urlParts.length == 2 && (urlParts2 = urlParts[1].split("&")) != null) {
                try {
                    if (urlParts2.length == 1) {
                        encodedUrl = encodedUrl + URLEncoder.encode(urlParts2[0], "gbk");
                    } else if (urlParts2.length > 1) {
                        for (int i = 0; i < urlParts2.length; ++i) {
                            encodedUrl = encodedUrl + (i == 0 ? "" : "&") + (i == 0 ? URLEncoder.encode(urlParts2[i], "gbk") : urlParts2[i]);
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return encodedUrl;
    }

    public static String changeDomainToSlash(String str) {
        return str != null && str.length() > 0 ? str.replaceAll("http:\\/\\/[^\\/]+\\/", "/") : str;
    }

    public static String changeCLusterPrice(String cluster_price) {
        if (cluster_price == null || cluster_price.isEmpty()) {
            return cluster_price;
        }
        if (cluster_price.contains("-")) {
            return cluster_price;
        }
        Matcher matcher = pattern.matcher(cluster_price);
        if (!matcher.find()) {
            String cn = cluster_price.replaceAll("\\d+", "");
            String num = cluster_price.replaceAll("[^\\d+]", "");
            return num + "\u5143" + cn;
        }
        return cluster_price;
    }

    public static String filterBracketContent(String content) {
        if (content != null && content.trim().length() > 0) {
            content = content.replaceAll("(\\(.*\\))", "");
        }
        return content;
    }

    public static String formatHtmlGuote(String kw) {
        return kw != null && kw.trim().length() > 0 ? kw.replaceAll("\"", "&quot;").replaceAll("'", "&#39;") : kw;
    }

    public static String stripHtmlTags(String input) {
        if (StringUtils.isBlank((String)input)) {
            return input;
        }
        String regExp = "<[^>]+>|&[a-zA-Z]{2,6};";
        String spaceRegExp = "\\s+";
        input = input.replaceAll(regExp, " ");
        input = input.trim();
        input = input.replaceAll(spaceRegExp, " ");
        return input;
    }

    public static boolean isSyntax(String key) {
        Pattern p = Pattern.compile("([^\\+\\-]*(\\+|\\-)[^\\p{Space}\\+\\-]+[^\\+\\-]*)+|.*[A-Za-z]+\\s*:.+.*|.*\".*\".*|.*\\|.*");
        Matcher m = p.matcher(key);
        return m.matches();
    }

    public static String format(String value) {
        return value == null ? "" : value;
    }

    public static String formatRegex(String value) {
        return value != null ? value.replaceAll("[\\(|\\)|\\[|\\]|\\{|\\}|\\\\|\\*|\\?|\\!|\\^|\\-|\\.|\\+|\\,|\\=|\\$]", "") : "";
    }

    public static String formatContent(String value, String prefix, String postfix) {
        return value.replaceAll(prefix, prefix.toUpperCase()).replaceAll(postfix, postfix.toUpperCase());
    }

    public static double getNumber(String str) {
        if (str == null) {
            return -1.0;
        }
        if (str.contains("\u4ee5\u4e0b")) {
            return 0.0;
        }
        Pattern p = Pattern.compile(PATTERNS);
        Matcher m = p.matcher(str);
        String number = null;
        if (m.find()) {
            number = m.group(1);
        }
        if (number != null) {
            return Double.parseDouble(number);
        }
        return -1.0;
    }

    public static double getNumber2(String str) {
        if (str == null) {
            return -1.0;
        }
        boolean isDown = false;
        if (str.contains("\u4ee5\u4e0b")) {
            isDown = true;
        }
        Pattern p = Pattern.compile(NUMPATTERN);
        Matcher m = p.matcher(str);
        String number = null;
        if (m.find()) {
            number = m.group(1);
        }
        if (number != null) {
            double res = Double.parseDouble(number);
            if (isDown) {
                return res -= 1.0;
            }
            return res;
        }
        return -1.0;
    }

    public static String ToSBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String ToDBC(String input) {
        if (input == null || "".equals(input)) {
            return input;
        }
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String delHtmlTag(String input) {
        if (input == null || input.trim().equals("")) {
            return "";
        }
        String str = input.replaceAll("\\&[a-zA-Z]{1,10};", "").replaceAll("<[^>]*>", "");
        str = str.replaceAll("[(/>)<]", "");
        return str;
    }

    public static String insertSizeInPicUrl(String url, String size) {
        if (url == null) {
            return "";
        }
        if (url.trim().length() == 0) {
            return "";
        }
        int lastDotIndex = url.lastIndexOf(".");
        String left = url.substring(0, lastDotIndex);
        String right = url.substring(lastDotIndex, url.length());
        url = left + size + right;
        return url;
    }

    public static String join(String original, String joinStr) {
        StringBuilder target = new StringBuilder();
        char[] cs = original.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            target.append(cs[i]);
            if (i == cs.length - 1) continue;
            target.append(joinStr);
        }
        return target.toString();
    }

    public static String removePageTags(String text) {
        if (text != null) {
            String scriptTag = "<\\s*script[^>]*?\\s*>[^<]*<\\s*/script\\s*>";
            String styleTag = "<\\s*style[^>]*?\\s*>[^<]*<\\s*/style\\s*>";
            String xmlTag = "<\\s*xml[^>]*?\\s*>[^<]*<\\s*/xml\\s*>";
            String otherTag = "<[^>]+>";
            String symbol = "&[a-zA-Z0-9]+;";
            Pattern pattern = Pattern.compile("\\s+|" + symbol + "|" + otherTag + "|" + scriptTag + "|" + styleTag + "|" + xmlTag);
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                text = matcher.replaceAll("");
            }
        }
        return text;
    }
}

