/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.client.solrj.SolrQuery;

public interface SolrSearchRequestAdaptor {
    public SolrQuery adaptRequest(HttpServletRequest var1) throws IOException;

    public boolean isForbiddenIndex(String var1);

    public static final class DefaultRequestAdaptor
    implements SolrSearchRequestAdaptor {
        private Set<String> forbbidenIndexSet = null;

        public DefaultRequestAdaptor() {
        }

        public DefaultRequestAdaptor(Set<String> forbbidenIndexSet) {
            this.forbbidenIndexSet = forbbidenIndexSet;
        }

        @Override
        public SolrQuery adaptRequest(HttpServletRequest req) {
            SolrQuery q = new SolrQuery();
            Map paramMap = req.getParameterMap();
            for (Map.Entry e : paramMap.entrySet()) {
                q.add((String)e.getKey(), (String[])e.getValue());
            }
            return q;
        }

        @Override
        public boolean isForbiddenIndex(String indexKey) {
            return this.forbbidenIndexSet != null && this.forbbidenIndexSet.contains(indexKey);
        }
    }
}

