/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common;

import cn.pconline.search.common.query.SolrQueryResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import java.beans.XMLEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.client.solrj.SolrQuery;

public interface SolrSearchResponseAdaptor {
    public void adaptResponse(HttpServletResponse var1, SolrQuery var2, SolrQueryResult var3) throws ServletException, IOException;

    public void handleError(HttpServletResponse var1, SolrQuery var2, Exception var3) throws IOException;

    public static final class DefaultResponseAdaptor
    implements SolrSearchResponseAdaptor {
        protected static final SerializeConfig SConfig = new SerializeConfig();
        private String responseEncoding = "gbk";

        public DefaultResponseAdaptor() {
        }

        public DefaultResponseAdaptor(String responseEncoding) {
            this.responseEncoding = responseEncoding;
        }

        @Override
        public void adaptResponse(HttpServletResponse response, SolrQuery query, SolrQueryResult result) throws ServletException, IOException {
            String format = query.get("returnType");
            if ("xml".equalsIgnoreCase(format)) {
                this.writeXml(this.responseEncoding, result, response);
            } else {
                this.writeJson(this.responseEncoding, result, response);
            }
        }

        @Override
        public void handleError(HttpServletResponse response, SolrQuery q, Exception e) throws IOException {
            response.setStatus(500);
            response.setContentType("text/html;charset=" + this.responseEncoding);
            response.getWriter().println("<pre>");
            e.printStackTrace(new PrintWriter(response.getWriter()));
            response.getWriter().println("</pre>");
            response.flushBuffer();
        }

        protected void writeJson(String encoding, SolrQueryResult result, HttpServletResponse response) throws IOException {
            response.setContentType("application/json;charset=" + encoding);
            String json = JSON.toJSONString((Object)result.getSource(), (SerializeConfig)SConfig, (SerializerFeature[])new SerializerFeature[0]);
            response.getWriter().write(json);
            response.flushBuffer();
        }

        protected void writeXml(String encoding, SolrQueryResult result, HttpServletResponse response) throws IOException {
            response.setContentType("text/xml;charset=" + encoding);
            XMLEncoder encoder = new XMLEncoder((OutputStream)response.getOutputStream());
            encoder.writeObject(result.getSource());
            encoder.flush();
            encoder.close();
            response.flushBuffer();
        }

        static {
            SConfig.put(Timestamp.class, (Object)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
            SConfig.put(Date.class, (Object)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
            SConfig.put(java.sql.Date.class, (Object)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        }
    }
}

