/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common;

import cn.pconline.search.common.Configuration;
import cn.pconline.search.common.SearchException;
import cn.pconline.search.common.SolrSearchRequestAdaptor;
import cn.pconline.search.common.SolrSearchResponseAdaptor;
import cn.pconline.search.common.ks.KSResult;
import cn.pconline.search.common.query.RHttpSolrServer;
import cn.pconline.search.common.query.SolrQueryResult;
import cn.pconline.search.common.util.HttpUrl;
import cn.pconline.search.common.util.Intf;
import cn.pconline.search.common.util.QueryUtil;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;

public class SolrSearcher {
    public static final String DEFAULT_SOLR_URL = "http://192.168.239.79:8983/solr/";
    private SolrServer server;
    private Configuration config;
    private SolrSearchRequestAdaptor requestAdaptor = new SolrSearchRequestAdaptor.DefaultRequestAdaptor();
    private SolrSearchResponseAdaptor responseAdaptor = new SolrSearchResponseAdaptor.DefaultResponseAdaptor();

    public SolrSearcher(String solrBaseUrl, Configuration config) {
        RHttpSolrServer httpServer = new RHttpSolrServer(solrBaseUrl, null, (ResponseParser)new TimeZoneParser(), Intf.getHttpTemplate());
        this.config = config;
        this.setupHttpServer(httpServer);
        this.server = httpServer;
    }

    public SolrSearcher(Configuration config) {
        this(config.getConfig("searchServer", DEFAULT_SOLR_URL), config);
    }

    public QueryResponse search(String index, SolrQuery q) {
        return this.search(index, "select", q);
    }

    public SolrQueryResult searchAs(String index, SolrQuery q) {
        return SolrQueryResult.fromResponse(this.search(index, "select", q));
    }

    public QueryResponse search(String index, String handler, SolrQuery q) {
        QueryRequest req = new QueryRequest((SolrParams)q);
        req.setPath("/" + index + "/" + handler);
        try {
            return req.process(this.server);
        }
        catch (SolrServerException e) {
            throw new SearchException(e);
        }
    }

    public KSResult searchKs(HttpUrl searchUrl) throws IOException {
        searchUrl.replaceParam("returnType", "json");
        String rsp = Intf.readHtml4Get(searchUrl.toString(), null, "gbk", 3000, 2);
        if (StringUtils.isBlank((String)rsp)) {
            return new KSResult();
        }
        return (KSResult)JSON.parseObject((String)rsp.trim(), KSResult.class);
    }

    public KSResult searchKs(HttpUrl searchUrl, String[] filterTagFields, String hTag) throws IOException {
        KSResult result = this.searchKs(searchUrl);
        QueryUtil.filterTagInResult(result, hTag, filterTagFields);
        return result;
    }

    public void adaptHttpSearch(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.adaptHttpSearch(request, response, this.requestAdaptor, this.responseAdaptor);
    }

    public void adaptHttpSearch(HttpServletRequest request, HttpServletResponse response, SolrSearchRequestAdaptor requestAdaptor, SolrSearchResponseAdaptor responseAdaptor) throws IOException {
        SolrQuery sq = requestAdaptor.adaptRequest(request);
        String index = sq.get("app");
        if (StringUtils.isBlank((String)index) || requestAdaptor.isForbiddenIndex(index)) {
            response.setStatus(404);
            response.flushBuffer();
            return;
        }
        try {
            SolrQueryResult result = this.searchAs(index, sq);
            responseAdaptor.adaptResponse(response, sq, result);
        }
        catch (Exception e) {
            responseAdaptor.handleError(response, sq, e);
        }
    }

    protected void setupHttpServer(HttpSolrServer server) {
        server.setConnectionTimeout(this.config.getIntConfig("http.ConnectTimeout", 5000).intValue());
        server.setSoTimeout(this.config.getIntConfig("http.SoTimeout", 5000).intValue());
        server.setMaxTotalConnections(this.config.getIntConfig("http.ConnectionCount", 100).intValue());
        server.setMaxRetries(this.config.getIntConfig("http.retryTimes", 2).intValue());
        if (this.config.getBooleanConfig("http.useProxy", false).booleanValue() && Intf.getHttpTemplate() == null) {
            HttpClient client = server.getHttpClient();
            HttpHost proxy = new HttpHost(this.config.getConfig("http.proxyIp"), this.config.getIntConfig("http.proxyPort").intValue());
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            if (client instanceof DefaultHttpClient) {
                String user = this.config.getConfig("http.proxyUser");
                String pwd = this.config.getConfig("http.proxyPassword");
                if (StringUtils.isNotEmpty((String)user) && StringUtils.isNotEmpty((String)pwd)) {
                    NTCredentials credentials = new NTCredentials(user, pwd, "", "");
                    ((DefaultHttpClient)client).getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
                }
            }
        }
    }

    public static void mergeHighLight(QueryResponse rsp, String keyField, List<Map<String, Object>> resultMaps) {
        SolrDocumentList rspList = rsp.getResults();
        if (CollectionUtils.isEmpty((Collection)rspList) || MapUtils.isEmpty((Map)rsp.getHighlighting())) {
            return;
        }
        Object key = null;
        Object result = null;
        boolean useSource = resultMaps == null;
        for (SolrDocument doc : rspList) {
            result = useSource ? doc : new HashMap();
            key = doc.get((Object)keyField);
            Map map = (Map)rsp.getHighlighting().get(key);
            if (MapUtils.isNotEmpty((Map)map)) {
                if (!useSource) {
                    result.putAll(doc);
                }
                for (Map.Entry en : map.entrySet()) {
                    if (((List)en.getValue()).size() == 1) {
                        result.put(en.getKey(), ((List)en.getValue()).get(0));
                        continue;
                    }
                    result.put(en.getKey(), en.getValue());
                }
            }
            if (useSource) continue;
            resultMaps.add((Map<String, Object>)result);
        }
    }

    public void setRequestAdaptor(SolrSearchRequestAdaptor requestAdaptor) {
        if (requestAdaptor != null) {
            this.requestAdaptor = requestAdaptor;
        }
    }

    public void setResponseAdaptor(SolrSearchResponseAdaptor responseAdaptor) {
        if (responseAdaptor != null) {
            this.responseAdaptor = responseAdaptor;
        }
    }

    void close() {
        this.server.shutdown();
    }

    private static class TimeZoneParser
    extends BinaryResponseParser {
        private static final TimeZone CURRENT_TIME_ZONE = TimeZone.getDefault();
        private static final long OFFSET_TZ = CURRENT_TIME_ZONE.getOffset(System.currentTimeMillis());

        private TimeZoneParser() {
        }

        public NamedList<Object> processResponse(InputStream body, String encoding) {
            try {
                return (NamedList)new JavaBinCodec(){

                    public Object readVal(FastInputStream dis) throws IOException {
                        this.tagByte = dis.readByte();
                        switch (this.tagByte >>> 5) {
                            case 1: {
                                return this.readStr(dis);
                            }
                            case 2: {
                                return this.readSmallInt(dis);
                            }
                            case 3: {
                                return this.readSmallLong(dis);
                            }
                            case 0x7FFFFFC: {
                                return this.readArray(dis);
                            }
                            case 0x7FFFFFD: {
                                return this.readOrderedMap(dis);
                            }
                            case 0x7FFFFFE: {
                                return this.readNamedList(dis);
                            }
                            case 0x7FFFFFF: {
                                return this.readExternString(dis);
                            }
                        }
                        switch (this.tagByte) {
                            case 0: {
                                return null;
                            }
                            case 9: {
                                return new Date(dis.readLong() - OFFSET_TZ);
                            }
                            case 6: {
                                return dis.readInt();
                            }
                            case 1: {
                                return Boolean.TRUE;
                            }
                            case 2: {
                                return Boolean.FALSE;
                            }
                            case 8: {
                                return Float.valueOf(dis.readFloat());
                            }
                            case 5: {
                                return dis.readDouble();
                            }
                            case 7: {
                                return dis.readLong();
                            }
                            case 3: {
                                return dis.readByte();
                            }
                            case 4: {
                                return dis.readShort();
                            }
                            case 10: {
                                return this.readMap(dis);
                            }
                            case 11: {
                                return this.readSolrDocument(dis);
                            }
                            case 12: {
                                return this.readSolrDocumentList(dis);
                            }
                            case 13: {
                                return this.readByteArray(dis);
                            }
                            case 14: {
                                return this.readIterator(dis);
                            }
                            case 15: {
                                return END_OBJ;
                            }
                            case 16: {
                                return this.readSolrInputDocument(dis);
                            }
                        }
                        throw new RuntimeException("Unknown type " + this.tagByte);
                    }
                }.unmarshal(body);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", (Throwable)e);
            }
        }
    }
}

