/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services;

import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.config.ConfigMap;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.security.LoginManager;
import flex.messaging.security.SecurityException;
import flex.messaging.services.AbstractService;
import flex.messaging.util.Base64;
import java.io.UnsupportedEncodingException;

public class AuthenticationService
extends AbstractService {
    private static final int INVALID_CREDENTIALS_ERROR = 10064;
    private final String id = "authentication-service";

    public AuthenticationService() {
        this(false);
    }

    public AuthenticationService(boolean enableManagement) {
        super(false);
        super.setId("authentication-service");
    }

    public void setId(String id) {
    }

    public ConfigMap describeService(Endpoint endpoint) {
        return null;
    }

    public Object serviceMessage(Message message) {
        return null;
    }

    public Object serviceCommand(CommandMessage msg) {
        LoginManager lm = this.getMessageBroker().getLoginManager();
        switch (msg.getOperation()) {
            case 8: {
                if (!(msg.getBody() instanceof String)) break;
                String encoded = (String)msg.getBody();
                Object charsetHeader = msg.getHeader("DSCredentialsCharset");
                if (charsetHeader instanceof String) {
                    AuthenticationService.decodeAndLoginWithCharset(encoded, lm, (String)charsetHeader);
                    break;
                }
                AuthenticationService.decodeAndLoginWithCharset(encoded, lm, null);
                break;
            }
            case 9: {
                lm.logout();
                break;
            }
            default: {
                throw new MessageException("Service Does Not Support Command Type " + msg.getOperation());
            }
        }
        return "success";
    }

    public static void decodeAndLogin(String encoded, LoginManager lm) {
        AuthenticationService.decodeAndLoginWithCharset(encoded, lm, null);
    }

    private static void decodeAndLoginWithCharset(String encoded, LoginManager lm, String charset) {
        int colon;
        String username = null;
        String password = null;
        Base64.Decoder decoder = new Base64.Decoder();
        decoder.decode(encoded);
        String decoded = "";
        if (charset != null) {
            try {
                decoded = new String(decoder.drain(), charset);
            }
            catch (UnsupportedEncodingException ex) {}
        } else {
            decoded = new String(decoder.drain());
        }
        if ((colon = decoded.indexOf(":")) > 0 && colon < decoded.length() - 1) {
            username = decoded.substring(0, colon);
            password = decoded.substring(colon + 1);
        }
        if (username == null || password == null) {
            SecurityException se = new SecurityException();
            se.setCode("Client.Authentication");
            se.setMessage(10064);
            throw se;
        }
        lm.login(username, password);
    }

    protected void setupServiceControl(MessageBroker broker) {
    }
}

