/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.spring.boot.autoconfigure;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.alibaba.druid.spring.boot.autoconfigure.DruidSpringAopConfiguration;
import com.alibaba.druid.spring.boot.autoconfigure.DruidStatProperties;
import com.alibaba.druid.spring.boot.autoconfigure.DruidStatViewServletConfiguration;
import com.alibaba.druid.spring.boot.autoconfigure.DruidWebStatFilterConfiguration;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={DruidDataSource.class})
@EnableConfigurationProperties(value={DruidStatProperties.class})
@Import(value={DruidSpringAopConfiguration.class, DruidStatViewServletConfiguration.class, DruidWebStatFilterConfiguration.class})
public class DruidDataSourceAutoConfigure {
    @Bean
    @ConfigurationProperties(value="spring.datasource.druid")
    @ConditionalOnMissingBean
    public DataSource dataSource(Environment env) {
        DruidDataSource dataSource = DruidDataSourceBuilder.create().build();
        if (dataSource.getUsername() == null) {
            dataSource.setUsername(env.getProperty("spring.datasource.username"));
        }
        if (dataSource.getPassword() == null) {
            dataSource.setPassword(env.getProperty("spring.datasource.password"));
        }
        if (dataSource.getUrl() == null) {
            dataSource.setUrl(env.getProperty("spring.datasource.url"));
        }
        if (dataSource.getDriverClassName() == null) {
            dataSource.setDriverClassName(env.getProperty("spring.datasource.driver-class-name"));
        }
        if (!"false".equals(env.getProperty("spring.datasource.druid.StatViewServlet.enabled"))) {
            try {
                dataSource.setFilters("stat");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return dataSource;
    }
}

