/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.spring.boot.autoconfigure;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.jdbc.DatabaseDriver;

public class DruidDataSourceBuilder {
    private Map<String, String> properties = new HashMap<String, String>();

    public static DruidDataSourceBuilder create() {
        return new DruidDataSourceBuilder();
    }

    public DruidDataSource build() {
        DruidDataSource dataSource = new DruidDataSource();
        this.maybeGetDriverClassName();
        this.bind(dataSource);
        return dataSource;
    }

    private void bind(DruidDataSource result) {
        MutablePropertyValues properties = new MutablePropertyValues(this.properties);
        new RelaxedDataBinder((Object)result).withAlias("url", new String[]{"jdbcUrl"}).withAlias("username", new String[]{"user"}).bind((PropertyValues)properties);
    }

    private void maybeGetDriverClassName() {
        if (!this.properties.containsKey("driverClassName") && this.properties.containsKey("url")) {
            String url = this.properties.get("url");
            String driverClass = DatabaseDriver.fromJdbcUrl((String)url).getDriverClassName();
            this.properties.put("driverClassName", driverClass);
        }
    }
}

