/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource;

import com.alibaba.fescar.core.exception.TransactionException;
import com.alibaba.fescar.core.exception.TransactionExceptionCode;
import com.alibaba.fescar.core.model.BranchStatus;
import com.alibaba.fescar.core.model.BranchType;
import com.alibaba.fescar.rm.datasource.AbstractConnectionProxy;
import com.alibaba.fescar.rm.datasource.ConnectionContext;
import com.alibaba.fescar.rm.datasource.DataSourceManager;
import com.alibaba.fescar.rm.datasource.DataSourceProxy;
import com.alibaba.fescar.rm.datasource.exec.LockConflictException;
import com.alibaba.fescar.rm.datasource.sql.SQLType;
import com.alibaba.fescar.rm.datasource.sql.struct.Field;
import com.alibaba.fescar.rm.datasource.sql.struct.TableRecords;
import com.alibaba.fescar.rm.datasource.undo.SQLUndoLog;
import com.alibaba.fescar.rm.datasource.undo.UndoLogManager;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionProxy
extends AbstractConnectionProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionProxy.class);
    private ConnectionContext context = new ConnectionContext();

    public ConnectionProxy(DataSourceProxy dataSourceProxy, Connection targetConnection, String dbType) {
        super(dataSourceProxy, targetConnection, dbType);
    }

    public ConnectionContext getContext() {
        return this.context;
    }

    public void bind(String xid) {
        this.context.bind(xid);
    }

    public void checkLock(TableRecords records) throws SQLException {
        String lockKeys = this.buildLockKey(records);
        try {
            boolean lockable = DataSourceManager.get().lockQuery(BranchType.AT, this.getDataSourceProxy().getResourceId(), this.context.getXid(), lockKeys);
            if (!lockable) {
                throw new LockConflictException();
            }
        }
        catch (TransactionException e) {
            this.recognizeLockKeyConflictException(e);
        }
    }

    public void register(TableRecords records) throws SQLException {
        String lockKeys = this.buildLockKey(records);
        try {
            DataSourceManager.get().branchRegister(BranchType.AT, this.getDataSourceProxy().getResourceId(), null, this.context.getXid(), lockKeys);
        }
        catch (TransactionException e) {
            this.recognizeLockKeyConflictException(e);
        }
    }

    private void recognizeLockKeyConflictException(TransactionException te) throws SQLException {
        if (te.getCode() == TransactionExceptionCode.LockKeyConflict) {
            throw new LockConflictException();
        }
        throw new SQLException(te);
    }

    public void prepareUndoLog(SQLType sqlType, String tableName, TableRecords beforeImage, TableRecords afterImage) throws SQLException {
        if (beforeImage.getRows().size() == 0 && afterImage.getRows().size() == 0) {
            return;
        }
        TableRecords lockKeyRecords = afterImage;
        if (sqlType == SQLType.DELETE) {
            lockKeyRecords = beforeImage;
        }
        String lockKeys = this.buildLockKey(lockKeyRecords);
        this.context.appendLockKey(lockKeys);
        SQLUndoLog sqlUndoLog = this.buildUndoItem(sqlType, tableName, beforeImage, afterImage);
        this.context.appendUndoItem(sqlUndoLog);
    }

    private SQLUndoLog buildUndoItem(SQLType sqlType, String tableName, TableRecords beforeImage, TableRecords afterImage) {
        SQLUndoLog sqlUndoLog = new SQLUndoLog();
        sqlUndoLog.setSqlType(sqlType);
        sqlUndoLog.setTableName(tableName);
        sqlUndoLog.setBeforeImage(beforeImage);
        sqlUndoLog.setAfterImage(afterImage);
        return sqlUndoLog;
    }

    private String buildLockKey(TableRecords rowsIncludingPK) {
        if (rowsIncludingPK.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(rowsIncludingPK.getTableMeta().getTableName());
        sb.append(":");
        boolean flag = false;
        for (Field field : rowsIncludingPK.pkRows()) {
            if (flag) {
                sb.append(",");
            } else {
                flag = true;
            }
            sb.append(field.getValue());
        }
        return sb.toString();
    }

    @Override
    public void commit() throws SQLException {
        if (this.context.inGlobalTransaction()) {
            try {
                this.register();
            }
            catch (TransactionException e) {
                this.recognizeLockKeyConflictException(e);
            }
            try {
                if (this.context.hasUndoLog()) {
                    UndoLogManager.flushUndoLogs(this);
                }
                this.targetConnection.commit();
            }
            catch (Throwable ex) {
                this.report(false);
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new SQLException(ex);
            }
            this.report(true);
            this.context.reset();
        } else {
            this.targetConnection.commit();
        }
    }

    private void register() throws TransactionException {
        Long branchId = DataSourceManager.get().branchRegister(BranchType.AT, this.getDataSourceProxy().getResourceId(), null, this.context.getXid(), this.context.buildLockKeys());
        this.context.setBranchId(branchId);
    }

    @Override
    public void rollback() throws SQLException {
        this.targetConnection.rollback();
        if (this.context.inGlobalTransaction() && this.context.isBranchRegistered()) {
            this.report(false);
        }
        this.context.reset();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit && !this.getAutoCommit()) {
            this.commit();
        }
        this.targetConnection.setAutoCommit(autoCommit);
    }

    private void report(boolean commitDone) throws SQLException {
        int retry = 5;
        while (retry > 0) {
            try {
                DataSourceManager.get().branchReport(this.context.getXid(), this.context.getBranchId(), commitDone ? BranchStatus.PhaseOne_Done : BranchStatus.PhaseOne_Failed, null);
                return;
            }
            catch (Throwable ex) {
                LOGGER.error("Failed to report [" + this.context.getBranchId() + "/" + this.context.getXid() + "] commit done [" + commitDone + "] Retry Countdown: " + retry);
                if (--retry != 0) continue;
                throw new SQLException("Failed to report branch status " + commitDone, ex);
            }
        }
    }
}

