/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource.exec;

import com.alibaba.fescar.rm.datasource.ConnectionProxy;
import com.alibaba.fescar.rm.datasource.StatementProxy;
import com.alibaba.fescar.rm.datasource.exec.BaseTransactionalExecutor;
import com.alibaba.fescar.rm.datasource.exec.LockConflictException;
import com.alibaba.fescar.rm.datasource.exec.LockRetryController;
import com.alibaba.fescar.rm.datasource.exec.StatementCallback;
import com.alibaba.fescar.rm.datasource.sql.SQLRecognizer;
import com.alibaba.fescar.rm.datasource.sql.struct.TableRecords;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDMLBaseExecutor<T, S extends Statement>
extends BaseTransactionalExecutor<T, S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDMLBaseExecutor.class);

    public AbstractDMLBaseExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    public T doExecute(Object ... args) throws Throwable {
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        if (connectionProxy.getAutoCommit()) {
            return this.executeAutoCommitTrue(args);
        }
        return this.executeAutoCommitFalse(args);
    }

    protected T executeAutoCommitFalse(Object[] args) throws Throwable {
        TableRecords beforeImage = this.beforeImage();
        Object result = this.statementCallback.execute(this.statementProxy.getTargetStatement(), args);
        TableRecords afterImage = this.afterImage(beforeImage);
        this.statementProxy.getConnectionProxy().prepareUndoLog(this.sqlRecognizer.getSQLType(), this.sqlRecognizer.getTableName(), beforeImage, afterImage);
        return result;
    }

    protected T executeAutoCommitTrue(Object[] args) throws Throwable {
        T result = null;
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        LockRetryController lockRetryController = new LockRetryController();
        try {
            connectionProxy.setAutoCommit(false);
            while (true) {
                try {
                    result = this.executeAutoCommitFalse(args);
                    connectionProxy.commit();
                }
                catch (LockConflictException lockConflict) {
                    lockRetryController.sleep(lockConflict);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("exception occur", (Throwable)e);
            throw e;
        }
        finally {
            connectionProxy.setAutoCommit(true);
        }
        return result;
    }

    protected abstract TableRecords beforeImage() throws SQLException;

    protected abstract TableRecords afterImage(TableRecords var1) throws SQLException;
}

