/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource.exec;

import com.alibaba.fescar.core.context.RootContext;
import com.alibaba.fescar.rm.datasource.StatementProxy;
import com.alibaba.fescar.rm.datasource.exec.Executor;
import com.alibaba.fescar.rm.datasource.exec.StatementCallback;
import com.alibaba.fescar.rm.datasource.sql.SQLRecognizer;
import com.alibaba.fescar.rm.datasource.sql.struct.Field;
import com.alibaba.fescar.rm.datasource.sql.struct.TableMeta;
import com.alibaba.fescar.rm.datasource.sql.struct.TableMetaCache;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public abstract class BaseTransactionalExecutor<T, S extends Statement>
implements Executor {
    protected StatementProxy<S> statementProxy;
    protected StatementCallback<T, S> statementCallback;
    protected SQLRecognizer sqlRecognizer;
    private TableMeta tableMeta;

    public BaseTransactionalExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        this.statementProxy = statementProxy;
        this.statementCallback = statementCallback;
        this.sqlRecognizer = sqlRecognizer;
    }

    public Object execute(Object ... args) throws Throwable {
        String xid = RootContext.getXID();
        this.statementProxy.getConnectionProxy().bind(xid);
        return this.doExecute(args);
    }

    protected abstract Object doExecute(Object ... var1) throws Throwable;

    protected String buildWhereConditionByPKs(List<Field> pkRows) throws SQLException {
        StringBuffer whereConditionAppender = new StringBuffer();
        for (int i = 0; i < pkRows.size(); ++i) {
            Field field = pkRows.get(i);
            whereConditionAppender.append(this.getColumnNameInSQL(field.getName()) + " = ?");
            if (i >= pkRows.size() - 1) continue;
            whereConditionAppender.append(" OR ");
        }
        return whereConditionAppender.toString();
    }

    protected String getColumnNameInSQL(String columnName) {
        String tableAlias = this.sqlRecognizer.getTableAlias();
        if (tableAlias == null) {
            return columnName;
        }
        return tableAlias + "." + columnName;
    }

    protected String getFromTableInSQL() {
        String tableName = this.sqlRecognizer.getTableName();
        String tableAlias = this.sqlRecognizer.getTableAlias();
        if (tableAlias == null) {
            return tableName;
        }
        return tableName + " " + tableAlias;
    }

    protected TableMeta getTableMeta() {
        return this.getTableMeta(this.sqlRecognizer.getTableName());
    }

    protected TableMeta getTableMeta(String tableName) {
        if (this.tableMeta != null) {
            return this.tableMeta;
        }
        this.tableMeta = TableMetaCache.getTableMeta(this.statementProxy.getConnectionProxy().getDataSourceProxy(), tableName);
        return this.tableMeta;
    }
}

