/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource.undo;

import com.alibaba.fescar.common.exception.NotSupportYetException;
import com.alibaba.fescar.common.util.BlobUtils;
import com.alibaba.fescar.common.util.StringUtils;
import com.alibaba.fescar.core.exception.TransactionException;
import com.alibaba.fescar.core.exception.TransactionExceptionCode;
import com.alibaba.fescar.rm.datasource.ConnectionContext;
import com.alibaba.fescar.rm.datasource.ConnectionProxy;
import com.alibaba.fescar.rm.datasource.DataSourceProxy;
import com.alibaba.fescar.rm.datasource.sql.struct.TableMeta;
import com.alibaba.fescar.rm.datasource.sql.struct.TableMetaCache;
import com.alibaba.fescar.rm.datasource.undo.AbstractUndoExecutor;
import com.alibaba.fescar.rm.datasource.undo.BranchUndoLog;
import com.alibaba.fescar.rm.datasource.undo.SQLUndoLog;
import com.alibaba.fescar.rm.datasource.undo.UndoExecutorFactory;
import com.alibaba.fescar.rm.datasource.undo.UndoLogParserFactory;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UndoLogManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UndoLogManager.class);
    private static String UNDO_LOG_TABLE_NAME = "undo_log";
    private static String INSERT_UNDO_LOG_SQL = "INSERT INTO " + UNDO_LOG_TABLE_NAME + "\n" + "\t(branch_id, xid, rollback_info, log_status, log_created, log_modified)\n" + "VALUES (?, ?, ?, 0, now(), now())";
    private static String DELETE_UNDO_LOG_SQL = "DELETE FROM " + UNDO_LOG_TABLE_NAME + "\n" + "\tWHERE branch_id = ? AND xid = ?";
    private static String SELECT_UNDO_LOG_SQL = "SELECT * FROM " + UNDO_LOG_TABLE_NAME + " WHERE log_status = 0 AND branch_id = ? AND xid = ? FOR UPDATE";

    private UndoLogManager() {
    }

    public static void flushUndoLogs(ConnectionProxy cp) throws SQLException {
        UndoLogManager.assertDbSupport(cp.getDbType());
        ConnectionContext connectionContext = cp.getContext();
        String xid = connectionContext.getXid();
        long branchID = connectionContext.getBranchId();
        BranchUndoLog branchUndoLog = new BranchUndoLog();
        branchUndoLog.setXid(xid);
        branchUndoLog.setBranchId(branchID);
        branchUndoLog.setSqlUndoLogs(connectionContext.getUndoItems());
        String undoLogContent = UndoLogParserFactory.getInstance().encode(branchUndoLog);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Flushing UNDO LOG: " + undoLogContent);
        }
        try (PreparedStatement pst = null;){
            pst = cp.getTargetConnection().prepareStatement(INSERT_UNDO_LOG_SQL);
            pst.setLong(1, branchID);
            pst.setString(2, xid);
            pst.setBlob(3, BlobUtils.string2blob((String)undoLogContent));
            pst.executeUpdate();
        }
    }

    private static void assertDbSupport(String dbType) {
        if (!"mysql".equals(dbType)) {
            throw new NotSupportYetException("DbType[" + dbType + "] is not support yet!");
        }
    }

    public static void undo(DataSourceProxy dataSourceProxy, String xid, long branchId) throws TransactionException {
        UndoLogManager.assertDbSupport(dataSourceProxy.getTargetDataSource().getDbType());
        Connection conn = null;
        ResultSet rs = null;
        Statement selectPST = null;
        try {
            conn = dataSourceProxy.getPlainConnection();
            conn.setAutoCommit(false);
            selectPST = conn.prepareStatement(SELECT_UNDO_LOG_SQL);
            selectPST.setLong(1, branchId);
            selectPST.setString(2, xid);
            rs = selectPST.executeQuery();
            while (rs.next()) {
                Blob b = rs.getBlob("rollback_info");
                String rollbackInfo = StringUtils.blob2string((Blob)b);
                BranchUndoLog branchUndoLog = UndoLogParserFactory.getInstance().decode(rollbackInfo);
                for (SQLUndoLog sqlUndoLog : branchUndoLog.getSqlUndoLogs()) {
                    TableMeta tableMeta = TableMetaCache.getTableMeta(dataSourceProxy, sqlUndoLog.getTableName());
                    sqlUndoLog.setTableMeta(tableMeta);
                    AbstractUndoExecutor undoExecutor = UndoExecutorFactory.getUndoExecutor(dataSourceProxy.getDbType(), sqlUndoLog);
                    undoExecutor.executeOn(conn);
                }
            }
            UndoLogManager.deleteUndoLog(xid, branchId, conn);
            conn.commit();
        }
        catch (Throwable e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException rollbackEx) {
                    LOGGER.warn("Failed to close JDBC resource while undo ... ", (Throwable)rollbackEx);
                }
            }
            throw new TransactionException(TransactionExceptionCode.BranchRollbackFailed_Retriable, String.format("%s/%s", branchId, xid), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (selectPST != null) {
                    selectPST.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException closeEx) {
                LOGGER.warn("Failed to close JDBC resource while undo ... ", (Throwable)closeEx);
            }
        }
    }

    public static void deleteUndoLog(String xid, long branchId, Connection conn) throws SQLException {
        PreparedStatement deletePST = conn.prepareStatement(DELETE_UNDO_LOG_SQL);
        deletePST.setLong(1, branchId);
        deletePST.setString(2, xid);
        deletePST.executeUpdate();
    }
}

