/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource.exec;

import com.alibaba.fescar.core.context.RootContext;
import com.alibaba.fescar.rm.datasource.StatementProxy;
import com.alibaba.fescar.rm.datasource.exec.DeleteExecutor;
import com.alibaba.fescar.rm.datasource.exec.Executor;
import com.alibaba.fescar.rm.datasource.exec.InsertExecutor;
import com.alibaba.fescar.rm.datasource.exec.PlainExecutor;
import com.alibaba.fescar.rm.datasource.exec.SelectForUpdateExecutor;
import com.alibaba.fescar.rm.datasource.exec.StatementCallback;
import com.alibaba.fescar.rm.datasource.exec.UpdateExecutor;
import com.alibaba.fescar.rm.datasource.sql.SQLRecognizer;
import com.alibaba.fescar.rm.datasource.sql.SQLVisitorFactory;
import java.sql.SQLException;
import java.sql.Statement;

public class ExecuteTemplate {
    public static <T, S extends Statement> T execute(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, Object ... args) throws SQLException {
        return ExecuteTemplate.execute(null, statementProxy, statementCallback, args);
    }

    public static <T, S extends Statement> T execute(SQLRecognizer sqlRecognizer, StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, Object ... args) throws SQLException {
        if (!RootContext.inGlobalTransaction()) {
            return statementCallback.execute(statementProxy.getTargetStatement(), args);
        }
        if (sqlRecognizer == null) {
            sqlRecognizer = SQLVisitorFactory.get(statementProxy.getTargetSQL(), statementProxy.getConnectionProxy().getDbType());
        }
        Executor executor = null;
        if (sqlRecognizer == null) {
            executor = new PlainExecutor<T, S>(statementProxy, statementCallback);
        } else {
            switch (sqlRecognizer.getSQLType()) {
                case INSERT: {
                    executor = new InsertExecutor((StatementProxy)statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case UPDATE: {
                    executor = new UpdateExecutor((StatementProxy)statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case DELETE: {
                    executor = new DeleteExecutor((StatementProxy)statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case SELECT_FOR_UPDATE: {
                    executor = new SelectForUpdateExecutor<S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                default: {
                    executor = new PlainExecutor<T, S>(statementProxy, statementCallback);
                }
            }
        }
        T rs = null;
        try {
            rs = executor.execute(args);
        }
        catch (Throwable ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            new SQLException(ex);
        }
        return rs;
    }
}

