/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource.undo.mysql;

import com.alibaba.fescar.common.exception.ShouldNeverHappenException;
import com.alibaba.fescar.rm.datasource.sql.struct.Field;
import com.alibaba.fescar.rm.datasource.sql.struct.KeyType;
import com.alibaba.fescar.rm.datasource.sql.struct.Row;
import com.alibaba.fescar.rm.datasource.sql.struct.TableRecords;
import com.alibaba.fescar.rm.datasource.undo.AbstractUndoExecutor;
import com.alibaba.fescar.rm.datasource.undo.SQLUndoLog;
import java.util.List;

public class MySQLUndoUpdateExecutor
extends AbstractUndoExecutor {
    @Override
    protected String buildUndoSQL() {
        TableRecords beforeImage = this.sqlUndoLog.getBeforeImage();
        List<Row> beforeImageRows = beforeImage.getRows();
        if (beforeImageRows == null || beforeImageRows.size() == 0) {
            throw new ShouldNeverHappenException("Invalid UNDO LOG");
        }
        Row row = beforeImageRows.get(0);
        StringBuffer mainSQL = new StringBuffer("UPDATE " + this.sqlUndoLog.getTableName() + " SET ");
        StringBuffer where = new StringBuffer(" WHERE ");
        boolean first = true;
        for (Field field : row.getFields()) {
            if (field.getKeyType() == KeyType.PrimaryKey) {
                where.append(field.getName() + " = ?");
                continue;
            }
            if (first) {
                first = false;
            } else {
                mainSQL.append(", ");
            }
            mainSQL.append(field.getName() + " = ?");
        }
        return mainSQL.append(where).toString();
    }

    public MySQLUndoUpdateExecutor(SQLUndoLog sqlUndoLog) {
        super(sqlUndoLog);
    }

    @Override
    protected TableRecords getUndoRows() {
        return this.sqlUndoLog.getBeforeImage();
    }
}

