/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.blink.dataformat;

import com.alibaba.blink.dataformat.BaseRow;
import com.alibaba.blink.dataformat.BinaryArray;
import com.alibaba.blink.dataformat.BinaryString;
import com.alibaba.blink.memory.MemorySegment;
import com.alibaba.blink.memory.MemorySegmentFactory;
import com.alibaba.blink.util.BinaryRowUtil;
import com.alibaba.blink.util.BitSetUtil;
import com.alibaba.blink.util.Preconditions;
import com.alibaba.blink.util.hash.Murmur32;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public final class BinaryRow
implements BaseRow {
    public static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private final int arity;
    private final int nullBitsSizeInBytes;
    private MemorySegment segment;
    private MemorySegment[] allSegments;
    private int baseOffset;
    private int sizeInBytes;

    public static int calculateBitSetWidthInBytes(int arity) {
        return (arity + 63 + 8) / 64 * 8;
    }

    public static int calculateFixPartSizeInBytes(int arity) {
        return BinaryRow.calculateBitSetWidthInBytes(arity) + 8 * arity;
    }

    public BinaryRow(int arity) {
        Preconditions.checkArgument(arity >= 0);
        this.arity = arity;
        this.nullBitsSizeInBytes = BinaryRow.calculateBitSetWidthInBytes(arity);
    }

    private int getFieldOffset(int pos) {
        return this.baseOffset + this.nullBitsSizeInBytes + pos * 8;
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.arity) : "index (" + index + ") should < " + this.arity;
    }

    public MemorySegment getMemorySegment() {
        return this.segment;
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public int getFixedLengthPartSize() {
        return this.nullBitsSizeInBytes + 8 * this.arity;
    }

    public MemorySegment[] getAllSegments() {
        return this.allSegments;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public boolean empty() {
        int num = this.getHeader() & 0x80;
        return num != 0;
    }

    @Override
    public byte getHeader() {
        return this.segment.get(this.baseOffset);
    }

    @Override
    public void setHeader(byte header) {
        this.segment.put(this.baseOffset, header);
    }

    public void pointTo(MemorySegment segment, int baseOffset, int sizeInBytes) {
        this.segment = segment;
        if (this.allSegments != null && this.allSegments.length == 1) {
            this.allSegments[0] = segment;
        } else {
            this.allSegments = new MemorySegment[]{segment};
        }
        this.baseOffset = baseOffset;
        this.sizeInBytes = sizeInBytes;
    }

    public void pointTo(MemorySegment[] segments, int baseOffset, int sizeInBytes) {
        this.segment = segments[0];
        this.allSegments = segments;
        this.baseOffset = baseOffset;
        this.sizeInBytes = sizeInBytes;
    }

    public void setTotalSize(int sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    private void setNotNullAt(int i) {
        this.assertIndexIsValid(i);
        BitSetUtil.clear(this.segment, this.baseOffset, i + 8);
    }

    @Override
    public void setNullAt(int i) {
        this.assertIndexIsValid(i);
        BitSetUtil.set(this.segment, this.baseOffset, i + 8);
        this.segment.putLong(this.getFieldOffset(i), 0L);
    }

    @Override
    public void setInt(int pos, int value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segment.putInt(this.getFieldOffset(pos), value);
    }

    @Override
    public void setLong(int pos, long value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segment.putLong(this.getFieldOffset(pos), value);
    }

    @Override
    public void setDouble(int pos, double value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        if (Double.isNaN(value)) {
            value = Double.NaN;
        }
        this.segment.putDouble(this.getFieldOffset(pos), value);
    }

    @Override
    public void setChar(int pos, char value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segment.putChar(this.getFieldOffset(pos), value);
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segment.putBoolean(this.getFieldOffset(pos), value);
    }

    @Override
    public void setShort(int pos, short value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segment.putShort(this.getFieldOffset(pos), value);
    }

    @Override
    public void setByte(int pos, byte value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segment.put(this.getFieldOffset(pos), value);
    }

    @Override
    public void setFloat(int pos, float value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        if (Float.isNaN(value)) {
            value = Float.NaN;
        }
        this.segment.putFloat(this.getFieldOffset(pos), value);
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return BitSetUtil.get(this.segment, this.baseOffset, pos + 8);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return this.segment.getBoolean(this.getFieldOffset(pos));
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return this.segment.get(this.getFieldOffset(pos));
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return this.segment.getShort(this.getFieldOffset(pos));
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return this.segment.getInt(this.getFieldOffset(pos));
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return this.segment.getLong(this.getFieldOffset(pos));
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return this.segment.getFloat(this.getFieldOffset(pos));
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return this.segment.getDouble(this.getFieldOffset(pos));
    }

    @Override
    public char getChar(int pos) {
        this.assertIndexIsValid(pos);
        return this.segment.getChar(this.getFieldOffset(pos));
    }

    @Override
    public BinaryString getBinaryString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndSize = this.segment.getLong(fieldOffset);
        BinaryString ret = new BinaryString();
        BinaryRow.getBinaryStringFromSeg(this.allSegments, this.baseOffset, fieldOffset, offsetAndSize, ret);
        return ret;
    }

    @Override
    public BinaryString getBinaryString(int pos, BinaryString reuse) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndSize = this.segment.getLong(fieldOffset);
        BinaryRow.getBinaryStringFromSeg(this.allSegments, this.baseOffset, fieldOffset, offsetAndSize, reuse);
        return reuse;
    }

    public static void getBinaryStringFromSeg(MemorySegment[] segments, int baseOffset, int fieldOffset, long offsetAndSize, BinaryString reuse) {
        long mark = offsetAndSize & Long.MIN_VALUE;
        if (mark == 0L) {
            int offset = (int)(offsetAndSize >> 32);
            int size = (int)offsetAndSize;
            reuse.pointTo(segments, baseOffset + offset, size);
        } else {
            int size = (int)((offsetAndSize & 0x7F00000000000000L) >>> 56);
            if (LITTLE_ENDIAN) {
                reuse.pointTo(segments, fieldOffset, size);
            } else {
                reuse.pointTo(segments, fieldOffset + 1, size);
            }
        }
    }

    @Override
    public String getString(int pos) {
        return this.getBinaryString(pos).toString();
    }

    @Override
    public BinaryArray getArray(int ordinal) {
        long offsetAndSize = this.getLong(ordinal);
        return BinaryRow.getArray(this.allSegments, this.baseOffset, offsetAndSize);
    }

    public static BinaryArray getArray(MemorySegment[] segments, int baseOffset, long offsetAndSize) {
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        BinaryArray array = new BinaryArray();
        array.pointTo(segments, offset + baseOffset, size);
        return array;
    }

    @Override
    public byte[] getByteArray(int ordinal) {
        int fieldOffset = this.getFieldOffset(ordinal);
        long offsetAndSize = this.segment.getLong(fieldOffset);
        return BinaryRow.getByteArray(this.allSegments, this.baseOffset, fieldOffset, offsetAndSize);
    }

    public static byte[] getByteArray(MemorySegment[] allSegments, int baseOffset, int fieldOffset, long offsetAndSize) {
        long mark = offsetAndSize & Long.MIN_VALUE;
        if (mark == 0L) {
            int offset = (int)(offsetAndSize >> 32);
            int size = (int)offsetAndSize;
            return BinaryRowUtil.copy(allSegments, baseOffset + offset, size);
        }
        int size = (int)((offsetAndSize & 0x7F00000000000000L) >>> 56);
        byte[] bytes = new byte[size];
        if (LITTLE_ENDIAN) {
            allSegments[0].get(fieldOffset, bytes, 0, size);
        } else {
            allSegments[0].get(fieldOffset + 1, bytes, 0, size);
        }
        return bytes;
    }

    public boolean anyNull() {
        for (int i = 0; i < this.nullBitsSizeInBytes; i += 8) {
            if (this.segment.getLong(i) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean anyNull(int[] fields) {
        for (int field : fields) {
            if (!this.isNullAt(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BinaryRow copy() {
        return this.copy(new BinaryRow(this.arity));
    }

    @Override
    public BinaryRow copy(BaseRow reuse) {
        return this.copyInternal((BinaryRow)reuse);
    }

    private BinaryRow copyInternal(BinaryRow reuse) {
        byte[] bytes = BinaryRowUtil.copy(this.allSegments, this.baseOffset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap(bytes), 0, this.sizeInBytes);
        return reuse;
    }

    public String toString() {
        if (this.segment == null) {
            return "null";
        }
        StringBuilder build = new StringBuilder();
        for (int i = 0; i < this.getFixedLengthPartSize(); i += 8) {
            if (i != 0) {
                build.append(',');
            }
            build.append(Long.toHexString(this.segment.getLong(this.baseOffset + i)));
        }
        return build.toString();
    }

    public boolean equals(Object o) {
        return this.equalsFrom(o, 0);
    }

    @Override
    public boolean equalsWithoutHeader(BaseRow o) {
        return this.equalsFrom(o, 1);
    }

    private boolean equalsFrom(Object o, int startIndex) {
        if (o != null && o instanceof BinaryRow) {
            BinaryRow other = (BinaryRow)o;
            return this.sizeInBytes == other.sizeInBytes && BinaryRowUtil.equals(this.allSegments, this.baseOffset + startIndex, other.allSegments, other.baseOffset + startIndex, this.sizeInBytes - startIndex);
        }
        return false;
    }

    public int hashCode() {
        if (this.allSegments.length == 1) {
            return Murmur32.hashBytesByWords(this.segment, this.baseOffset, this.sizeInBytes, 42);
        }
        return this.hashSlow();
    }

    private int hashSlow() {
        byte[] bytes = new byte[this.sizeInBytes];
        BinaryRowUtil.copySlow(this.allSegments, this.baseOffset, bytes, this.sizeInBytes);
        return Murmur32.hashBytesByWords(MemorySegmentFactory.wrap(bytes), 0, this.sizeInBytes, 42);
    }

    public void unbindMemorySegment() {
        this.segment = null;
        this.allSegments = null;
        this.baseOffset = 0;
        this.sizeInBytes = 0;
    }

    public byte[] serializeToBytes() {
        int sizeInBytes = this.getSizeInBytes();
        int offset = this.getBaseOffset();
        byte[] dst = new byte[sizeInBytes];
        int dst_offset = 0;
        for (MemorySegment segment : this.getAllSegments()) {
            int remain = segment.size() - offset;
            int copySize = Math.min(remain, sizeInBytes);
            segment.get(offset, dst, dst_offset, copySize);
            sizeInBytes -= copySize;
            offset = 0;
            dst_offset += copySize;
        }
        return dst;
    }

    public ByteBuffer toByteBuffer() {
        int sizeInBytes = this.getSizeInBytes();
        int offset = this.getBaseOffset();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(sizeInBytes);
        for (MemorySegment segment : this.getAllSegments()) {
            int remain = segment.size() - offset;
            int copySize = Math.min(remain, sizeInBytes);
            segment.get(offset, byteBuffer, copySize);
            sizeInBytes -= copySize;
            offset = 0;
        }
        return byteBuffer;
    }

    public String serializeToString() {
        byte[] bytes = this.serializeToBytes();
        String s = new String(bytes, StandardCharsets.UTF_8);
        return s;
    }
}

