/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.blink.dataformat;

import com.alibaba.blink.memory.MemorySegment;
import com.alibaba.blink.util.BinaryRowUtil;
import java.nio.ByteOrder;

public class MultiSegUtil {
    public static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final int BIT_BYTE_POSITION_MASK = -8;
    private static final int BIT_BYTE_INDEX_MASK = 7;

    public static void bitUnSet(MemorySegment[] segments, int baseOffset, int index) {
        if (segments.length == 1) {
            MemorySegment segment = segments[0];
            int offset = baseOffset + ((index & 0xFFFFFFF8) >>> 3);
            byte current = segment.get(offset);
            current = (byte)(current & ~(1 << (index & 7)));
            segment.put(offset, current);
        } else {
            MultiSegUtil.bitUnSetMultiSeg(segments, baseOffset, index);
        }
    }

    private static void bitUnSetMultiSeg(MemorySegment[] segments, int baseOffset, int index) {
        int offset = baseOffset + ((index & 0xFFFFFFF8) >>> 3);
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        MemorySegment segment = segments[segIndex];
        byte current = segment.get(segOffset);
        current = (byte)(current & ~(1 << (index & 7)));
        segment.put(segOffset, current);
    }

    public static void bitSet(MemorySegment[] segments, int baseOffset, int index) {
        if (segments.length == 1) {
            int offset = baseOffset + ((index & 0xFFFFFFF8) >>> 3);
            MemorySegment segment = segments[0];
            byte current = segment.get(offset);
            current = (byte)(current | 1 << (index & 7));
            segment.put(offset, current);
        } else {
            MultiSegUtil.bitSetMultiSeg(segments, baseOffset, index);
        }
    }

    private static void bitSetMultiSeg(MemorySegment[] segments, int baseOffset, int index) {
        int offset = baseOffset + ((index & 0xFFFFFFF8) >>> 3);
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        MemorySegment segment = segments[segIndex];
        byte current = segment.get(segOffset);
        current = (byte)(current | 1 << (index & 7));
        segment.put(segOffset, current);
    }

    public static boolean bitGet(MemorySegment[] segments, int baseOffset, int index) {
        int offset = baseOffset + ((index & 0xFFFFFFF8) >>> 3);
        byte current = MultiSegUtil.getByte(segments, offset);
        return (current & 1 << (index & 7)) != 0;
    }

    public static boolean getBoolean(MemorySegment[] segments, int offset) {
        if (segments.length == 1) {
            return segments[0].getBoolean(offset);
        }
        return MultiSegUtil.getBooleanMultiSeg(segments, offset);
    }

    private static boolean getBooleanMultiSeg(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        return segments[segIndex].getBoolean(segOffset);
    }

    public static void setBoolean(MemorySegment[] segments, int offset, boolean value) {
        if (segments.length == 1) {
            segments[0].putBoolean(offset, value);
        } else {
            MultiSegUtil.setBooleanMultiSeg(segments, offset, value);
        }
    }

    private static void setBooleanMultiSeg(MemorySegment[] segments, int offset, boolean value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        segments[segIndex].putBoolean(segOffset, value);
    }

    public static byte getByte(MemorySegment[] segments, int offset) {
        if (segments.length == 1) {
            return segments[0].get(offset);
        }
        return MultiSegUtil.getByteMultiSeg(segments, offset);
    }

    private static byte getByteMultiSeg(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        return segments[segIndex].get(segOffset);
    }

    public static void setByte(MemorySegment[] segments, int offset, byte value) {
        if (segments.length == 1) {
            segments[0].put(offset, value);
        } else {
            MultiSegUtil.setByteMultiSeg(segments, offset, value);
        }
    }

    private static void setByteMultiSeg(MemorySegment[] segments, int offset, byte value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        segments[segIndex].put(segOffset, value);
    }

    public static int getInt(MemorySegment[] segments, int offset) {
        if (segments.length == 1) {
            return segments[0].getInt(offset);
        }
        return MultiSegUtil.getIntMultiSeg(segments, offset);
    }

    private static int getIntMultiSeg(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 3) {
            return segments[segIndex].getInt(segOffset);
        }
        return MultiSegUtil.getIntSlowly(segments, segSize, segIndex, segOffset);
    }

    private static int getIntSlowly(MemorySegment[] segments, int segSize, int segNum, int segOffset) {
        MemorySegment segment = segments[segNum];
        int ret = 0;
        for (int i = 0; i < 4; ++i) {
            if (segOffset == segSize) {
                segment = segments[++segNum];
                segOffset = 0;
            }
            int unsignedByte = segment.get(segOffset) & 0xFF;
            ret = LITTLE_ENDIAN ? (ret |= unsignedByte << i * 8) : (ret |= unsignedByte << (3 - i) * 8);
            ++segOffset;
        }
        return ret;
    }

    public static void setInt(MemorySegment[] segments, int offset, int value) {
        if (segments.length == 1) {
            segments[0].putInt(offset, value);
        } else {
            MultiSegUtil.setIntMultiSeg(segments, offset, value);
        }
    }

    private static void setIntMultiSeg(MemorySegment[] segments, int offset, int value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 3) {
            segments[segIndex].putInt(segOffset, value);
        } else {
            MultiSegUtil.setIntSlowly(segments, segSize, segIndex, segOffset, value);
        }
    }

    private static void setIntSlowly(MemorySegment[] segments, int segSize, int segNum, int segOffset, int value) {
        MemorySegment segment = segments[segNum];
        for (int i = 0; i < 4; ++i) {
            if (segOffset == segSize) {
                segment = segments[++segNum];
                segOffset = 0;
            }
            int unsignedByte = LITTLE_ENDIAN ? value >> i * 8 : value >> (3 - i) * 8;
            segment.put(segOffset, (byte)unsignedByte);
            ++segOffset;
        }
    }

    public static long getLong(MemorySegment[] segments, int offset) {
        if (segments.length == 1) {
            return segments[0].getLong(offset);
        }
        return MultiSegUtil.getLongMultiSeg(segments, offset);
    }

    private static long getLongMultiSeg(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 7) {
            return segments[segIndex].getLong(segOffset);
        }
        return MultiSegUtil.getLongSlowly(segments, segSize, segIndex, segOffset);
    }

    private static long getLongSlowly(MemorySegment[] segments, int segSize, int segNum, int segOffset) {
        MemorySegment segment = segments[segNum];
        long ret = 0L;
        for (int i = 0; i < 8; ++i) {
            if (segOffset == segSize) {
                segment = segments[++segNum];
                segOffset = 0;
            }
            long unsignedByte = segment.get(segOffset) & 0xFF;
            ret = LITTLE_ENDIAN ? (ret |= unsignedByte << i * 8) : (ret |= unsignedByte << (7 - i) * 8);
            ++segOffset;
        }
        return ret;
    }

    public static void setLong(MemorySegment[] segments, int offset, long value) {
        if (segments.length == 1) {
            segments[0].putLong(offset, value);
        } else {
            MultiSegUtil.setLongMultiSeg(segments, offset, value);
        }
    }

    private static void setLongMultiSeg(MemorySegment[] segments, int offset, long value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 7) {
            segments[segIndex].putLong(segOffset, value);
        } else {
            MultiSegUtil.setLongSlowly(segments, segSize, segIndex, segOffset, value);
        }
    }

    private static void setLongSlowly(MemorySegment[] segments, int segSize, int segNum, int segOffset, long value) {
        MemorySegment segment = segments[segNum];
        for (int i = 0; i < 8; ++i) {
            if (segOffset == segSize) {
                segment = segments[++segNum];
                segOffset = 0;
            }
            long unsignedByte = LITTLE_ENDIAN ? value >> i * 8 : value >> (7 - i) * 8;
            segment.put(segOffset, (byte)unsignedByte);
            ++segOffset;
        }
    }

    public static short getShort(MemorySegment[] segments, int offset) {
        if (segments.length == 1) {
            return segments[0].getShort(offset);
        }
        return MultiSegUtil.getShortMultiSeg(segments, offset);
    }

    private static short getShortMultiSeg(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 1) {
            return segments[segIndex].getShort(segOffset);
        }
        return (short)MultiSegUtil.get2ByteSlowly(segments, segSize, segIndex, segOffset);
    }

    public static void setShort(MemorySegment[] segments, int offset, short value) {
        if (segments.length == 1) {
            segments[0].putShort(offset, value);
        } else {
            MultiSegUtil.setShortMultiSeg(segments, offset, value);
        }
    }

    private static void setShortMultiSeg(MemorySegment[] segments, int offset, short value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 1) {
            segments[segIndex].putShort(segOffset, value);
        } else {
            MultiSegUtil.set2ByteSlowly(segments, segSize, segIndex, segOffset, value, value >> 8);
        }
    }

    public static float getFloat(MemorySegment[] segments, int offset) {
        if (segments.length == 1) {
            return segments[0].getFloat(offset);
        }
        return MultiSegUtil.getFloatMultiSeg(segments, offset);
    }

    private static float getFloatMultiSeg(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 3) {
            return segments[segIndex].getFloat(segOffset);
        }
        return Float.intBitsToFloat(MultiSegUtil.getIntSlowly(segments, segSize, segIndex, segOffset));
    }

    public static void setFloat(MemorySegment[] segments, int offset, float value) {
        if (segments.length == 1) {
            segments[0].putFloat(offset, value);
        } else {
            MultiSegUtil.setFloatMultiSeg(segments, offset, value);
        }
    }

    private static void setFloatMultiSeg(MemorySegment[] segments, int offset, float value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 3) {
            segments[segIndex].putFloat(segOffset, value);
        } else {
            MultiSegUtil.setIntSlowly(segments, segSize, segIndex, segOffset, Float.floatToRawIntBits(value));
        }
    }

    public static double getDouble(MemorySegment[] segments, int offset) {
        if (segments.length == 1) {
            return segments[0].getDouble(offset);
        }
        return MultiSegUtil.getDoubleMultiSeg(segments, offset);
    }

    private static double getDoubleMultiSeg(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 7) {
            return segments[segIndex].getDouble(segOffset);
        }
        return Double.longBitsToDouble(MultiSegUtil.getLongSlowly(segments, segSize, segIndex, segOffset));
    }

    public static void setDouble(MemorySegment[] segments, int offset, double value) {
        if (segments.length == 1) {
            segments[0].putDouble(offset, value);
        } else {
            MultiSegUtil.setDoubleMultiSeg(segments, offset, value);
        }
    }

    private static void setDoubleMultiSeg(MemorySegment[] segments, int offset, double value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 7) {
            segments[segIndex].putDouble(segOffset, value);
        } else {
            MultiSegUtil.setLongSlowly(segments, segSize, segIndex, segOffset, Double.doubleToRawLongBits(value));
        }
    }

    public static char getChar(MemorySegment[] segments, int offset) {
        if (segments.length == 1) {
            return segments[0].getChar(offset);
        }
        return MultiSegUtil.getCharMultiSeg(segments, offset);
    }

    private static char getCharMultiSeg(MemorySegment[] segments, int offset) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 1) {
            return segments[segIndex].getChar(segOffset);
        }
        return (char)MultiSegUtil.get2ByteSlowly(segments, segSize, segIndex, segOffset);
    }

    private static int get2ByteSlowly(MemorySegment[] segments, int segSize, int segNum, int segOffset) {
        MemorySegment segment = segments[segNum];
        int ret = 0;
        for (int i = 0; i < 2; ++i) {
            if (segOffset == segSize) {
                segment = segments[++segNum];
                segOffset = 0;
            }
            int unsignedByte = segment.get(segOffset) & 0xFF;
            ret = LITTLE_ENDIAN ? (ret |= unsignedByte << i * 8) : (ret |= unsignedByte << (1 - i) * 8);
            ++segOffset;
        }
        return ret;
    }

    public static void setChar(MemorySegment[] segments, int offset, char value) {
        if (segments.length == 1) {
            segments[0].putChar(offset, value);
        } else {
            MultiSegUtil.setCharMultiSeg(segments, offset, value);
        }
    }

    private static void setCharMultiSeg(MemorySegment[] segments, int offset, char value) {
        int segSize = segments[0].size();
        int segIndex = offset / segSize;
        int segOffset = offset - segIndex * segSize;
        if (segOffset < segSize - 3) {
            segments[segIndex].putChar(segOffset, value);
        } else {
            MultiSegUtil.set2ByteSlowly(segments, segSize, segIndex, segOffset, value, value >> 8);
        }
    }

    private static void set2ByteSlowly(MemorySegment[] segments, int segSize, int segNum, int segOffset, int b1, int b2) {
        MemorySegment segment = segments[segNum];
        segment.put(segOffset, (byte)(LITTLE_ENDIAN ? b1 : b2));
        if (++segOffset == segSize) {
            segment = segments[++segNum];
            segOffset = 0;
        }
        segment.put(segOffset, (byte)(LITTLE_ENDIAN ? b2 : b1));
    }

    public static byte[] getBytes(MemorySegment[] segments, int baseOffset, int sizeInBytes) {
        if (segments.length == 1) {
            byte[] heapMemory = segments[0].getHeapMemory();
            if (baseOffset == 0 && heapMemory != null && heapMemory.length == sizeInBytes) {
                return heapMemory;
            }
            byte[] bytes = new byte[sizeInBytes];
            segments[0].get(baseOffset, bytes, 0, sizeInBytes);
            return bytes;
        }
        byte[] bytes = new byte[sizeInBytes];
        BinaryRowUtil.copySlow(segments, baseOffset, bytes, 0, sizeInBytes);
        return bytes;
    }
}

