/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.blink.util;

import com.alibaba.blink.memory.MemorySegment;
import com.alibaba.blink.util.Preconditions;

public final class BitSetUtil {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final int WORD_SIZE = 8;

    public static boolean get(MemorySegment segment, int offset, int index) {
        Preconditions.checkArgument(index >= 0, "index < 0");
        return (segment.getLong(offset + BitSetUtil.wordBytesIndex(index)) & 1L << index) != 0L;
    }

    public static void set(MemorySegment segment, int offset, int index) {
        Preconditions.checkArgument(index >= 0, "index < 0");
        int wordOffset = offset + BitSetUtil.wordBytesIndex(index);
        long word = segment.getLong(wordOffset);
        segment.putLong(wordOffset, word | 1L << index);
    }

    public static void clear(MemorySegment segment, int offset, int index) {
        Preconditions.checkArgument(index >= 0, "index < 0");
        int wordOffset = offset + BitSetUtil.wordBytesIndex(index);
        long word = segment.getLong(wordOffset);
        segment.putLong(wordOffset, word & (1L << index ^ 0xFFFFFFFFFFFFFFFFL));
    }

    private static int wordBytesIndex(int bitIndex) {
        return (bitIndex >> 6) * 8;
    }
}

