/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.action;

import com.alibaba.hologres.client.exception.ExceptionCode;
import com.alibaba.hologres.client.exception.HoloClientException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;

public abstract class AbstractAction<T> {
    CompletableFuture<T> future = new CompletableFuture();
    Semaphore semaphore;

    public CompletableFuture<T> getFuture() {
        return this.future;
    }

    public T getResult() throws HoloClientException {
        try {
            return this.future.get();
        }
        catch (InterruptedException e) {
            throw new HoloClientException(ExceptionCode.INTERNAL_ERROR, "interrupt", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof HoloClientException) {
                throw (HoloClientException)cause;
            }
            throw new HoloClientException(ExceptionCode.INTERNAL_ERROR, "", cause);
        }
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    public void setSemaphore(Semaphore semaphore) {
        this.semaphore = semaphore;
    }
}

