/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.collector;

import com.alibaba.hologres.client.impl.collector.BatchState;
import java.util.concurrent.atomic.AtomicInteger;

public class CollectorStatistics {
    AtomicInteger fullBatchCount = new AtomicInteger(0);
    AtomicInteger notFullBatchCount = new AtomicInteger(0);
    long nanoTime = System.nanoTime();

    public void add(BatchState state) {
        switch (state) {
            case SizeEnough: 
            case ByteSizeEnough: 
            case ByteSizeCondition: {
                this.fullBatchCount.incrementAndGet();
                break;
            }
            case NotEnough: {
                break;
            }
            default: {
                this.notFullBatchCount.incrementAndGet();
            }
        }
    }

    public int getFullBatchCount() {
        return this.fullBatchCount.get();
    }

    public int getNotFullBatchCount() {
        return this.notFullBatchCount.get();
    }

    public long getNanoTime() {
        return this.nanoTime;
    }

    public void clear() {
        this.fullBatchCount.set(0);
        this.notFullBatchCount.set(0);
        this.nanoTime = System.nanoTime();
    }
}

