/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.collector.shard;

import com.alibaba.hologres.client.impl.collector.shard.ShardPolicy;
import com.alibaba.hologres.client.impl.util.ShardUtil;
import com.alibaba.hologres.client.model.Record;
import java.util.concurrent.ConcurrentSkipListMap;

public class DistributionKeyShardPolicy
implements ShardPolicy {
    private ConcurrentSkipListMap<Integer, Integer> splitRange = new ConcurrentSkipListMap();

    @Override
    public void init(int shardCount) {
        this.splitRange.clear();
        int[][] range = ShardUtil.split(shardCount);
        for (int i = 0; i < shardCount; ++i) {
            this.splitRange.put(range[i][0], i);
        }
    }

    @Override
    public int locate(Record record) {
        int raw = ShardUtil.hash(record, record.getSchema().getDistributionKeyIndex());
        int hash = Integer.remainderUnsigned(raw, 65536);
        return this.splitRange.floorEntry(hash).getValue();
    }
}

