/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.impl.ConnectionHolder;
import com.alibaba.hologres.client.impl.action.CopyAction;
import com.alibaba.hologres.client.impl.copy.CopyContext;
import com.alibaba.hologres.client.impl.copy.InternalPipedOutputStream;
import com.alibaba.hologres.client.impl.handler.ActionHandler;
import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.utils.IdentifierUtil;
import com.alibaba.hologres.org.postgresql.copy.CopyIn;
import com.alibaba.hologres.org.postgresql.copy.CopyManager;
import com.alibaba.hologres.org.postgresql.copy.CopyOut;
import com.alibaba.hologres.org.postgresql.jdbc.PgConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyActionHandler
extends ActionHandler<CopyAction> {
    public static final Logger LOGGER = LoggerFactory.getLogger(CopyActionHandler.class);
    private static final String NAME = "copy";
    private final HoloConfig config;
    private final ConnectionHolder connectionHolder;

    public CopyActionHandler(ConnectionHolder connectionHolder, HoloConfig config) {
        super(config);
        this.config = config;
        this.connectionHolder = connectionHolder;
    }

    public long doCopyOut(CopyContext copyContext, OutputStream to) throws SQLException, IOException {
        CopyOut cp = (CopyOut)copyContext.getCopyOperation();
        try {
            byte[] buf;
            while ((buf = cp.readFromCopy()) != null) {
                to.write(buf);
            }
            long l = cp.getHandledRowCount();
            return l;
        }
        catch (IOException ioEX) {
            copyContext.cancel();
            try {
                byte[] buf;
                while ((buf = cp.readFromCopy()) != null) {
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw ioEX;
        }
        finally {
            copyContext.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doCopyIn(CopyContext copyContext, InputStream from, int bufferSize) throws SQLException, IOException {
        CopyIn cp = (CopyIn)copyContext.getCopyOperation();
        byte[] buf = new byte[bufferSize];
        try {
            int len;
            while ((len = from.read(buf)) >= 0) {
                if (len <= 0) continue;
                cp.writeToCopy(buf, 0, len);
            }
            long l = cp.endCopy();
            return l;
        }
        finally {
            if (from instanceof PipedInputStream) {
                from.close();
            }
            copyContext.cancel();
        }
    }

    @Override
    public void handle(CopyAction action) {
        try {
            action.getFuture().complete((Long)this.connectionHolder.retryExecute(arg_0 -> this.lambda$handle$0(action, arg_0), 1));
        }
        catch (HoloClientException e) {
            action.getFuture().completeExceptionally(e);
        }
    }

    @Override
    public String getCostMsMetricName() {
        return "copy_cost_ms";
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ Object lambda$handle$0(CopyAction action, PgConnection conn) throws SQLException {
        pgConn = conn.unwrap(PgConnection.class);
        manager = new CopyManager(pgConn);
        schema = action.getSchema();
        os = action.getOs();
        try {
            ret = -1L;
            switch (1.$SwitchMap$com$alibaba$hologres$client$impl$action$CopyAction$Mode[action.getMode().ordinal()]) {
                case 1: {
                    try {
                        sb = new StringBuilder();
                        sb.append("COPY (select ");
                        first = true;
                        for (Column column : schema.getColumnSchema()) {
                            if (!first) {
                                sb.append(",");
                            }
                            first = false;
                            sb.append(IdentifierUtil.quoteIdentifier(column.getName(), true));
                        }
                        sb.append(" from ").append(schema.getTableNameObj().getFullName());
                        if (action.getStartShardId() > -1 && action.getEndShardId() > -1) {
                            sb.append(" where hg_shard_id>=").append(action.getStartShardId()).append(" and hg_shard_id<").append(action.getEndShardId());
                        }
                        sb.append(") TO STDOUT DELIMITER ',' ESCAPE '\\' CSV QUOTE '\"' NULL AS 'N'");
                        sql = sb.toString();
                        CopyActionHandler.LOGGER.info("copy sql:{}", (Object)sql);
                        os = action.getOs();
                        copyOut = manager.copyOut(sql);
                        copyContext = new CopyContext(conn, copyOut);
                        action.getReadyToStart().complete(new CopyContext(conn, copyOut));
                        rowCount = this.doCopyOut(copyContext, os);
                        if (os instanceof InternalPipedOutputStream) {
                            os.close();
                        }
                        ret = rowCount;
                        break;
                    }
                    catch (Exception e) {
                        action.getReadyToStart().completeExceptionally(e);
                        throw e;
                    }
                }
                case 2: {
                    if (action.getStartShardId() > -1 && action.getEndShardId() > -1) {
                        sql = new StringBuilder("set hg_experimental_target_shard_list='");
                        first = true;
                        for (i = action.getStartShardId(); i < action.getEndShardId(); ++i) {
                            if (!first) {
                                sql.append(",");
                            }
                            first = false;
                            sql.append(i);
                        }
                        sql.append("'");
                        try {
                            stat = pgConn.createStatement();
                            copyOut = null;
                            try {
                                stat.execute(sql.toString());
                            }
                            catch (Throwable var13_28) {
                                copyOut = var13_28;
                                throw var13_28;
                            }
                            finally {
                                if (stat != null) {
                                    if (copyOut != null) {
                                        try {
                                            stat.close();
                                        }
                                        catch (Throwable var13_27) {
                                            copyOut.addSuppressed(var13_27);
                                        }
                                    } else {
                                        stat.close();
                                    }
                                }
                            }
                        }
                        catch (SQLException e) {
                            CopyActionHandler.LOGGER.error("", (Throwable)e);
                        }
                    }
                    sb = new StringBuilder();
                    sb.append("COPY ").append(schema.getTableNameObj().getFullName());
                    sb.append(" FROM STDIN DELIMITER ',' ESCAPE '\\' CSV QUOTE '\"' NULL AS 'N'");
                    sql = sb.toString();
                    CopyActionHandler.LOGGER.info("copy sql:{}", (Object)sql);
                    copyIn = manager.copyIn(sql);
                    copyContext = new CopyContext(conn, copyIn);
                    action.getReadyToStart().complete(copyContext);
                    ret = this.doCopyIn(copyContext, action.getIs(), action.getBufferSize() > -1 ? action.getBufferSize() : this.config.getCopyInBufferSize());
                    if (action.getStartShardId() <= -1 || action.getEndShardId() <= -1) break;
                    stat = pgConn.createStatement();
                    var10_15 = null;
                    stat.execute("reset hg_experimental_target_shard_list");
                    if (stat == null) break;
                    if (var10_15 == null) ** GOTO lbl109
                    try {
                        stat.close();
                    }
                    catch (Throwable var11_20) {
                        var10_15.addSuppressed(var11_20);
                    }
                    break;
lbl109:
                    // 1 sources

                    stat.close();
                    break;
                    catch (Throwable var11_21) {
                        try {
                            var10_15 = var11_21;
                            throw var11_21;
                        }
                        catch (Throwable var18_33) {
                            if (stat != null) {
                                if (var10_15 != null) {
                                    try {
                                        stat.close();
                                    }
                                    catch (Throwable var19_34) {
                                        var10_15.addSuppressed(var19_34);
                                    }
                                } else {
                                    stat.close();
                                }
                            }
                            throw var18_33;
                        }
                    }
                    catch (Exception e) {
                        try {
                            action.getReadyToStart().completeExceptionally(e);
                            throw e;
                        }
                        catch (Throwable var20_35) {
                            if (action.getStartShardId() > -1 && action.getEndShardId() > -1) {
                                stat = pgConn.createStatement();
                                var22_37 = null;
                                try {
                                    stat.execute("reset hg_experimental_target_shard_list");
                                }
                                catch (Throwable var23_39) {
                                    var22_37 = var23_39;
                                    throw var23_39;
                                }
                                finally {
                                    if (stat != null) {
                                        if (var22_37 != null) {
                                            try {
                                                stat.close();
                                            }
                                            catch (Throwable var23_38) {
                                                var22_37.addSuppressed(var23_38);
                                            }
                                        } else {
                                            stat.close();
                                        }
                                    }
                                }
                            }
                            throw var20_35;
                        }
                    }
                }
                default: {
                    throw new SQLException("copy but InputStream and OutputStream both null");
                }
            }
            return ret;
        }
        catch (Exception e) {
            if (os instanceof InternalPipedOutputStream) {
                try {
                    os.close();
                }
                catch (IOException var8_42) {
                    // empty catch block
                }
            }
            throw new SQLException(e);
        }
    }
}

