/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.impl.ConnectionHolder;
import com.alibaba.hologres.client.impl.action.MetaAction;
import com.alibaba.hologres.client.impl.handler.ActionHandler;
import com.alibaba.hologres.client.impl.util.ConnectionUtil;
import java.sql.SQLException;

public class MetaActionHandler
extends ActionHandler<MetaAction> {
    private static final String NAME = "meta";
    private final HoloConfig config;
    private final ConnectionHolder connectionHolder;

    public MetaActionHandler(ConnectionHolder connectionHolder, HoloConfig config) {
        super(config);
        this.config = config;
        this.connectionHolder = connectionHolder;
    }

    @Override
    public void handle(MetaAction action) {
        try {
            action.getFuture().complete(this.connectionHolder.retryExecuteWithVersion(connWithVersion -> {
                if (this.config.isRefreshMetaBeforeGetTableSchema() && this.config.getRefreshMetaTimeout() > 0) {
                    String fullTableName = action.getTableName().getFullName();
                    ConnectionUtil.CheckMetaResult result = ConnectionUtil.checkMeta(connWithVersion.getConn(), connWithVersion.getVersion(), fullTableName, this.config.getRefreshMetaTimeout());
                    if (!result.isUpdated()) {
                        throw new SQLException("mismatches the version of the table [" + fullTableName + "]:" + result.getMsg());
                    }
                }
                return ConnectionUtil.getTableSchema(connWithVersion.getConn(), action.getTableName());
            }));
        }
        catch (HoloClientException e) {
            action.getFuture().completeExceptionally(e);
        }
    }

    @Override
    public String getCostMsMetricName() {
        return "meta_cost_ms";
    }
}

