/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import com.alibaba.hologres.org.postgresql.util.PSQLException;
import com.alibaba.hologres.org.postgresql.util.PSQLState;
import java.sql.SQLException;

public class JdbcBooleanColumnValues
extends JdbcColumnValues {
    Boolean[] array;

    public JdbcBooleanColumnValues(TimestampUtils timestampUtils, int rowCount) {
        super(timestampUtils, rowCount);
        this.array = new Boolean[rowCount];
    }

    @Override
    public void doSet(int row, Object obj) throws SQLException {
        this.array[row] = JdbcBooleanColumnValues.castToBoolean(obj);
    }

    static boolean castToBoolean(Object in) throws PSQLException {
        if (in instanceof Boolean) {
            return (Boolean)in;
        }
        if (in instanceof String) {
            return JdbcBooleanColumnValues.fromString((String)in);
        }
        if (in instanceof Character) {
            return JdbcBooleanColumnValues.fromCharacter((Character)in);
        }
        if (in instanceof Number) {
            return JdbcBooleanColumnValues.fromNumber((Number)in);
        }
        throw new PSQLException("Cannot cast to boolean", PSQLState.CANNOT_COERCE);
    }

    static boolean fromString(String strval) throws PSQLException {
        String val = strval.trim();
        if ("1".equals(val) || "true".equalsIgnoreCase(val) || "t".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val) || "y".equalsIgnoreCase(val) || "on".equalsIgnoreCase(val)) {
            return true;
        }
        if ("0".equals(val) || "false".equalsIgnoreCase(val) || "f".equalsIgnoreCase(val) || "no".equalsIgnoreCase(val) || "n".equalsIgnoreCase(val) || "off".equalsIgnoreCase(val)) {
            return false;
        }
        throw JdbcBooleanColumnValues.cannotCoerceException(strval);
    }

    private static boolean fromCharacter(Character charval) throws PSQLException {
        if ('1' == charval.charValue() || 't' == charval.charValue() || 'T' == charval.charValue() || 'y' == charval.charValue() || 'Y' == charval.charValue()) {
            return true;
        }
        if ('0' == charval.charValue() || 'f' == charval.charValue() || 'F' == charval.charValue() || 'n' == charval.charValue() || 'N' == charval.charValue()) {
            return false;
        }
        throw JdbcBooleanColumnValues.cannotCoerceException(charval);
    }

    private static boolean fromNumber(Number numval) throws PSQLException {
        double value = numval.doubleValue();
        if (value == 1.0) {
            return true;
        }
        if (value == 0.0) {
            return false;
        }
        throw JdbcBooleanColumnValues.cannotCoerceException(numval);
    }

    @Override
    public Object[] getArray() {
        return this.array;
    }
}

