/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Date;

public class JdbcShortColumnValues
extends JdbcColumnValues {
    Short[] array;

    public JdbcShortColumnValues(TimestampUtils timestampUtils, int rowCount) {
        super(timestampUtils, rowCount);
        this.array = new Short[rowCount];
    }

    @Override
    public void doSet(int row, Object obj) throws SQLException {
        this.array[row] = JdbcShortColumnValues.castToShort(obj);
    }

    private static short castToShort(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Short.parseShort((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).shortValue();
            }
            if (in instanceof Date) {
                return (short)((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? (short)1 : 0;
            }
            if (in instanceof Clob) {
                return Short.parseShort(JdbcShortColumnValues.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Short.parseShort(in.toString());
            }
        }
        catch (Exception e) {
            throw JdbcShortColumnValues.cannotCastException(in.getClass().getName(), "short", e);
        }
        throw JdbcShortColumnValues.cannotCastException(in.getClass().getName(), "short");
    }

    @Override
    public Object[] getArray() {
        return this.array;
    }
}

