/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.sql.Clob;
import java.sql.SQLException;

public class JdbcStringColumnValues
extends JdbcColumnValues {
    String[] array;

    public JdbcStringColumnValues(TimestampUtils timestampUtils, int rowCount) {
        super(timestampUtils, rowCount);
        this.array = new String[rowCount];
    }

    @Override
    public void doSet(int row, Object obj) throws SQLException {
        this.array[row] = this.removeU0000(JdbcStringColumnValues.castToString(obj));
    }

    private String removeU0000(String in) {
        if (in != null && in.contains("\u0000")) {
            return in.replaceAll("\u0000", "");
        }
        return in;
    }

    private static String castToString(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return (String)in;
            }
            if (in instanceof Clob) {
                return JdbcStringColumnValues.asString((Clob)in);
            }
            return in.toString();
        }
        catch (Exception e) {
            throw JdbcStringColumnValues.cannotCastException(in.getClass().getName(), "String", e);
        }
    }

    @Override
    public Object[] getArray() {
        return this.array;
    }
}

