/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import com.alibaba.hologres.org.postgresql.util.PGTimestamp;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.Date;

public class JdbcTimestampColumnValues
extends JdbcColumnValues {
    String[] array;
    HoloConfig config;

    public JdbcTimestampColumnValues(TimestampUtils timestampUtils, int rowCount, HoloConfig config) {
        super(timestampUtils, rowCount);
        this.array = new String[rowCount];
        this.config = config;
    }

    @Override
    public void doSet(int row, Object in) throws SQLException {
        if (in instanceof String && this.config.isInputStringAsEpochMsForDatetimeColumn()) {
            Long value = null;
            try {
                value = Long.parseLong(String.valueOf(in));
            }
            catch (Exception ignore) {
                value = null;
            }
            if (value != null) {
                this.setTimestamp(row, new Timestamp(value));
                return;
            }
        }
        if (in instanceof Number && this.config.isInputNumberAsEpochMsForDatetimeColumn()) {
            this.setTimestamp(row, new Timestamp(((Number)in).longValue()));
        } else if (in instanceof String && "0000-00-00 00:00:00".equals(in)) {
            this.setTimestamp(row, new Timestamp(0L));
        } else if (in instanceof Timestamp) {
            this.setTimestamp(row, (Timestamp)in);
        } else {
            Timestamp tmpts;
            if (in instanceof Date) {
                tmpts = new Timestamp(((Date)in).getTime());
            } else {
                if (in instanceof LocalDateTime) {
                    this.setTimestamp(row, (LocalDateTime)in);
                    return;
                }
                if (in instanceof OffsetDateTime) {
                    return;
                }
                tmpts = this.timestampUtils.toTimestamp(this.getDefaultCalendar(), in.toString());
            }
            this.setTimestamp(row, tmpts);
        }
    }

    private void setTimestamp(int row, OffsetDateTime offsetDateTime) throws SQLException {
        this.array[row] = this.timestampUtils.toString(offsetDateTime);
    }

    private void setTimestamp(int row, LocalDateTime localDateTime) throws SQLException {
        this.array[row] = this.timestampUtils.toString(localDateTime);
    }

    public void setTimestamp(int row, Timestamp x) throws SQLException {
        this.setTimestamp(row, x, null);
    }

    public void setTimestamp(int row, Timestamp t, Calendar cal) throws SQLException {
        PGTimestamp pgTimestamp;
        if (t == null) {
            return;
        }
        if (t instanceof PGTimestamp && (pgTimestamp = (PGTimestamp)t).getCalendar() != null) {
            cal = pgTimestamp.getCalendar();
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.array[row] = this.timestampUtils.toString(cal, t);
    }

    @Override
    public Object[] getArray() {
        return this.array;
    }
}

