/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.model;

import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.TableName;
import com.alibaba.hologres.client.utils.IdentifierUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class TableSchema
implements Serializable {
    String tableId;
    String schemaVersion;
    TableName tableName;
    Column[] columns;
    String[] distributionKeys;
    private String[] dictionaryEncoding;
    private String[] bitmapIndexKey;
    private Long lifecycle;
    private String[] clusteringKey;
    private String[] segmentKey;
    String partitionInfo;
    private String orientation = "column";
    private String comment;
    private Boolean isNotExist = true;
    private Boolean isSensitive = false;
    Map<String, Integer> columnNameToIndexMapping;
    Map<String, Integer> lowerColumnNameToIndexMapping;
    int partitionIndex = -2;
    String[] primaryKeys;
    int[] keyIndex;
    int[] distributionKeyIndex;
    Set<String> primaryKeySet;
    String[] columnNames = null;
    int[] columnTypes = null;
    String[] typeNames = null;

    private TableSchema(String tableId, String schemaVersion) {
        this.tableId = tableId;
        this.schemaVersion = schemaVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSchema that = (TableSchema)o;
        return this.tableId.equals(that.tableId) && this.schemaVersion.equals(that.schemaVersion);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.schemaVersion);
    }

    public void calculateProperties() {
        if (this.columnNameToIndexMapping == null) {
            Column column;
            int i;
            this.columnNameToIndexMapping = new HashMap<String, Integer>();
            ArrayList<String> primaryKeyNames = new ArrayList<String>();
            for (i = 0; i < this.columns.length; ++i) {
                column = this.columns[i];
                this.columnNameToIndexMapping.put(column.getName(), i);
                if (!column.getPrimaryKey().booleanValue()) continue;
                primaryKeyNames.add(column.getName());
            }
            this.lowerColumnNameToIndexMapping = new HashMap<String, Integer>();
            for (i = this.columns.length - 1; i > -1; --i) {
                column = this.columns[i];
                this.lowerColumnNameToIndexMapping.put(column.getName().toLowerCase(Locale.US), i);
            }
            if (this.partitionIndex > -2) {
                this.partitionInfo = this.partitionIndex == -1 ? null : this.columns[this.partitionIndex].getName();
            } else {
                this.partitionIndex = null != this.partitionInfo && this.partitionInfo.length() > 0 ? this.columnNameToIndexMapping.get(this.partitionInfo) : -1;
            }
            this.primaryKeys = primaryKeyNames.toArray(new String[0]);
            this.keyIndex = new int[this.primaryKeys.length];
            if (this.primaryKeys.length > 0) {
                this.primaryKeySet = new HashSet<String>();
            }
            for (i = 0; i < this.primaryKeys.length; ++i) {
                this.keyIndex[i] = this.columnNameToIndexMapping.get(this.primaryKeys[i]);
                if (this.primaryKeySet == null) continue;
                this.primaryKeySet.add(this.primaryKeys[i]);
            }
            if (this.distributionKeys == null) {
                this.distributionKeys = new String[0];
            }
            this.distributionKeyIndex = new int[this.distributionKeys.length];
            for (i = 0; i < this.distributionKeyIndex.length; ++i) {
                this.distributionKeyIndex[i] = this.columnNameToIndexMapping.get(this.distributionKeys[i]);
            }
            String[] typeNamesTemp = new String[this.columns.length];
            for (int i2 = 0; i2 < this.columns.length; ++i2) {
                typeNamesTemp[i2] = this.columns[i2].getTypeName();
            }
            this.typeNames = typeNamesTemp;
            int[] columnTypesTemp = new int[this.columns.length];
            for (int i3 = 0; i3 < this.columns.length; ++i3) {
                columnTypesTemp[i3] = this.columns[i3].getType();
            }
            this.columnTypes = columnTypesTemp;
            String[] columnNamesTemp = new String[this.columns.length];
            for (int i4 = 0; i4 < this.columns.length; ++i4) {
                columnNamesTemp[i4] = this.columns[i4].getName();
            }
            this.columnNames = columnNamesTemp;
        }
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public boolean isPartitionParentTable() {
        return this.partitionIndex > -1;
    }

    public TableName getTableNameObj() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.tableName.getSchemaName();
    }

    public String getTableName() {
        return this.tableName.getTableName();
    }

    public Column[] getColumnSchema() {
        return this.columns;
    }

    public Column getColumn(int index) {
        return this.columns[index];
    }

    public Integer getColumnIndex(String columnName) {
        return this.columnNameToIndexMapping.get(columnName);
    }

    public Integer getLowerColumnIndex(String lowerColumnName) {
        return this.lowerColumnNameToIndexMapping.get(lowerColumnName);
    }

    public String[] getPrimaryKeys() {
        return this.primaryKeys;
    }

    public int[] getKeyIndex() {
        return this.keyIndex;
    }

    public String[] getDistributionKeys() {
        return this.distributionKeys;
    }

    public int[] getDistributionKeyIndex() {
        return this.distributionKeyIndex;
    }

    public String[] getDictionaryEncoding() {
        return this.dictionaryEncoding;
    }

    public String[] getBitmapIndexKey() {
        return this.bitmapIndexKey;
    }

    public Long getLifecycle() {
        return this.lifecycle;
    }

    public String[] getClusteringKey() {
        return this.clusteringKey;
    }

    public String[] getSegmentKey() {
        return this.segmentKey;
    }

    public String getPartitionInfo() {
        return this.partitionInfo;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public Boolean getNotExist() {
        return this.isNotExist;
    }

    public Boolean getSensitive() {
        return this.isSensitive;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isPrimaryKey(String columnName) {
        if (this.primaryKeySet != null) {
            return this.primaryKeySet.contains(columnName);
        }
        return false;
    }

    public void convertTableIdentifier() {
        if (!"temp".equals(this.schemaVersion)) {
            return;
        }
        for (Column hologresColumn : this.getColumnSchema()) {
            hologresColumn.setName(IdentifierUtil.quoteIdentifier(hologresColumn.getName(), this.getSensitive()));
        }
        this.bitmapIndexKey = this.convertArrayIdentfier(this.getBitmapIndexKey());
        this.clusteringKey = this.convertArrayIdentfier(this.getClusteringKey());
        this.dictionaryEncoding = this.convertArrayIdentfier(this.getDictionaryEncoding());
        this.segmentKey = this.convertArrayIdentfier(this.getSegmentKey());
        this.distributionKeys = this.convertArrayIdentfier(this.getDistributionKeys());
    }

    private String[] convertArrayIdentfier(String[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = IdentifierUtil.quoteIdentifier(array[i], this.getSensitive());
            }
        }
        return array;
    }

    public String toString() {
        return "TableSchema{tableName=" + this.tableName + ", columnNames=" + Arrays.toString(this.columnNames) + '}';
    }

    static /* synthetic */ String[] access$202(TableSchema x0, String[] x1) {
        x0.dictionaryEncoding = x1;
        return x1;
    }

    static /* synthetic */ String[] access$302(TableSchema x0, String[] x1) {
        x0.bitmapIndexKey = x1;
        return x1;
    }

    static /* synthetic */ String[] access$502(TableSchema x0, String[] x1) {
        x0.clusteringKey = x1;
        return x1;
    }

    static /* synthetic */ String[] access$602(TableSchema x0, String[] x1) {
        x0.segmentKey = x1;
        return x1;
    }

    public static class Builder {
        TableSchema tableSchema;
        AtomicLong tableIdSerial = new AtomicLong(0L);
        List<Column> columns = new ArrayList<Column>();

        public Builder() {
            this.tableSchema = new TableSchema("temp_" + this.tableIdSerial.incrementAndGet(), "temp");
        }

        public Builder(String tableId, String schemaVersion) {
            this.tableSchema = new TableSchema(tableId, schemaVersion);
        }

        public Builder setColumns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public Builder addColumn(Column column) {
            this.columns.add(column);
            return this;
        }

        public Builder addColumns(List<Column> columns) {
            this.columns.addAll(columns);
            return this;
        }

        public Builder setTableName(TableName tableName) {
            this.tableSchema.tableName = tableName;
            return this;
        }

        public void setComment(String comment) {
            this.tableSchema.comment = comment;
        }

        public Builder setDistributionKeys(String[] distributionKeys) {
            this.tableSchema.distributionKeys = distributionKeys;
            return this;
        }

        public void setDictionaryEncoding(String[] dictionaryEncoding) {
            TableSchema.access$202(this.tableSchema, dictionaryEncoding);
        }

        public void setBitmapIndexKey(String[] bitmapIndexKey) {
            TableSchema.access$302(this.tableSchema, bitmapIndexKey);
        }

        public void setLifecycle(Long lifecycle) {
            this.tableSchema.lifecycle = lifecycle;
        }

        public void setClusteringKey(String[] clusteringKey) {
            TableSchema.access$502(this.tableSchema, clusteringKey);
        }

        public void setSegmentKey(String[] segmentKey) {
            TableSchema.access$602(this.tableSchema, segmentKey);
        }

        public void setOrientation(String orientation) {
            this.tableSchema.orientation = orientation;
        }

        public void setNotExist(Boolean notExist) {
            this.tableSchema.isNotExist = notExist;
        }

        public void setSensitive(Boolean sensitive) {
            this.tableSchema.isSensitive = sensitive;
        }

        public Builder setPartitionColumnName(String partitionColumnName) {
            this.tableSchema.partitionInfo = partitionColumnName;
            this.tableSchema.partitionIndex = -2;
            return this;
        }

        public Builder setPartitionColumnIndex(int partitionColumnIndex) {
            this.tableSchema.partitionInfo = null;
            this.tableSchema.partitionIndex = partitionColumnIndex;
            return this;
        }

        public TableSchema build() {
            this.tableSchema.columns = this.columns.toArray(new Column[0]);
            return this.tableSchema;
        }
    }
}

