/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.common.utils.Objects;
import com.alibaba.nacos.common.utils.Observer;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.Set;

public class Observable {
    private transient boolean changed = false;
    private transient Set<Observer> obs = new ConcurrentHashSet<Observer>();
    private volatile int observerCnt = 0;
    private boolean alreadyAddObserver = false;

    public synchronized void addObserver(Observer o) {
        Objects.requireNonNull(o, "Observer");
        this.obs.add(o);
        ++this.observerCnt;
        if (!this.alreadyAddObserver) {
            this.notifyAll();
        }
        this.alreadyAddObserver = true;
    }

    public synchronized void deleteObserver(Observer o) {
        this.obs.remove(o);
        --this.observerCnt;
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object arg) {
        Observable observable = this;
        synchronized (observable) {
            if (!this.changed) {
                return;
            }
            this.clearChanged();
            if (!this.alreadyAddObserver) {
                ThreadUtils.objectWait(this);
            }
        }
        for (Observer observer : this.obs) {
            observer.update(this, arg);
        }
    }

    public void deleteObservers() {
        this.obs.clear();
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public int countObservers() {
        return this.observerCnt;
    }
}

