/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.service.LongPollingService;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/v1/cs/communication"})
public class CommunicationController {
    private final DumpService dumpService;
    private final LongPollingService longPollingService;
    private String trueStr = "true";

    @Autowired
    public CommunicationController(DumpService dumpService, LongPollingService longPollingService) {
        this.dumpService = dumpService;
        this.longPollingService = longPollingService;
    }

    @RequestMapping(value={"/dataChange"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean notifyConfigInfo(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="tag", required=false) String tag) {
        dataId = dataId.trim();
        group = group.trim();
        String lastModified = request.getHeader("lastModified");
        long lastModifiedTs = StringUtils.isEmpty((CharSequence)lastModified) ? -1L : Long.parseLong(lastModified);
        String handleIp = request.getHeader("opHandleIp");
        String isBetaStr = request.getHeader("isBeta");
        if (StringUtils.isNotBlank((CharSequence)isBetaStr) && this.trueStr.equals(isBetaStr)) {
            this.dumpService.dump(dataId, group, tenant, lastModifiedTs, handleIp, true);
        } else {
            this.dumpService.dump(dataId, group, tenant, tag, lastModifiedTs, handleIp);
        }
        return true;
    }

    @RequestMapping(value={"/configWatchers"}, method={RequestMethod.GET})
    @ResponseBody
    public SampleResult getSubClientConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false) String tenant, ModelMap modelMap) {
        group = StringUtils.isBlank((CharSequence)group) ? "DEFAULT_GROUP" : group;
        return this.longPollingService.getCollectSubscribleInfo(dataId, group, tenant);
    }

    @RequestMapping(value={"/watcherConfigs"}, method={RequestMethod.GET})
    @ResponseBody
    public SampleResult getSubClientConfigByIp(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ip") String ip, ModelMap modelMap) {
        return this.longPollingService.getCollectSubscribleInfoByIp(ip);
    }
}

