/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.merge;

import com.alibaba.nacos.common.util.SystemUtils;
import com.alibaba.nacos.config.server.manager.TaskManager;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoAggr;
import com.alibaba.nacos.config.server.model.ConfigInfoChanged;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.config.server.service.merge.MergeDataTask;
import com.alibaba.nacos.config.server.service.merge.MergeTaskProcessor;
import com.alibaba.nacos.config.server.utils.ContentUtils;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MergeDatumService {
    private PersistService persistService;
    static final int INIT_THREAD_COUNT = 40;
    static final AtomicInteger FINISHED = new AtomicInteger();
    static int total = 0;
    private static final Logger log = LoggerFactory.getLogger(MergeDatumService.class);
    final TaskManager mergeTasks;

    @Autowired
    public MergeDatumService(PersistService persistService) {
        this.persistService = persistService;
        this.mergeTasks = new TaskManager("com.alibaba.nacos.MergeDatum");
        this.mergeTasks.setDefaultTaskProcessor(new MergeTaskProcessor(persistService, this));
    }

    static List<List<ConfigInfoChanged>> splitList(List<ConfigInfoChanged> list, int count) {
        int i;
        ArrayList<List<ConfigInfoChanged>> result = new ArrayList<List<ConfigInfoChanged>>(count);
        for (i = 0; i < count; ++i) {
            result.add(new ArrayList());
        }
        for (i = 0; i < list.size(); ++i) {
            ConfigInfoChanged config = list.get(i);
            ((List)result.get(i % count)).add(config);
        }
        return result;
    }

    public void addMergeTask(String dataId, String groupId, String tenant, String tag, String clientIp) {
        MergeDataTask task = new MergeDataTask(dataId, groupId, tenant, tag, clientIp);
        this.mergeTasks.addTask(task.getId(), task);
    }

    public void addMergeTask(String dataId, String groupId, String tenant, String clientIp) {
        MergeDataTask task = new MergeDataTask(dataId, groupId, tenant, clientIp);
        this.mergeTasks.addTask(task.getId(), task);
    }

    public void mergeAll() {
        for (ConfigInfoChanged item : this.persistService.findAllAggrGroup()) {
            this.addMergeTask(item.getDataId(), item.getGroup(), item.getTenant(), SystemUtils.LOCAL_IP);
        }
    }

    class MergeAllDataWorker
    extends Thread {
        static final int PAGE_SIZE = 10000;
        private List<ConfigInfoChanged> configInfoList;

        public MergeAllDataWorker(List<ConfigInfoChanged> configInfoList) {
            super("MergeAllDataWorker");
            this.configInfoList = configInfoList;
        }

        @Override
        public void run() {
            for (ConfigInfoChanged configInfo : this.configInfoList) {
                String dataId = configInfo.getDataId();
                String group = configInfo.getGroup();
                String tenant = configInfo.getTenant();
                try {
                    ArrayList<ConfigInfoAggr> datumList = new ArrayList<ConfigInfoAggr>();
                    int rowCount = MergeDatumService.this.persistService.aggrConfigInfoCount(dataId, group, tenant);
                    int pageCount = (int)Math.ceil((double)rowCount * 1.0 / 10000.0);
                    for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
                        Page<ConfigInfoAggr> page = MergeDatumService.this.persistService.findConfigInfoAggrByPage(dataId, group, tenant, pageNo, 10000);
                        if (page == null) continue;
                        datumList.addAll(page.getPageItems());
                        log.info("[merge-query] {}, {}, size/total={}/{}", new Object[]{dataId, group, datumList.size(), rowCount});
                    }
                    Timestamp time = TimeUtils.getCurrentTime();
                    if (datumList.size() > 0) {
                        ConfigInfo cf = MergeTaskProcessor.merge(dataId, group, tenant, datumList);
                        MergeDatumService.this.persistService.insertOrUpdate(null, null, cf, time, null, false);
                        log.info("[merge-ok] {}, {}, size={}, length={}, md5={}, content={}", new Object[]{dataId, group, datumList.size(), cf.getContent().length(), cf.getMd5(), ContentUtils.truncateContent(cf.getContent())});
                    } else {
                        MergeDatumService.this.persistService.removeConfigInfo(dataId, group, tenant, SystemUtils.LOCAL_IP, null);
                        log.warn("[merge-delete] delete config info because no datum. dataId=" + dataId + ", groupId=" + group);
                    }
                }
                catch (Exception e) {
                    log.info("[merge-error] " + dataId + ", " + group + ", " + e.toString(), (Throwable)e);
                }
                FINISHED.incrementAndGet();
                if (FINISHED.get() % 100 != 0) continue;
                log.info("[all-merge-dump] {} / {}", (Object)FINISHED.get(), (Object)total);
            }
            log.info("[all-merge-dump] {} / {}", (Object)FINISHED.get(), (Object)total);
        }
    }
}

