/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import java.util.HashMap;
import java.util.Map;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class ConfigTree {
    private ConfigurableEnvironment environment;
    private String prefix;

    public ConfigTree(ConfigurableEnvironment environment, String prefix) {
        Assert.notNull((Object)environment, (String)"environment is required");
        Assert.notNull((Object)prefix, (String)"prefix is required");
        this.environment = environment;
        this.prefix = prefix;
    }

    public ConfigTree subTree(String prefix) {
        return new ConfigTree(this.environment, this.fullPrefixOrKey(prefix));
    }

    private String fullPrefixOrKey(String prefixOrKey) {
        return this.prefix + prefixOrKey;
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (PropertySource source : this.environment.getPropertySources()) {
            if (!(source instanceof EnumerablePropertySource)) continue;
            for (String name : ((EnumerablePropertySource)source).getPropertyNames()) {
                if (name == null || !name.startsWith(this.prefix)) continue;
                String subKey = name.substring(this.prefix.length());
                m.put(subKey, source.getProperty(name));
            }
        }
        return m;
    }

    public boolean containsProperty(String key) {
        key = this.fullPrefixOrKey(key);
        return this.environment.containsProperty(key);
    }

    public <T> T getProperty(String key) {
        key = this.fullPrefixOrKey(key);
        return (T)this.environment.getProperty(key);
    }

    public <T> T getProperty(String key, T defaultValue) {
        if (this.containsProperty(key)) {
            return this.getProperty(key);
        }
        return defaultValue;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

