/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.autoconfigure.ConfigTree;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;

public abstract class JetCacheConditon
extends SpringBootCondition {
    private String[] cacheTypes;

    protected JetCacheConditon(String ... cacheTypes) {
        Objects.requireNonNull(cacheTypes, "cacheTypes can't be null");
        Assert.isTrue((cacheTypes.length > 0 ? 1 : 0) != 0, (String)"cacheTypes length is 0");
        this.cacheTypes = cacheTypes;
    }

    public ConditionOutcome getMatchOutcome(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        ConfigTree ct = new ConfigTree((ConfigurableEnvironment)conditionContext.getEnvironment(), "jetcache.");
        if (this.match(ct, "local.") || this.match(ct, "remote.")) {
            return ConditionOutcome.match();
        }
        return ConditionOutcome.noMatch((String)("no match for " + this.cacheTypes[0]));
    }

    private boolean match(ConfigTree ct, String prefix) {
        Map<String, Object> m = ct.subTree(prefix).getProperties();
        Set cacheAreaNames = m.keySet().stream().map(s -> s.substring(0, s.indexOf(46))).collect(Collectors.toSet());
        List<String> cacheTypesList = Arrays.asList(this.cacheTypes);
        return cacheAreaNames.stream().anyMatch(s -> cacheTypesList.contains(m.get(s + ".type")));
    }
}

