/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.autoconfigure.ConfigTree;
import com.alicp.jetcache.autoconfigure.ExternalCacheAutoInit;
import com.alicp.jetcache.autoconfigure.JetCacheConditon;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.redis.lettuce4.LettuceConnectionManager;
import com.alicp.jetcache.redis.lettuce4.RedisLettuceCacheBuilder;
import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={RedisLettuceCondition.class})
public class RedisLettuce4AutoConfiguration {
    public static final String AUTO_INIT_BEAN_NAME = "redisLettuce4AutoInit";

    @Bean(name={"redisLettuce4AutoInit"})
    public RedisLettuceAutoInit redisLettuceAutoInit() {
        return new RedisLettuceAutoInit();
    }

    public static class RedisLettuceAutoInit
    extends ExternalCacheAutoInit {
        public RedisLettuceAutoInit() {
            super("redis.lettuce4");
        }

        @Override
        protected CacheBuilder initCache(ConfigTree ct, String cacheAreaWithPrefix) {
            Map<String, Object> map = ct.subTree("uri").getProperties();
            RedisClient client = null;
            if (map == null || map.size() == 0) {
                throw new CacheConfigException("uri is required");
            }
            if (map.size() == 1) {
                String uri = (String)map.values().iterator().next();
                client = RedisClient.create((String)uri);
            } else {
                List list = map.values().stream().map(k -> RedisURI.create((URI)URI.create(k.toString()))).collect(Collectors.toList());
                client = RedisClusterClient.create(list);
            }
            ExternalCacheBuilder externalCacheBuilder = RedisLettuceCacheBuilder.createRedisLettuceCacheBuilder().redisClient((AbstractRedisClient)client);
            this.parseGeneralConfig((CacheBuilder)externalCacheBuilder, ct);
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".client", client);
            LettuceConnectionManager m = LettuceConnectionManager.defaultManager();
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".connection", m.connection((AbstractRedisClient)client));
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".commands", m.commands((AbstractRedisClient)client));
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".asyncCommands", m.asyncCommands((AbstractRedisClient)client));
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".reactiveCommands", m.reactiveCommands((AbstractRedisClient)client));
            return externalCacheBuilder;
        }
    }

    public static class RedisLettuceCondition
    extends JetCacheConditon {
        public RedisLettuceCondition() {
            super("redis.lettuce4");
        }
    }
}

