/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.external;

import com.alicp.jetcache.AbstractCacheBuilder;
import com.alicp.jetcache.external.ExternalCacheConfig;
import com.alicp.jetcache.support.BroadcastManager;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class ExternalCacheBuilder<T extends ExternalCacheBuilder<T>>
extends AbstractCacheBuilder<T> {
    private String broadcastChannel = "JetCacheChannel";

    @Override
    public ExternalCacheConfig getConfig() {
        if (this.config == null) {
            this.config = new ExternalCacheConfig();
        }
        return (ExternalCacheConfig)this.config;
    }

    public boolean supportBroadcast() {
        return false;
    }

    public BroadcastManager broadcastManager(String channel) {
        return null;
    }

    public String getBroadcastChannel() {
        return this.broadcastChannel;
    }

    public void setBroadcastChannel(String broadcastChannel) {
        this.broadcastChannel = broadcastChannel;
    }

    public T keyPrefix(String keyPrefix) {
        this.getConfig().setKeyPrefixSupplier(() -> keyPrefix);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public T keyPrefixSupplier(Supplier<String> keyPrefixSupplier) {
        this.getConfig().setKeyPrefixSupplier(keyPrefixSupplier);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public T valueEncoder(Function<Object, byte[]> valueEncoder) {
        this.getConfig().setValueEncoder(valueEncoder);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public T valueDecoder(Function<byte[], Object> valueDecoder) {
        this.getConfig().setValueDecoder(valueDecoder);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setKeyPrefix(String keyPrefix) {
        if (keyPrefix != null) {
            this.getConfig().setKeyPrefixSupplier(() -> keyPrefix);
        } else {
            this.getConfig().setKeyPrefixSupplier(null);
        }
    }

    public void setKeyPrefixSupplier(Supplier<String> keyPrefixSupplier) {
        this.getConfig().setKeyPrefixSupplier(keyPrefixSupplier);
    }

    public void setValueEncoder(Function<Object, byte[]> valueEncoder) {
        this.getConfig().setValueEncoder(valueEncoder);
    }

    public void setValueDecoder(Function<byte[], Object> valueDecoder) {
        this.getConfig().setValueDecoder(valueDecoder);
    }
}

