/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.external;

import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.external.MockRemoteCache;
import com.alicp.jetcache.external.MockRemoteCacheConfig;
import com.alicp.jetcache.support.BroadcastManager;
import com.alicp.jetcache.support.CacheMessage;
import java.util.function.Consumer;

public class MockRemoteCacheBuilder<T extends ExternalCacheBuilder<T>>
extends ExternalCacheBuilder<T> {
    public static MockRemoteCacheBuilderImpl createMockRemoteCacheBuilder() {
        return new MockRemoteCacheBuilderImpl();
    }

    @Override
    public MockRemoteCacheConfig getConfig() {
        if (this.config == null) {
            this.config = new MockRemoteCacheConfig();
        }
        return (MockRemoteCacheConfig)this.config;
    }

    @Override
    public boolean supportBroadcast() {
        return true;
    }

    @Override
    public BroadcastManager broadcastManager(String channel) {
        return new BroadcastManager(){

            @Override
            public CacheResult publish(CacheMessage cacheMessage) {
                return CacheResult.SUCCESS_WITHOUT_MSG;
            }

            @Override
            public void startSubscribe(Consumer<CacheMessage> consumer) {
            }
        };
    }

    public MockRemoteCacheBuilder() {
        this.setKeyPrefix("DEFAULT_PREFIX");
        this.buildFunc(c -> new MockRemoteCache((MockRemoteCacheConfig)c));
    }

    public T limit(int limit) {
        this.getConfig().setLimit(limit);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setLimit(int limit) {
        this.getConfig().setLimit(limit);
    }

    public static class MockRemoteCacheBuilderImpl
    extends MockRemoteCacheBuilder<MockRemoteCacheBuilderImpl> {
    }
}

