/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.embedded.AbstractEmbeddedCache;
import com.alicp.jetcache.support.CacheMessage;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CacheMessageConsumer
implements Consumer<CacheMessage> {
    private final String sourceId;
    private final CacheManager cacheManager;

    public CacheMessageConsumer(String sourceId, CacheManager cacheManager) {
        this.sourceId = sourceId;
        this.cacheManager = cacheManager;
    }

    @Override
    public void accept(CacheMessage cacheMessage) {
        Cache c;
        AbstractCache localCache;
        if (cacheMessage == null) {
            return;
        }
        if (this.sourceId.equals(cacheMessage.getSourceId())) {
            return;
        }
        Cache cache = this.cacheManager.getCache(cacheMessage.getArea(), cacheMessage.getCacheName());
        AbstractCache absCache = CacheUtil.getAbstractCache(cache);
        if (!(absCache instanceof MultiLevelCache)) {
            return;
        }
        Cache[] caches = ((MultiLevelCache)absCache).caches();
        Set keys = Stream.of(cacheMessage.getKeys()).collect(Collectors.toSet());
        Cache[] cacheArray = caches;
        int n = cacheArray.length;
        for (int i = 0; i < n && (localCache = CacheUtil.getAbstractCache(c = cacheArray[i])) instanceof AbstractEmbeddedCache; ++i) {
            localCache.REMOVE_ALL(keys);
        }
    }
}

