/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheMonitor;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.event.CachePutAllEvent;
import com.alicp.jetcache.event.CachePutEvent;
import com.alicp.jetcache.event.CacheRemoveAllEvent;
import com.alicp.jetcache.event.CacheRemoveEvent;
import com.alicp.jetcache.support.BroadcastManager;
import com.alicp.jetcache.support.CacheMessage;

public class CacheNotifyMonitor
implements CacheMonitor {
    private final BroadcastManager broadcastManager;
    private final String area;
    private final String cacheName;
    private final Cache cache;
    private final String sourceId;

    public CacheNotifyMonitor(BroadcastManager broadcastManager, String area, String cacheName, Cache cache, String sourceId) {
        this.broadcastManager = broadcastManager;
        this.area = area;
        this.cacheName = cacheName;
        this.cache = cache;
        this.sourceId = sourceId;
    }

    @Override
    public void afterOperation(CacheEvent event) {
        AbstractCache absCache = CacheUtil.getAbstractCache(this.cache);
        if (absCache.isClosed()) {
            return;
        }
        if (event instanceof CachePutEvent) {
            CacheMessage m = new CacheMessage();
            m.setArea(this.area);
            m.setCacheName(this.cacheName);
            m.setSourceId(this.sourceId);
            CachePutEvent e = (CachePutEvent)event;
            m.setType(1);
            m.setKeys(new Object[]{e.getKey()});
            this.broadcastManager.publish(m);
        } else if (event instanceof CacheRemoveEvent) {
            CacheMessage m = new CacheMessage();
            m.setArea(this.area);
            m.setCacheName(this.cacheName);
            m.setSourceId(this.sourceId);
            CacheRemoveEvent e = (CacheRemoveEvent)event;
            m.setType(3);
            m.setKeys(new Object[]{e.getKey()});
            this.broadcastManager.publish(m);
        } else if (event instanceof CachePutAllEvent) {
            CacheMessage m = new CacheMessage();
            m.setArea(this.area);
            m.setCacheName(this.cacheName);
            m.setSourceId(this.sourceId);
            CachePutAllEvent e = (CachePutAllEvent)event;
            m.setType(2);
            if (e.getMap() != null) {
                m.setKeys(e.getMap().keySet().toArray());
            }
            this.broadcastManager.publish(m);
        } else if (event instanceof CacheRemoveAllEvent) {
            CacheMessage m = new CacheMessage();
            m.setArea(this.area);
            m.setCacheName(this.cacheName);
            m.setSourceId(this.sourceId);
            CacheRemoveAllEvent e = (CacheRemoveAllEvent)event;
            m.setType(4);
            if (e.getKeys() != null) {
                m.setKeys(e.getKeys().toArray());
            }
            this.broadcastManager.publish(m);
        }
    }
}

