/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.core;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.FSMCaller;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.NodeManager;
import com.alipay.sofa.jraft.ReadOnlyService;
import com.alipay.sofa.jraft.ReplicatorGroup;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.closure.CatchUpClosure;
import com.alipay.sofa.jraft.closure.ClosureQueue;
import com.alipay.sofa.jraft.closure.ClosureQueueImpl;
import com.alipay.sofa.jraft.closure.ReadIndexClosure;
import com.alipay.sofa.jraft.closure.SynchronizedClosure;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.conf.ConfigurationEntry;
import com.alipay.sofa.jraft.conf.ConfigurationManager;
import com.alipay.sofa.jraft.core.BallotBox;
import com.alipay.sofa.jraft.core.FSMCallerImpl;
import com.alipay.sofa.jraft.core.NodeMetrics;
import com.alipay.sofa.jraft.core.ReadOnlyServiceImpl;
import com.alipay.sofa.jraft.core.Replicator;
import com.alipay.sofa.jraft.core.ReplicatorGroupImpl;
import com.alipay.sofa.jraft.core.State;
import com.alipay.sofa.jraft.core.TimerManager;
import com.alipay.sofa.jraft.entity.Ballot;
import com.alipay.sofa.jraft.entity.EnumOutter;
import com.alipay.sofa.jraft.entity.LeaderChangeContext;
import com.alipay.sofa.jraft.entity.LogEntry;
import com.alipay.sofa.jraft.entity.LogId;
import com.alipay.sofa.jraft.entity.NodeId;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.entity.RaftOutter;
import com.alipay.sofa.jraft.entity.Task;
import com.alipay.sofa.jraft.entity.UserLog;
import com.alipay.sofa.jraft.error.LogIndexOutOfBoundsException;
import com.alipay.sofa.jraft.error.LogNotFoundException;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.error.RaftException;
import com.alipay.sofa.jraft.option.BallotBoxOptions;
import com.alipay.sofa.jraft.option.BootstrapOptions;
import com.alipay.sofa.jraft.option.FSMCallerOptions;
import com.alipay.sofa.jraft.option.LogManagerOptions;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.option.ReadOnlyOption;
import com.alipay.sofa.jraft.option.ReadOnlyServiceOptions;
import com.alipay.sofa.jraft.option.ReplicatorGroupOptions;
import com.alipay.sofa.jraft.option.SnapshotExecutorOptions;
import com.alipay.sofa.jraft.rpc.RaftClientService;
import com.alipay.sofa.jraft.rpc.RaftServerService;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.rpc.RpcResponseClosure;
import com.alipay.sofa.jraft.rpc.RpcResponseClosureAdapter;
import com.alipay.sofa.jraft.rpc.RpcResponseFactory;
import com.alipay.sofa.jraft.rpc.impl.core.BoltRaftClientService;
import com.alipay.sofa.jraft.storage.LogManager;
import com.alipay.sofa.jraft.storage.LogStorage;
import com.alipay.sofa.jraft.storage.RaftMetaStorage;
import com.alipay.sofa.jraft.storage.SnapshotExecutor;
import com.alipay.sofa.jraft.storage.StorageFactory;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotExecutorImpl;
import com.alipay.sofa.jraft.util.LogExceptionHandler;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.RepeatedTimer;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.ThreadId;
import com.alipay.sofa.jraft.util.Utils;
import com.google.protobuf.Message;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeImpl
implements Node,
RaftServerService {
    private static final Logger LOG = LoggerFactory.getLogger(NodeImpl.class);
    public static final AtomicLong GLOBAL_NUM_NODES = new AtomicLong(0L);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    private volatile State state;
    private volatile CountDownLatch shutdownLatch;
    private long currTerm;
    private volatile long lastLeaderTimestamp;
    private PeerId leaderId = new PeerId();
    private PeerId votedId;
    private final Ballot voteCtx = new Ballot();
    private final Ballot prevVoteCtx = new Ballot();
    private ConfigurationEntry conf;
    private StopTransferArg stopTransferArg;
    private final String groupId;
    private NodeOptions options;
    private RaftOptions raftOptions;
    private final PeerId serverId;
    private final ConfigurationCtx confCtx;
    private LogStorage logStorage;
    private RaftMetaStorage metaStorage;
    private ClosureQueue closureQueue;
    private ConfigurationManager configManager;
    private LogManager logManager;
    private FSMCaller fsmCaller;
    private BallotBox ballotBox;
    private SnapshotExecutor snapshotExecutor;
    private ReplicatorGroup replicatorGroup;
    private final List<Closure> shutdownContinuations = new ArrayList<Closure>();
    private RaftClientService rpcService;
    private ReadOnlyService readOnlyService;
    private TimerManager timerManager;
    private RepeatedTimer electionTimer;
    private RepeatedTimer voteTimer;
    private RepeatedTimer stepDownTimer;
    private RepeatedTimer snapshotTimer;
    private ScheduledFuture<?> transferTimer;
    private ThreadId wakingCandidate;
    private Disruptor<LogEntryAndClosure> applyDisruptor;
    private RingBuffer<LogEntryAndClosure> applyQueue;
    private NodeMetrics metrics;
    private NodeId nodeId;

    public NodeImpl() {
        this(null, null);
    }

    public NodeImpl(String groupId, PeerId serverId) {
        if (groupId != null) {
            Utils.verifyGroupId(groupId);
        }
        this.groupId = groupId;
        this.serverId = serverId != null ? serverId.copy() : null;
        this.state = State.STATE_UNINITIALIZED;
        this.currTerm = 0L;
        this.updateLastLeaderTimestamp(Utils.monotonicMs());
        this.confCtx = new ConfigurationCtx(this);
        this.wakingCandidate = null;
        GLOBAL_NUM_NODES.incrementAndGet();
    }

    private boolean initSnapshotStorage() {
        if (StringUtils.isEmpty((String)this.options.getSnapshotUri())) {
            LOG.warn("Do not set snapshot uri, ignore initSnapshotStorage.");
            return true;
        }
        this.snapshotExecutor = new SnapshotExecutorImpl();
        SnapshotExecutorOptions opt = new SnapshotExecutorOptions();
        opt.setUri(this.options.getSnapshotUri());
        opt.setFsmCaller(this.fsmCaller);
        opt.setNode(this);
        opt.setLogManager(this.logManager);
        opt.setAddr(this.serverId != null ? this.serverId.getEndpoint() : null);
        opt.setInitTerm(this.currTerm);
        opt.setFilterBeforeCopyRemote(this.options.isFilterBeforeCopyRemote());
        opt.setSnapshotThrottle(this.options.getSnapshotThrottle());
        return this.snapshotExecutor.init(opt);
    }

    private boolean initLogStorage() {
        Requires.requireNonNull(this.fsmCaller, "null fsm caller.");
        this.logStorage = StorageFactory.createLogStorage(this.options.getLogUri(), this.raftOptions);
        this.logManager = StorageFactory.createLogManager();
        LogManagerOptions logManagerOptions = new LogManagerOptions();
        logManagerOptions.setLogStorage(this.logStorage);
        logManagerOptions.setConfigurationManager(this.configManager);
        logManagerOptions.setFsmCaller(this.fsmCaller);
        logManagerOptions.setNodeMetrics(this.metrics);
        logManagerOptions.setDisruptorBufferSize(this.raftOptions.getDisruptorBufferSize());
        logManagerOptions.setRaftOptions(this.raftOptions);
        return this.logManager.init(logManagerOptions);
    }

    private boolean initMetaStorage() {
        this.metaStorage = StorageFactory.createRaftMetaStorage(this.options.getRaftMetaUri(), this.raftOptions, this.metrics);
        if (!this.metaStorage.init(null)) {
            LOG.error("Node {} init meta storage failed, uri `{}`", (Object)this.serverId, (Object)this.options.getRaftMetaUri());
            return false;
        }
        this.currTerm = this.metaStorage.getTerm();
        this.votedId = this.metaStorage.getVotedFor().copy();
        return true;
    }

    private void handleSnapshotTimeout() {
        this.writeLock.lock();
        try {
            if (!this.state.isActive()) {
                return;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        Utils.runInThread(() -> this.doSnapshot(null));
    }

    private void handleElectionTimeout() {
        boolean doUnlock = true;
        this.writeLock.lock();
        try {
            if (this.state != State.STATE_FOLLOWER) {
                return;
            }
            if (this.isCurrentLeaderValid()) {
                return;
            }
            PeerId emptyId = new PeerId();
            this.resetLeaderId(emptyId, new Status(RaftError.ERAFTTIMEDOUT, "Lost connection from leader %s", this.leaderId));
            doUnlock = false;
            this.preVote();
        }
        finally {
            if (doUnlock) {
                this.writeLock.unlock();
            }
        }
    }

    private boolean initFSMCaller(LogId bootstrapId) {
        if (this.fsmCaller == null) {
            LOG.error("Fail to init fsm caller, null instance.");
            return false;
        }
        this.closureQueue = new ClosureQueueImpl();
        FSMCallerOptions fsmCallerOptions = new FSMCallerOptions();
        fsmCallerOptions.setAfterShutdown(status -> this.afterShutdown());
        fsmCallerOptions.setLogManager(this.logManager);
        fsmCallerOptions.setFsm(this.options.getFsm());
        fsmCallerOptions.setClosureQueue(this.closureQueue);
        fsmCallerOptions.setNode(this);
        fsmCallerOptions.setBootstrapId(bootstrapId);
        fsmCallerOptions.setDisruptorBufferSize(this.raftOptions.getDisruptorBufferSize());
        return this.fsmCaller.init(fsmCallerOptions);
    }

    public boolean bootstrap(BootstrapOptions opts) throws InterruptedException {
        if (opts.getLastLogIndex() > 0L && (opts.getGroupConf().isEmpty() || opts.getFsm() == null)) {
            LOG.error("Invalid arguments for bootstrap, groupConf={},fsm={}, while lastLogIndex={}", new Object[]{opts.getGroupConf(), opts.getFsm(), opts.getLastLogIndex()});
            return false;
        }
        if (opts.getGroupConf().isEmpty()) {
            LOG.error("Bootstrapping an empty node makes no sense.");
            return false;
        }
        long bootstrapLogTerm = opts.getLastLogIndex() > 0L ? 1L : 0L;
        LogId bootstrapId = new LogId(opts.getLastLogIndex(), bootstrapLogTerm);
        this.options = new NodeOptions();
        this.raftOptions = this.options.getRaftOptions();
        this.metrics = new NodeMetrics(opts.isEnableMetrics());
        this.options.setFsm(opts.getFsm());
        this.options.setLogUri(opts.getLogUri());
        this.options.setRaftMetaUri(opts.getRaftMetaUri());
        this.options.setSnapshotUri(opts.getSnapshotUri());
        this.configManager = new ConfigurationManager();
        this.fsmCaller = new FSMCallerImpl();
        if (!this.initLogStorage()) {
            LOG.error("Fail to init log storage.");
            return false;
        }
        if (!this.initMetaStorage()) {
            LOG.error("Fail to init meta storage.");
            return false;
        }
        if (this.currTerm == 0L) {
            this.currTerm = 1L;
            if (!this.metaStorage.setTermAndVotedFor(1L, new PeerId())) {
                LOG.error("Fail to set term.");
                return false;
            }
        }
        if (opts.getFsm() != null && !this.initFSMCaller(bootstrapId)) {
            LOG.error("Fail to init fsm caller.");
            return false;
        }
        LogEntry entry = new LogEntry(EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION);
        entry.getId().setTerm(this.currTerm);
        entry.setPeers(opts.getGroupConf().listPeers());
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        entries.add(entry);
        BootstrapStableClosure done = new BootstrapStableClosure();
        this.logManager.appendEntries(entries, done);
        if (!done.await().isOk()) {
            LOG.error("Fail to append configuration.");
            return false;
        }
        if (opts.getLastLogIndex() > 0L) {
            if (!this.initSnapshotStorage()) {
                LOG.error("Fail to init snapshot storage.");
                return false;
            }
            SynchronizedClosure syncDone = new SynchronizedClosure();
            this.snapshotExecutor.doSnapshot(syncDone);
            if (!syncDone.await().isOk()) {
                LOG.error("Fail to save snapshot: {}.", (Object)syncDone.getStatus());
                return false;
            }
        }
        if (opts.getLastLogIndex() > 0L) {
            if (this.logManager.getFirstLogIndex() != opts.getLastLogIndex() + 1L) {
                throw new IllegalStateException("first and last log index mismatch");
            }
            if (this.logManager.getLastLogIndex() != opts.getLastLogIndex()) {
                throw new IllegalStateException("last log index mismatch.");
            }
        } else {
            if (this.logManager.getFirstLogIndex() != opts.getLastLogIndex() + 1L) {
                throw new IllegalStateException("first and last log index mismatch");
            }
            if (this.logManager.getLastLogIndex() != opts.getLastLogIndex() + 1L) {
                throw new IllegalStateException("last log index mismatch.");
            }
        }
        return true;
    }

    private int heartbeatTimeout(int electionTimeout) {
        return Math.max(electionTimeout / this.raftOptions.getElectionHeartbeatFactor(), 10);
    }

    private int randomTimeout(int timeoutMs) {
        return ThreadLocalRandom.current().nextInt(timeoutMs, timeoutMs + this.raftOptions.getMaxElectionDelayMs());
    }

    @Override
    public boolean init(NodeOptions opts) {
        Requires.requireNonNull(opts, "Null node options");
        Requires.requireNonNull(opts.getRaftOptions(), "Null raft options");
        this.options = opts;
        this.raftOptions = opts.getRaftOptions();
        this.metrics = new NodeMetrics(opts.isEnableMetrics());
        if (this.serverId.getIp().equals("0.0.0.0")) {
            LOG.error("Node can't started from IP_ANY");
            return false;
        }
        if (!NodeManager.getInstance().serverExists(this.serverId.getEndpoint())) {
            LOG.error("No RPC server attached to, did you forget to call addService?");
            return false;
        }
        this.timerManager = new TimerManager();
        if (!this.timerManager.init(this.options.getTimerPoolSize())) {
            LOG.error("Fail to init timer manager");
            return false;
        }
        this.voteTimer = new RepeatedTimer("JRaft-VoteTimer", this.options.getElectionTimeoutMs()){

            @Override
            protected void onTrigger() {
                NodeImpl.this.handleVoteTimeout();
            }

            @Override
            protected int adjustTimeout(int timeoutMs) {
                return NodeImpl.this.randomTimeout(timeoutMs);
            }
        };
        this.electionTimer = new RepeatedTimer("JRaft-ElectionTimer", this.options.getElectionTimeoutMs()){

            @Override
            protected void onTrigger() {
                NodeImpl.this.handleElectionTimeout();
            }

            @Override
            protected int adjustTimeout(int timeoutMs) {
                return NodeImpl.this.randomTimeout(timeoutMs);
            }
        };
        this.stepDownTimer = new RepeatedTimer("JRaft-StepDownTimer", this.options.getElectionTimeoutMs() >> 1){

            @Override
            protected void onTrigger() {
                NodeImpl.this.handleStepDownTimeout();
            }
        };
        this.snapshotTimer = new RepeatedTimer("JRaft-SnapshotTimer", this.options.getSnapshotIntervalSecs() * 1000){

            @Override
            protected void onTrigger() {
                NodeImpl.this.handleSnapshotTimeout();
            }
        };
        this.configManager = new ConfigurationManager();
        this.applyDisruptor = new Disruptor((EventFactory)new LogEntryAndClosureFactory(), this.raftOptions.getDisruptorBufferSize(), (ThreadFactory)new NamedThreadFactory("Jraft-NodeImpl-Disruptor-", true));
        this.applyDisruptor.handleEventsWith(new EventHandler[]{new LogEntryAndClosureHandler()});
        this.applyDisruptor.setDefaultExceptionHandler(new LogExceptionHandler(this.getClass().getSimpleName()));
        this.applyDisruptor.start();
        this.applyQueue = this.applyDisruptor.getRingBuffer();
        this.fsmCaller = new FSMCallerImpl();
        if (!this.initLogStorage()) {
            LOG.error("Node {} initLogStorage failed.", (Object)this.getNodeId());
            return false;
        }
        if (!this.initMetaStorage()) {
            LOG.error("Node {} initMetaStorage failed.", (Object)this.getNodeId());
            return false;
        }
        if (!this.initFSMCaller(new LogId(0L, 0L))) {
            LOG.error("Node {} initFSMCaller failed.", (Object)this.getNodeId());
            return false;
        }
        this.ballotBox = new BallotBox();
        BallotBoxOptions ballotBoxOptions = new BallotBoxOptions();
        ballotBoxOptions.setWaiter(this.fsmCaller);
        ballotBoxOptions.setClosureQueue(this.closureQueue);
        if (!this.ballotBox.init(ballotBoxOptions)) {
            LOG.error("Node {} init ballotBox failed.", (Object)this.getNodeId());
            return false;
        }
        if (!this.initSnapshotStorage()) {
            LOG.error("Node {} initSnapshotStorage failed.", (Object)this.getNodeId());
            return false;
        }
        Status st = this.logManager.checkConsistency();
        if (!st.isOk()) {
            LOG.error("Node {} is initialized with inconsitency log:{}", (Object)this.getNodeId(), (Object)st);
            return false;
        }
        this.conf = new ConfigurationEntry();
        this.conf.setId(new LogId());
        if (this.logManager.getLastLogIndex() > 0L) {
            this.conf = this.logManager.checkAndSetConfiguration(this.conf);
        } else {
            this.conf.setConf(this.options.getInitialConf());
        }
        this.replicatorGroup = new ReplicatorGroupImpl();
        this.rpcService = new BoltRaftClientService(this.replicatorGroup);
        ReplicatorGroupOptions rgOptions = new ReplicatorGroupOptions();
        rgOptions.setHeartbeatTimeoutMs(this.heartbeatTimeout(this.options.getElectionTimeoutMs()));
        rgOptions.setElectionTimeoutMs(this.options.getElectionTimeoutMs());
        rgOptions.setLogManager(this.logManager);
        rgOptions.setBallotBox(this.ballotBox);
        rgOptions.setNode(this);
        rgOptions.setRaftRpcClientService(this.rpcService);
        rgOptions.setSnapshotStorage(this.snapshotExecutor != null ? this.snapshotExecutor.getSnapshotStorage() : null);
        rgOptions.setRaftOptions(this.raftOptions);
        rgOptions.setTimerManager(this.timerManager);
        this.options.setMetricRegistry(this.metrics.getMetricRegistry());
        if (!this.rpcService.init(this.options)) {
            LOG.error("Fail to init rpc service.");
            return false;
        }
        this.replicatorGroup.init(new NodeId(this.groupId, this.serverId), rgOptions);
        this.readOnlyService = new ReadOnlyServiceImpl();
        ReadOnlyServiceOptions readOnlyServiceOptions = new ReadOnlyServiceOptions();
        readOnlyServiceOptions.setFsmCaller(this.fsmCaller);
        readOnlyServiceOptions.setNode(this);
        readOnlyServiceOptions.setRaftOptions(this.raftOptions);
        if (!this.readOnlyService.init(readOnlyServiceOptions)) {
            LOG.error("Fail to init readOnlyService");
            return false;
        }
        this.state = State.STATE_FOLLOWER;
        if (LOG.isInfoEnabled()) {
            LOG.info("Node {} init, term: {}, lastLogId: {}, conf: {}, old_conf: {}", new Object[]{this.getNodeId(), this.currTerm, this.logManager.getLastLogId(false), this.conf.getConf(), this.conf.getOldConf()});
        }
        if (this.snapshotExecutor != null && this.options.getSnapshotIntervalSecs() > 0) {
            LOG.debug("Node {} term {} start snapshot timer.", (Object)this.getNodeId(), (Object)this.currTerm);
            this.snapshotTimer.start();
        }
        if (!this.conf.isEmpty()) {
            this.stepDown(this.currTerm, false, new Status());
        }
        if (!NodeManager.getInstance().add(this)) {
            LOG.error("NodeManager add {} failed", (Object)this.getNodeId());
            return false;
        }
        this.writeLock.lock();
        if (this.conf.isStable() && this.conf.getConf().size() == 1 && this.conf.getConf().contains(this.serverId)) {
            this.electSelf();
        } else {
            this.writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void electSelf() {
        long oldTerm;
        try {
            LOG.info("Node {} term {} start vote and grant vote self", (Object)this.getNodeId(), (Object)this.currTerm);
            if (!this.conf.contains(this.serverId)) {
                LOG.warn("Node {} can't do electSelf as it is not in {}", (Object)this.getNodeId(), (Object)this.conf.getConf());
                return;
            }
            if (this.state == State.STATE_FOLLOWER) {
                LOG.debug("Node {} term {} stop election timer", (Object)this.getNodeId(), (Object)this.currTerm);
                this.electionTimer.stop();
            }
            PeerId emptyId = new PeerId();
            this.resetLeaderId(emptyId, new Status(RaftError.ERAFTTIMEDOUT, "A follower's leader_id is reset to NULL as it begins to request_vote.", new Object[0]));
            this.state = State.STATE_CANDIDATE;
            ++this.currTerm;
            this.votedId = this.serverId.copy();
            LOG.debug("Node {} term {} start vote_timer", (Object)this.getNodeId(), (Object)this.currTerm);
            this.voteTimer.start();
            this.voteCtx.init(this.conf.getConf(), this.conf.isStable() ? null : this.conf.getOldConf());
            oldTerm = this.currTerm;
        }
        finally {
            this.writeLock.unlock();
        }
        LogId lastLogId = this.logManager.getLastLogId(true);
        this.writeLock.lock();
        try {
            if (oldTerm != this.currTerm) {
                LOG.warn("Node {} raise term {} when getLastLogId.", (Object)this.getNodeId(), (Object)this.currTerm);
                return;
            }
            for (PeerId peer : this.conf.listPeers()) {
                if (peer.equals(this.serverId)) continue;
                if (!this.rpcService.connect(peer.getEndpoint())) {
                    LOG.warn("Node {} channel init failed, addr: {}", (Object)this.getNodeId(), (Object)peer.getEndpoint());
                    continue;
                }
                OnRequestVoteRpcDone done = new OnRequestVoteRpcDone(peer, this.currTerm, this);
                RpcRequests.RequestVoteRequest.Builder reqBuilder = RpcRequests.RequestVoteRequest.newBuilder();
                reqBuilder.setPreVote(false);
                reqBuilder.setGroupId(this.groupId);
                reqBuilder.setServerId(this.serverId.toString());
                reqBuilder.setPeerId(peer.toString());
                reqBuilder.setTerm(this.currTerm);
                reqBuilder.setLastLogIndex(lastLogId.getIndex());
                reqBuilder.setLastLogTerm(lastLogId.getTerm());
                done.request = reqBuilder.build();
                this.rpcService.requestVote(peer.getEndpoint(), done.request, done);
            }
            this.metaStorage.setTermAndVotedFor(this.currTerm, this.serverId);
            this.voteCtx.grant(this.serverId);
            if (this.voteCtx.isGranted()) {
                this.becomeLeader();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void resetLeaderId(PeerId newLeaderId, Status status) {
        if (newLeaderId.isEmpty()) {
            if (!this.leaderId.isEmpty() && this.state.compareTo(State.STATE_TRANSFERRING) > 0) {
                this.fsmCaller.onStopFollowing(new LeaderChangeContext(this.leaderId.copy(), this.currTerm, status));
            }
            this.leaderId = PeerId.emptyPeer();
        } else {
            if (this.leaderId == null || this.leaderId.isEmpty()) {
                this.fsmCaller.onStartFollowing(new LeaderChangeContext(newLeaderId, this.currTerm, status));
            }
            this.leaderId = newLeaderId.copy();
        }
    }

    private void checkStepDown(long requestTerm, PeerId serverId) {
        Status status = new Status();
        if (requestTerm > this.currTerm) {
            status.setError(RaftError.ENEWLEADER, "Raft node receives message from new leader with higher term.", new Object[0]);
            this.stepDown(requestTerm, false, status);
        } else if (this.state != State.STATE_FOLLOWER) {
            status.setError(RaftError.ENEWLEADER, "Candidate receives message from new leader with the same term.", new Object[0]);
            this.stepDown(requestTerm, false, status);
        } else if (this.leaderId.isEmpty()) {
            status.setError(RaftError.ENEWLEADER, "Follower receives message from new leader with the same term.", new Object[0]);
            this.stepDown(requestTerm, false, status);
        }
        if (this.leaderId == null || this.leaderId.isEmpty()) {
            this.resetLeaderId(serverId, status);
        }
    }

    private void becomeLeader() {
        Requires.requireTrue(this.state == State.STATE_CANDIDATE, "Illegal state: " + (Object)((Object)this.state));
        LOG.info("Node {} term {} become leader of group {} {}", new Object[]{this.getNodeId(), this.currTerm, this.conf.getConf(), this.conf.getOldConf()});
        this.stopVoteTimer();
        this.state = State.STATE_LEADER;
        this.leaderId = this.serverId.copy();
        this.replicatorGroup.resetTerm(this.currTerm);
        for (PeerId peer : this.conf.listPeers()) {
            if (peer.equals(this.serverId)) continue;
            LOG.debug("Node {} term {} add replicator {}", new Object[]{this.getNodeId(), this.currTerm, peer});
            if (this.replicatorGroup.addReplicator(peer)) continue;
            LOG.error("Fail to add replicator for {}", (Object)peer);
        }
        this.ballotBox.resetPendingIndex(this.logManager.getLastLogIndex() + 1L);
        if (this.confCtx.isBusy()) {
            throw new IllegalStateException();
        }
        this.confCtx.flush(this.conf.getConf(), this.conf.getOldConf());
        this.stepDownTimer.start();
    }

    private void stepDown(long term, boolean wakeupCandidate, Status status) {
        LOG.debug("Node {} term {} stepDown from {} newTerm {} wakeupCandidate={}", new Object[]{this.getNodeId(), this.currTerm, term, wakeupCandidate});
        if (!this.state.isActive()) {
            return;
        }
        if (this.state == State.STATE_CANDIDATE) {
            this.stopVoteTimer();
        } else if (this.state.compareTo(State.STATE_TRANSFERRING) <= 0) {
            this.stopStepDownTimer();
            this.ballotBox.clearPendingTasks();
            if (this.state == State.STATE_LEADER) {
                this.onLeaderStop(status);
            }
        }
        PeerId emptyId = new PeerId();
        this.resetLeaderId(emptyId, status);
        this.state = State.STATE_FOLLOWER;
        this.confCtx.reset();
        this.updateLastLeaderTimestamp(Utils.monotonicMs());
        if (this.snapshotExecutor != null) {
            this.snapshotExecutor.interruptDownloadingSnapshots(term);
        }
        if (term > this.currTerm) {
            this.currTerm = term;
            this.votedId = PeerId.emptyPeer();
            this.metaStorage.setTermAndVotedFor(term, this.votedId);
        }
        if (wakeupCandidate) {
            this.wakingCandidate = this.replicatorGroup.stopAllAndFindTheNextCandidate(this.conf);
            if (this.wakingCandidate != null) {
                Replicator.sendTimeoutNowAndStop(this.wakingCandidate, this.options.getElectionTimeoutMs());
            }
        } else {
            this.replicatorGroup.stopAll();
        }
        if (this.stopTransferArg != null) {
            if (this.transferTimer != null) {
                this.transferTimer.cancel(true);
            }
            this.stopTransferArg = null;
        }
        this.electionTimer.start();
    }

    private void stopStepDownTimer() {
        if (this.stepDownTimer != null) {
            this.stepDownTimer.stop();
        }
    }

    private void stopVoteTimer() {
        if (this.voteTimer != null) {
            this.voteTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeApplyingTasks(List<LogEntryAndClosure> tasks) {
        this.writeLock.lock();
        try {
            int size = tasks.size();
            if (this.state != State.STATE_LEADER) {
                Status st = new Status();
                if (this.state != State.STATE_TRANSFERRING) {
                    st.setError(RaftError.EPERM, "is not leader", new Object[0]);
                } else {
                    st.setError(RaftError.EBUSY, "is transferring leadership", new Object[0]);
                }
                LOG.debug("Node {} can't apply {}", (Object)this.getNodeId(), (Object)st);
                for (int i = 0; i < size; ++i) {
                    LogEntryAndClosure task = tasks.get(i);
                    if (task.done == null) continue;
                    Utils.runClosureInThread(task.done, st);
                }
                return;
            }
            ArrayList<LogEntry> entries = new ArrayList<LogEntry>(tasks.size());
            for (int i = 0; i < size; ++i) {
                LogEntryAndClosure task = tasks.get(i);
                if (task.expectedTerm != -1L && task.expectedTerm != this.currTerm) {
                    LOG.debug("Node {} can't apply task whose expectedTerm={} doesn't match currTerm={}", new Object[]{this.getNodeId(), task.expectedTerm, this.currTerm});
                    if (task.done == null) continue;
                    Status st = new Status(RaftError.EPERM, "expected_term=%d doesn't match current_term=%d", task.expectedTerm, this.currTerm);
                    Utils.runClosureInThread(task.done, st);
                    continue;
                }
                task.entry.getId().setTerm(this.currTerm);
                task.entry.setType(EnumOutter.EntryType.ENTRY_TYPE_DATA);
                entries.add(task.entry);
                if (this.ballotBox.appendPendingTask(this.conf.getConf(), this.conf.isStable() ? null : this.conf.getOldConf(), task.done)) continue;
                Utils.runClosureInThread(task.done, new Status(RaftError.EINTERNAL, "Fail to append task.", new Object[0]));
                return;
            }
            this.logManager.appendEntries(entries, new LeaderStableClosure(entries));
            this.conf = this.logManager.checkAndSetConfiguration(this.conf);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public NodeMetrics getNodeMetrics() {
        return this.metrics;
    }

    @Override
    public void readIndex(byte[] requestContext, ReadIndexClosure done) {
        if (this.shutdownLatch != null) {
            Utils.runClosureInThread(done, new Status(RaftError.ENODESHUTDOWN, "Node is shutting down.", new Object[0]));
            throw new IllegalStateException("Node is shutting down.");
        }
        Requires.requireNonNull(done, "Null closure");
        this.readOnlyService.addRequest(requestContext, done);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleReadIndexRequest(RpcRequests.ReadIndexRequest request, RpcResponseClosure<RpcRequests.ReadIndexResponse> done) {
        RpcRequests.ReadIndexResponse.Builder respBuilder = RpcRequests.ReadIndexResponse.newBuilder();
        long startMs = Utils.monotonicMs();
        this.readLock.lock();
        try {
            switch (this.state) {
                case STATE_LEADER: {
                    this.readLeader(request, respBuilder, done);
                    return;
                }
                case STATE_FOLLOWER: {
                    this.readFollower(request, done);
                    return;
                }
                case STATE_TRANSFERRING: {
                    done.run(new Status(RaftError.EBUSY, "Is transferring leadership", new Object[0]));
                    return;
                }
                default: {
                    done.run(new Status(RaftError.EPERM, "Invalid state for readIndex: %s", new Object[]{this.state}));
                    return;
                }
            }
        }
        finally {
            this.readLock.unlock();
            this.metrics.recordLatency("handle-read-index", Utils.monotonicMs() - startMs);
            this.metrics.recordSize("handle-read-index-entries", request.getEntriesCount());
        }
    }

    private int getQuorum() {
        if (this.conf.getConf().isEmpty()) {
            return 0;
        }
        return this.conf.getConf().getPeers().size() / 2 + 1;
    }

    private void readFollower(RpcRequests.ReadIndexRequest request, RpcResponseClosure<RpcRequests.ReadIndexResponse> closure) {
        if (this.leaderId == null || this.leaderId.isEmpty()) {
            closure.run(new Status(RaftError.EPERM, "No leader at term %d.", this.currTerm));
        } else {
            RpcRequests.ReadIndexRequest newRequest = RpcRequests.ReadIndexRequest.newBuilder().mergeFrom(request).setPeerId(this.leaderId.toString()).build();
            this.rpcService.readIndex(this.leaderId.getEndpoint(), newRequest, -1, closure);
        }
    }

    private void readLeader(RpcRequests.ReadIndexRequest request, RpcRequests.ReadIndexResponse.Builder respBuilder, RpcResponseClosure<RpcRequests.ReadIndexResponse> closure) {
        block10: {
            block9: {
                ReadOnlyOption readOnlyOpt;
                int quorum = this.getQuorum();
                if (quorum <= 1) break block9;
                long lastCommittedIndex = this.ballotBox.getLastCommittedIndex();
                if (this.logManager.getTerm(lastCommittedIndex) != this.currTerm) {
                    closure.run(new Status(RaftError.EAGAIN, "ReadIndex request rejected because leader has not committed any log entry at its term, logIndex=%d, currTerm=%d", lastCommittedIndex, this.currTerm));
                    return;
                }
                respBuilder.setIndex(lastCommittedIndex);
                if (request.getPeerId() != null) {
                    PeerId peer = new PeerId();
                    peer.parse(request.getServerId());
                    if (!this.getConf().contains(peer)) {
                        closure.run(new Status(RaftError.EPERM, "Peer %s is not in current configuration: {}", peer, this.getConf()));
                        return;
                    }
                }
                if ((readOnlyOpt = this.raftOptions.getReadOnlyOptions()) == ReadOnlyOption.ReadOnlyLeaseBased && !this.isLeaderLeaseValid()) {
                    readOnlyOpt = ReadOnlyOption.ReadOnlySafe;
                }
                switch (readOnlyOpt) {
                    case ReadOnlySafe: {
                        List<PeerId> peers = this.conf.getConf().getPeers();
                        Requires.requireNonNull(peers, "Peer is null");
                        Requires.requireTrue(!peers.isEmpty(), "Peer is empty");
                        ReadIndexHeartbeatResponseClosure heartbeatDone = new ReadIndexHeartbeatResponseClosure(closure, respBuilder, quorum, peers.size());
                        for (PeerId peer : peers) {
                            if (peer.equals(this.serverId)) continue;
                            this.replicatorGroup.sendHeartbeat(peer, heartbeatDone);
                        }
                        break block10;
                    }
                    case ReadOnlyLeaseBased: {
                        respBuilder.setSuccess(true);
                        closure.setResponse(respBuilder.build());
                        closure.run(Status.OK());
                    }
                }
                break block10;
            }
            respBuilder.setSuccess(true);
            respBuilder.setIndex(this.ballotBox.getLastCommittedIndex());
            closure.setResponse(respBuilder.build());
            closure.run(Status.OK());
        }
    }

    @Override
    public void apply(Task task) {
        if (this.shutdownLatch != null) {
            Utils.runClosureInThread(task.getDone(), new Status(RaftError.ENODESHUTDOWN, "Node is shutting down.", new Object[0]));
            throw new IllegalStateException("Node is shutting down.");
        }
        Requires.requireNonNull(task, "Null task");
        LogEntry entry = new LogEntry();
        entry.setData(task.getData());
        try {
            this.applyQueue.publishEvent((event, sequence) -> {
                event.reset();
                event.done = task.getDone();
                event.entry = entry;
                event.expectedTerm = task.getExpectedTerm();
            });
        }
        catch (Exception e) {
            Utils.runClosureInThread(task.getDone(), new Status(RaftError.EPERM, "Node is down.", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message handlePreVoteRequest(RpcRequests.RequestVoteRequest request) {
        boolean doUnlock = true;
        this.writeLock.lock();
        try {
            if (!this.state.isActive()) {
                LOG.warn("Node {} is not in active state, current term {}", (Object)this.getNodeId(), (Object)this.currTerm);
                RpcRequests.ErrorResponse errorResponse = RpcResponseFactory.newResponse(RaftError.EINVAL, "Node %s is not in active state, state %s.", this.getNodeId(), this.state.name());
                return errorResponse;
            }
            PeerId candidateId = new PeerId();
            if (!candidateId.parse(request.getServerId())) {
                LOG.warn("Node {} received PreVote from {} serverId bad format", (Object)this.getNodeId(), (Object)request.getServerId());
                RpcRequests.ErrorResponse errorResponse = RpcResponseFactory.newResponse(RaftError.EINVAL, "Parse candidateId failed: %s.", request.getServerId());
                return errorResponse;
            }
            boolean granted = false;
            if (this.leaderId != null && !this.leaderId.isEmpty() && this.isCurrentLeaderValid()) {
                LOG.info("Node {} ignore PreVote from {} in term {} currTerm {}, because the leader {}'s lease is still valid.", new Object[]{this.getNodeId(), request.getServerId(), request.getTerm(), this.currTerm, this.leaderId});
            } else if (request.getTerm() < this.currTerm) {
                LOG.info("Node {} ignore PreVote from {} in term {} currTerm {}", new Object[]{this.getNodeId(), request.getServerId(), request.getTerm(), this.currTerm});
                this.checkReplicator(candidateId);
            } else {
                if (request.getTerm() == this.currTerm + 1L) {
                    this.checkReplicator(candidateId);
                }
                doUnlock = false;
                this.writeLock.unlock();
                LogId logId = this.logManager.getLastLogId(true);
                doUnlock = true;
                this.writeLock.lock();
                LogId requestLastLogId = new LogId(request.getLastLogIndex(), request.getLastLogTerm());
                granted = requestLastLogId.compareTo(logId) >= 0;
                LOG.info("Node {} received PreVote from {} in term {} currTerm {} granted {}, request last logId: {}, current last logId: {}", new Object[]{this.getNodeId(), request.getServerId(), request.getTerm(), this.currTerm, granted, requestLastLogId, logId});
            }
            RpcRequests.RequestVoteResponse.Builder responseBuilder = RpcRequests.RequestVoteResponse.newBuilder();
            responseBuilder.setTerm(this.currTerm);
            responseBuilder.setGranted(granted);
            RpcRequests.RequestVoteResponse requestVoteResponse = responseBuilder.build();
            return requestVoteResponse;
        }
        finally {
            if (doUnlock) {
                this.writeLock.unlock();
            }
        }
    }

    private boolean isLeaderLeaseValid() {
        long monotonicNowMs = Utils.monotonicMs();
        if (this.checkLeaderLease(monotonicNowMs)) {
            return true;
        }
        this.checkDeadNodes0(this.conf.getConf().getPeers(), monotonicNowMs, false, null);
        return this.checkLeaderLease(monotonicNowMs);
    }

    private boolean checkLeaderLease(long monotonicNowMs) {
        return monotonicNowMs - this.lastLeaderTimestamp < (long)this.options.getLeaderLeaseTimeoutMs();
    }

    private boolean isCurrentLeaderValid() {
        return Utils.monotonicMs() - this.lastLeaderTimestamp < (long)this.options.getElectionTimeoutMs();
    }

    private void updateLastLeaderTimestamp(long lastLeaderTimestamp) {
        this.lastLeaderTimestamp = lastLeaderTimestamp;
    }

    private void checkReplicator(PeerId candidateId) {
        if (this.state == State.STATE_LEADER) {
            this.replicatorGroup.checkReplicator(candidateId, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message handleRequestVoteRequest(RpcRequests.RequestVoteRequest request) {
        boolean doUnlock = true;
        this.writeLock.lock();
        try {
            if (!this.state.isActive()) {
                LOG.warn("Node {} is not in active state, current term {}", (Object)this.getNodeId(), (Object)this.currTerm);
                RpcRequests.ErrorResponse errorResponse = RpcResponseFactory.newResponse(RaftError.EINVAL, "Node %s is not in active state, state %s.", this.getNodeId(), this.state.name());
                return errorResponse;
            }
            PeerId candidateId = new PeerId();
            if (!candidateId.parse(request.getServerId())) {
                LOG.warn("Node {} received RequestVoteRequest from {} serverId bad format", (Object)this.getNodeId(), (Object)request.getServerId());
                RpcRequests.ErrorResponse errorResponse = RpcResponseFactory.newResponse(RaftError.EINVAL, "Parse candidateId failed: %s.", request.getServerId());
                return errorResponse;
            }
            if (request.getTerm() < this.currTerm) {
                LOG.info("Node {} ignore RequestVoteRequest from {} in term {} currTerm {}", new Object[]{this.getNodeId(), request.getServerId(), request.getTerm(), this.currTerm});
            } else {
                LOG.info("Node {} received RequestVoteRequest from {} in term {} currTerm {}", new Object[]{this.getNodeId(), request.getServerId(), request.getTerm(), this.currTerm});
                if (request.getTerm() > this.currTerm) {
                    this.stepDown(request.getTerm(), false, new Status(RaftError.EHIGHERTERMRESPONSE, "Raft node receives higher term RequestVoteRequest.", new Object[0]));
                }
                doUnlock = false;
                this.writeLock.unlock();
                LogId lastLogId = this.logManager.getLastLogId(true);
                doUnlock = true;
                this.writeLock.lock();
                if (request.getTerm() != this.currTerm) {
                    LOG.warn("Node {} raise term {} when get lastLogId", (Object)this.getNodeId(), (Object)this.currTerm);
                } else {
                    boolean logIsOk;
                    boolean bl = logIsOk = new LogId(request.getLastLogIndex(), request.getLastLogTerm()).compareTo(lastLogId) >= 0;
                    if (logIsOk && (this.votedId == null || this.votedId.isEmpty())) {
                        this.stepDown(request.getTerm(), false, new Status(RaftError.EVOTEFORCANDIDATE, "Raft node votes for some candidate, step down to restart election_timer.", new Object[0]));
                        this.votedId = candidateId.copy();
                        this.metaStorage.setVotedFor(candidateId);
                    }
                }
            }
            RpcRequests.RequestVoteResponse.Builder responseBuilder = RpcRequests.RequestVoteResponse.newBuilder();
            responseBuilder.setTerm(this.currTerm);
            responseBuilder.setGranted(request.getTerm() == this.currTerm && this.votedId.equals(candidateId));
            RpcRequests.RequestVoteResponse requestVoteResponse = responseBuilder.build();
            return requestVoteResponse;
        }
        finally {
            if (doUnlock) {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message handleAppendEntriesRequest(RpcRequests.AppendEntriesRequest request, RpcRequestClosure done) {
        boolean doUnlock = true;
        long startMs = Utils.monotonicMs();
        this.writeLock.lock();
        int entriesCount = request.getEntriesCount();
        try {
            RpcRequests.AppendEntriesResponse.Builder responseBuilder = RpcRequests.AppendEntriesResponse.newBuilder();
            responseBuilder.setTerm(this.currTerm);
            if (!this.state.isActive()) {
                LOG.warn("Node {} is not in active state, current term {}", (Object)this.getNodeId(), (Object)this.currTerm);
                RpcRequests.ErrorResponse errorResponse = RpcResponseFactory.newResponse(RaftError.EINVAL, "Node %s is not in active state, state %s.", this.getNodeId(), this.state.name());
                return errorResponse;
            }
            PeerId serverId = new PeerId();
            if (!serverId.parse(request.getServerId())) {
                LOG.warn("Node {} received AppendEntriesRequest from {} serverId bad format", (Object)this.getNodeId(), (Object)request.getServerId());
                RpcRequests.ErrorResponse errorResponse = RpcResponseFactory.newResponse(RaftError.EINVAL, "Parse serverId failed: %s.", request.getServerId());
                return errorResponse;
            }
            if (request.getTerm() < this.currTerm) {
                LOG.warn("Node {} ignore stale AppendEntriesRequest from {} in term {} currTerm {}", new Object[]{this.getNodeId(), request.getServerId(), request.getTerm(), this.currTerm});
                responseBuilder.setSuccess(false);
                responseBuilder.setTerm(this.currTerm);
                RpcRequests.AppendEntriesResponse appendEntriesResponse = responseBuilder.build();
                return appendEntriesResponse;
            }
            this.checkStepDown(request.getTerm(), serverId);
            if (!serverId.equals(this.leaderId)) {
                LOG.error("Another peer={} declares that it is the leader at term={} which was occupied by leader={}", new Object[]{serverId, this.currTerm, this.leaderId});
                this.stepDown(request.getTerm() + 1L, false, new Status(RaftError.ELEADERCONFLICT, "More than one leader in the same term.", new Object[0]));
                responseBuilder.setSuccess(false);
                responseBuilder.setTerm(request.getTerm() + 1L);
                RpcRequests.AppendEntriesResponse appendEntriesResponse = responseBuilder.build();
                return appendEntriesResponse;
            }
            this.updateLastLeaderTimestamp(Utils.monotonicMs());
            if (entriesCount > 0 && this.snapshotExecutor != null && this.snapshotExecutor.isInstallingSnapshot()) {
                LOG.warn("Node {} received AppendEntriesRequest while installing snapshot", (Object)this.getNodeId());
                RpcRequests.ErrorResponse errorResponse = RpcResponseFactory.newResponse(RaftError.EBUSY, "Node %s:%s is installing snapshot.", this.groupId, this.serverId);
                return errorResponse;
            }
            long prevLogIndex = request.getPrevLogIndex();
            long prevLogTerm = request.getPrevLogTerm();
            long localPrevLogTerm = this.logManager.getTerm(prevLogIndex);
            if (localPrevLogTerm != prevLogTerm) {
                long lastLogIndex = this.logManager.getLastLogIndex();
                LOG.warn("Node {} reject term_unmatched AppendEntriesRequest from {} in term {} prevLogIndex {} prevLogTerm {} localPrevLogTerm {} lastLogIndex {} entriesSize {}", new Object[]{this.getNodeId(), request.getServerId(), request.getTerm(), prevLogIndex, prevLogTerm, localPrevLogTerm, lastLogIndex, entriesCount});
                responseBuilder.setSuccess(false);
                responseBuilder.setTerm(this.currTerm);
                responseBuilder.setLastLogIndex(lastLogIndex);
                RpcRequests.AppendEntriesResponse appendEntriesResponse = responseBuilder.build();
                return appendEntriesResponse;
            }
            if (entriesCount == 0) {
                responseBuilder.setSuccess(true);
                responseBuilder.setTerm(this.currTerm);
                responseBuilder.setLastLogIndex(this.logManager.getLastLogIndex());
                doUnlock = false;
                this.writeLock.unlock();
                this.ballotBox.setLastCommittedIndex(Math.min(request.getCommittedIndex(), prevLogIndex));
                RpcRequests.AppendEntriesResponse lastLogIndex = responseBuilder.build();
                return lastLogIndex;
            }
            long index = prevLogIndex;
            ArrayList<LogEntry> entries = new ArrayList<LogEntry>(entriesCount);
            ByteBuffer allData = null;
            if (request.hasData()) {
                allData = request.getData().asReadOnlyByteBuffer();
            }
            List<RaftOutter.EntryMeta> entriesList = request.getEntriesList();
            for (int i = 0; i < entriesCount; ++i) {
                RaftOutter.EntryMeta entry = entriesList.get(i);
                ++index;
                if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_UNKNOWN) continue;
                LogEntry logEntry = new LogEntry();
                logEntry.setId(new LogId(index, entry.getTerm()));
                logEntry.setType(entry.getType());
                long dataLen = entry.getDataLen();
                if (dataLen > 0L) {
                    byte[] bs = new byte[(int)dataLen];
                    assert (allData != null);
                    allData.get(bs, 0, bs.length);
                    logEntry.setData(ByteBuffer.wrap(bs));
                }
                if (entry.getPeersCount() > 0) {
                    if (entry.getType() != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
                        throw new IllegalStateException();
                    }
                    ArrayList<PeerId> peers = new ArrayList<PeerId>(entry.getPeersCount());
                    for (String peerStr : entry.getPeersList()) {
                        PeerId peer = new PeerId();
                        peer.parse(peerStr);
                        peers.add(peer);
                    }
                    logEntry.setPeers(peers);
                    if (entry.getOldPeersCount() > 0) {
                        ArrayList<PeerId> oldPeers = new ArrayList<PeerId>(entry.getOldPeersCount());
                        for (String peerStr : entry.getOldPeersList()) {
                            PeerId peer = new PeerId();
                            peer.parse(peerStr);
                            oldPeers.add(peer);
                        }
                        logEntry.setOldPeers(oldPeers);
                    }
                } else if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
                    throw new IllegalStateException("Invalid log entry that contains zero peers but is ENTRY_TYPE_CONFIGURATION type.");
                }
                entries.add(logEntry);
            }
            FollowerStableClosure c = new FollowerStableClosure(request, responseBuilder, this, done, this.currTerm);
            this.logManager.appendEntries(entries, c);
            this.conf = this.logManager.checkAndSetConfiguration(this.conf);
            Message message = null;
            return message;
        }
        finally {
            if (doUnlock) {
                this.writeLock.unlock();
            }
            this.metrics.recordLatency("handle-append-entries", Utils.monotonicMs() - startMs);
            this.metrics.recordSize("handle-append-entries-count", entriesCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseTermTo(long newTerm, Status status) {
        this.writeLock.lock();
        try {
            if (newTerm < this.currTerm) {
                return;
            }
            this.stepDown(newTerm, false, status);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCaughtUp(PeerId peer, long term, long version, Status st) {
        this.writeLock.lock();
        try {
            if (term != this.currTerm && this.state != State.STATE_LEADER) {
                return;
            }
            if (st.isOk()) {
                this.confCtx.onCaughtUp(version, peer, true);
                return;
            }
            if (st.getCode() == RaftError.ETIMEDOUT.getNumber() && Utils.monotonicMs() - this.replicatorGroup.getLastRpcSendTimestamp(peer) <= (long)this.options.getElectionTimeoutMs()) {
                LOG.debug("Node {} waits peer {} to catch up", (Object)this.getNodeId(), (Object)peer);
                OnCaughtUp caughtUp = new OnCaughtUp(this, term, peer, version);
                long dueTime = Utils.nowMs() + (long)this.options.getElectionTimeoutMs();
                if (this.replicatorGroup.waitCaughtUp(peer, this.options.getCatchupMargin(), dueTime, caughtUp)) {
                    return;
                }
                LOG.warn("Node {} waitCaughtUp failed, peer {}", (Object)this.getNodeId(), (Object)peer);
            }
            this.confCtx.onCaughtUp(version, peer, false);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void checkDeadNodes(Configuration conf, long monotonicNowMs) {
        Configuration deadNodes;
        List<PeerId> peers = conf.listPeers();
        if (this.checkDeadNodes0(peers, monotonicNowMs, true, deadNodes = new Configuration())) {
            return;
        }
        LOG.warn("Node {} term {} steps down when alive nodes don't satisfy quorum dead nodes: {} conf: {}", new Object[]{this.getNodeId(), this.currTerm, deadNodes, conf});
        Status status = new Status();
        status.setError(RaftError.ERAFTTIMEDOUT, "Majority of the group dies: %d/%d", deadNodes.size(), peers.size());
        this.stepDown(this.currTerm, false, status);
    }

    private boolean checkDeadNodes0(List<PeerId> peers, long monotonicNowMs, boolean checkReplicator, Configuration deadNodes) {
        int leaderLeaseTimeoutMs = this.options.getLeaderLeaseTimeoutMs();
        int aliveCount = 0;
        long startLease = Long.MAX_VALUE;
        for (PeerId peer : peers) {
            long lastRpcSendTimestamp;
            if (peer.equals(this.serverId)) {
                ++aliveCount;
                continue;
            }
            if (checkReplicator) {
                this.checkReplicator(peer);
            }
            if (monotonicNowMs - (lastRpcSendTimestamp = this.replicatorGroup.getLastRpcSendTimestamp(peer)) <= (long)leaderLeaseTimeoutMs) {
                ++aliveCount;
                if (startLease <= lastRpcSendTimestamp) continue;
                startLease = lastRpcSendTimestamp;
                continue;
            }
            if (deadNodes == null) continue;
            deadNodes.addPeer(peer);
        }
        if (aliveCount >= peers.size() / 2 + 1) {
            this.updateLastLeaderTimestamp(startLease);
            return true;
        }
        return false;
    }

    private void handleStepDownTimeout() {
        this.writeLock.lock();
        try {
            if (this.state.compareTo(State.STATE_TRANSFERRING) > 0) {
                LOG.debug("Node {} term {} stop stepdown timer state is {}", new Object[]{this.getNodeId(), this.currTerm, this.state});
                return;
            }
            long monotonicNowMs = Utils.monotonicMs();
            this.checkDeadNodes(this.conf.getConf(), monotonicNowMs);
            if (!this.conf.getOldConf().isEmpty()) {
                this.checkDeadNodes(this.conf.getOldConf(), monotonicNowMs);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void unsafeApplyConfiguration(Configuration newConf, Configuration oldConf, boolean leaderStart) {
        ConfigurationChangeDone configurationChangeDone;
        Requires.requireTrue(this.confCtx.isBusy(), "ConfigurationContext is not busy");
        LogEntry entry = new LogEntry(EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION);
        entry.setId(new LogId(0L, this.currTerm));
        entry.setPeers(newConf.listPeers());
        if (oldConf != null) {
            entry.setOldPeers(oldConf.listPeers());
        }
        if (!this.ballotBox.appendPendingTask(newConf, oldConf, configurationChangeDone = new ConfigurationChangeDone(this.currTerm, leaderStart))) {
            Utils.runClosureInThread(configurationChangeDone, new Status(RaftError.EINTERNAL, "Fail to append task.", new Object[0]));
            return;
        }
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        entries.add(entry);
        this.logManager.appendEntries(entries, new LeaderStableClosure(entries));
        this.conf = this.logManager.checkAndSetConfiguration(this.conf);
    }

    private void unsafeRegisterConfChange(Configuration oldConf, Configuration newConf, Closure done) {
        if (this.state != State.STATE_LEADER) {
            LOG.warn("Node {} refushed configuration changing as the state is {}", (Object)this.getNodeId(), (Object)this.state);
            if (done != null) {
                Status status = new Status();
                if (this.state == State.STATE_TRANSFERRING) {
                    status.setError(RaftError.EBUSY, "Is transferring leadership.", new Object[0]);
                } else {
                    status.setError(RaftError.EPERM, "Not leader", new Object[0]);
                }
                Utils.runClosureInThread(done, status);
            }
            return;
        }
        if (this.confCtx.isBusy()) {
            LOG.warn("Node [] refushed configuration concurrent changing.", (Object)this.getNodeId());
            if (done != null) {
                Status status = new Status(RaftError.EBUSY, "Doing another configuration change.", new Object[0]);
                Utils.runClosureInThread(done, status);
            }
            return;
        }
        if (this.conf.getConf().equals(newConf)) {
            Utils.runClosureInThread(done);
            return;
        }
        this.confCtx.start(oldConf, newConf, done);
    }

    private void afterShutdown() {
        ArrayList<Closure> savedDones = null;
        this.writeLock.lock();
        try {
            if (!this.shutdownContinuations.isEmpty()) {
                savedDones = new ArrayList<Closure>(this.shutdownContinuations);
            }
            if (this.logStorage != null) {
                this.logStorage.shutdown();
            }
            this.state = State.STATE_SHUTDOWN;
        }
        finally {
            this.writeLock.unlock();
        }
        if (savedDones != null) {
            for (Closure closure : savedDones) {
                if (closure == null) continue;
                Utils.runClosureInThread(closure);
            }
        }
    }

    @Override
    public NodeOptions getOptions() {
        return this.options;
    }

    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    @Override
    public RaftOptions getRaftOptions() {
        return this.raftOptions;
    }

    @OnlyForTest
    long getCurrentTerm() {
        this.readLock.lock();
        try {
            long l = this.currTerm;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @OnlyForTest
    ConfigurationEntry getConf() {
        this.readLock.lock();
        try {
            ConfigurationEntry configurationEntry = this.conf;
            return configurationEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(null);
    }

    public void onConfigurationChangeDone(long term) {
        this.writeLock.lock();
        try {
            if (this.state.compareTo(State.STATE_TRANSFERRING) > 0 || term != this.currTerm) {
                LOG.warn("Node {} process onConfigurationChangeDone at term={} while state={} and currTerm={}", new Object[]{this.getNodeId(), term, this.state, this.currTerm});
                return;
            }
            this.confCtx.nextStage();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public PeerId getLeaderId() {
        this.readLock.lock();
        try {
            if (this.leaderId.isEmpty()) {
                PeerId peerId = null;
                return peerId;
            }
            PeerId peerId = this.leaderId;
            return peerId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public PeerId getServerId() {
        return this.serverId;
    }

    @Override
    public NodeId getNodeId() {
        if (this.nodeId == null) {
            this.nodeId = new NodeId(this.groupId, this.serverId);
        }
        return this.nodeId;
    }

    public RaftClientService getRpcService() {
        return this.rpcService;
    }

    public void onError(RaftException error) {
        LOG.warn("Node {} got error={}", (Object)this.getNodeId(), (Object)error);
        if (this.fsmCaller != null) {
            this.fsmCaller.onError(error);
        }
        this.writeLock.lock();
        try {
            if (this.state.compareTo(State.STATE_FOLLOWER) <= 0) {
                this.stepDown(this.currTerm, this.state == State.STATE_LEADER, new Status(RaftError.EBADNODE, "Raft node(leader or candidate) is in error.", new Object[0]));
            }
            if (this.state.compareTo(State.STATE_ERROR) < 0) {
                this.state = State.STATE_ERROR;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestVoteResponse(PeerId peerId, long term, RpcRequests.RequestVoteResponse response) {
        this.writeLock.lock();
        try {
            if (this.state != State.STATE_CANDIDATE) {
                LOG.warn("Node {} received invalid RequestVoteResponse from {} state not in STATE_CANDIDATE but {}", new Object[]{this.getNodeId(), peerId, this.state});
                return;
            }
            if (term != this.currTerm) {
                LOG.warn("Node {} received stale RequestVoteResponse from {}  term {} currTerm {}", new Object[]{this.getNodeId(), peerId, term, this.currTerm});
                return;
            }
            if (response.getTerm() > this.currTerm) {
                LOG.warn("Node {} received invalid RequestVoteResponse from {}  term {} expect {}", new Object[]{this.getNodeId(), peerId, response.getTerm(), this.currTerm});
                this.stepDown(response.getTerm(), false, new Status(RaftError.EHIGHERTERMRESPONSE, "Raft node receives higher term request_vote_response.", new Object[0]));
                return;
            }
            if (response.getGranted()) {
                this.voteCtx.grant(peerId);
                if (this.voteCtx.isGranted()) {
                    this.becomeLeader();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePreVoteResponse(PeerId peerId, long term, RpcRequests.RequestVoteResponse response) {
        boolean doUnlock = true;
        this.writeLock.lock();
        try {
            if (this.state != State.STATE_FOLLOWER) {
                LOG.warn("Node {} received invalid PreVoteResponse from {} state not in STATE_FOLLOWER but {}", new Object[]{this.getNodeId(), peerId, this.state});
                return;
            }
            if (term != this.currTerm) {
                LOG.warn("Node {} received invalid PreVoteResponse from {} term {} currTerm {}", new Object[]{this.getNodeId(), peerId, term, this.currTerm});
                return;
            }
            if (response.getTerm() > this.currTerm) {
                LOG.warn("Node {} received invalid PreVoteResponse from {} term {} expect {}", new Object[]{this.getNodeId(), peerId, response.getTerm(), this.currTerm});
                this.stepDown(response.getTerm(), false, new Status(RaftError.EHIGHERTERMRESPONSE, "Raft node receives higher term pre_vote_response.", new Object[0]));
                return;
            }
            LOG.info("Node {} received PreVoteResponse from {} term {} granted {}", new Object[]{this.getNodeId(), peerId, response.getTerm(), response.getGranted()});
            if (response.getGranted()) {
                this.prevVoteCtx.grant(peerId);
                if (this.prevVoteCtx.isGranted()) {
                    doUnlock = false;
                    this.electSelf();
                }
            }
        }
        finally {
            if (doUnlock) {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preVote() {
        long oldTerm;
        try {
            LOG.info("Node {} term {} start preVote", (Object)this.getNodeId(), (Object)this.currTerm);
            if (this.snapshotExecutor != null && this.snapshotExecutor.isInstallingSnapshot()) {
                LOG.warn("Node {} term {} doesn't do preVote when installing snapshot as the configuration may be out of date.", (Object)this.getNodeId());
                return;
            }
            if (!this.conf.contains(this.serverId)) {
                LOG.warn("Node {} can't do preVote as it is not in conf <{}>", (Object)this.getNodeId(), (Object)this.conf.getConf());
                return;
            }
            oldTerm = this.currTerm;
        }
        finally {
            this.writeLock.unlock();
        }
        LogId lastLogId = this.logManager.getLastLogId(true);
        boolean doUnlock = true;
        this.writeLock.lock();
        try {
            if (oldTerm != this.currTerm) {
                LOG.warn("Node {} raise term {} when get lastLogId", (Object)this.getNodeId(), (Object)this.currTerm);
                return;
            }
            this.prevVoteCtx.init(this.conf.getConf(), this.conf.isStable() ? null : this.conf.getOldConf());
            for (PeerId peer : this.conf.listPeers()) {
                if (peer.equals(this.serverId)) continue;
                if (!this.rpcService.connect(peer.getEndpoint())) {
                    LOG.warn("Node {} channel init failed, addr: {}", (Object)this.getNodeId(), (Object)peer.getEndpoint());
                    continue;
                }
                OnPreVoteRpcDone done = new OnPreVoteRpcDone(peer, this.currTerm);
                RpcRequests.RequestVoteRequest.Builder reqBuilder = RpcRequests.RequestVoteRequest.newBuilder();
                reqBuilder.setPreVote(true);
                reqBuilder.setGroupId(this.groupId);
                reqBuilder.setServerId(this.serverId.toString());
                reqBuilder.setPeerId(peer.toString());
                reqBuilder.setTerm(this.currTerm + 1L);
                reqBuilder.setLastLogIndex(lastLogId.getIndex());
                reqBuilder.setLastLogTerm(lastLogId.getTerm());
                done.request = reqBuilder.build();
                this.rpcService.preVote(peer.getEndpoint(), done.request, done);
            }
            this.prevVoteCtx.grant(this.serverId);
            if (this.prevVoteCtx.isGranted()) {
                doUnlock = false;
                this.electSelf();
            }
        }
        finally {
            if (doUnlock) {
                this.writeLock.unlock();
            }
        }
    }

    private void handleVoteTimeout() {
        this.writeLock.lock();
        if (this.state == State.STATE_CANDIDATE) {
            LOG.debug("Node {} term {} retry elect", (Object)this.getNodeId(), (Object)this.currTerm);
            this.electSelf();
        } else {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean isLeader() {
        this.readLock.lock();
        try {
            boolean bl = this.state == State.STATE_LEADER;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void shutdown(Closure done) {
        this.writeLock.lock();
        try {
            LOG.info("Node {} shutdown, currTerm {} state {}", new Object[]{this.getNodeId(), this.currTerm, this.state});
            if (this.state.compareTo(State.STATE_SHUTTING) < 0) {
                NodeManager.getInstance().remove(this);
                if (this.state.compareTo(State.STATE_FOLLOWER) <= 0) {
                    this.stepDown(this.currTerm, this.state == State.STATE_LEADER, new Status(RaftError.ESHUTDOWN, "Raft node is going to quit.", new Object[0]));
                }
                this.state = State.STATE_SHUTTING;
                if (this.electionTimer != null) {
                    this.electionTimer.destroy();
                }
                if (this.voteTimer != null) {
                    this.voteTimer.destroy();
                }
                if (this.stepDownTimer != null) {
                    this.stepDownTimer.destroy();
                }
                if (this.snapshotTimer != null) {
                    this.snapshotTimer.destroy();
                }
                if (this.readOnlyService != null) {
                    this.readOnlyService.shutdown();
                }
                if (this.logManager != null) {
                    this.logManager.shutdown();
                }
                if (this.metaStorage != null) {
                    this.metaStorage.shutdown();
                }
                if (this.snapshotExecutor != null) {
                    this.snapshotExecutor.shutdown();
                }
                if (this.wakingCandidate != null) {
                    Replicator.stop(this.wakingCandidate);
                }
                if (this.fsmCaller != null) {
                    this.fsmCaller.shutdown();
                }
                if (this.rpcService != null) {
                    this.rpcService.shutdown();
                }
                if (this.applyQueue != null) {
                    this.shutdownLatch = new CountDownLatch(1);
                    this.applyQueue.publishEvent((event, sequence) -> {
                        event.shutdownLatch = this.shutdownLatch;
                    });
                } else {
                    GLOBAL_NUM_NODES.decrementAndGet();
                }
                if (this.timerManager != null) {
                    this.timerManager.shutdown();
                }
            }
            if (this.state != State.STATE_SHUTDOWN) {
                if (done != null) {
                    this.shutdownContinuations.add(done);
                }
                return;
            }
            if (done != null) {
                Utils.runClosureInThread(done);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public synchronized void join() throws InterruptedException {
        if (this.shutdownLatch != null) {
            if (this.readOnlyService != null) {
                this.readOnlyService.join();
            }
            if (this.fsmCaller != null) {
                this.fsmCaller.join();
            }
            if (this.logManager != null) {
                this.logManager.join();
            }
            if (this.snapshotExecutor != null) {
                this.snapshotExecutor.join();
            }
            if (this.wakingCandidate != null) {
                Replicator.join(this.wakingCandidate);
            }
            this.shutdownLatch.await();
            this.applyDisruptor.shutdown();
            this.shutdownLatch = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransferTimeout(long term, PeerId peer) {
        LOG.info("Node {} failed to transfer leadership to peer={} : reached timeout", (Object)this.getNodeId(), (Object)peer);
        this.writeLock.lock();
        try {
            if (term == this.currTerm) {
                this.replicatorGroup.stopTransferLeadership(peer);
                if (this.state == State.STATE_TRANSFERRING) {
                    this.fsmCaller.onLeaderStart(term);
                    this.state = State.STATE_LEADER;
                    this.stopTransferArg = null;
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void onTransferTimeout(StopTransferArg arg) {
        arg.node.handleTransferTimeout(arg.term, arg.peer);
    }

    public Configuration getCurrentConf() {
        this.readLock.lock();
        try {
            if (this.conf != null && this.conf.getConf() != null) {
                Configuration configuration = this.conf.getConf().copy();
                return configuration;
            }
            Configuration configuration = null;
            return configuration;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<PeerId> listPeers() {
        this.readLock.lock();
        try {
            if (this.state != State.STATE_LEADER) {
                throw new IllegalStateException("Not leader");
            }
            List<PeerId> list = this.conf.getConf().listPeers();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPeer(PeerId peer, Closure done) {
        Requires.requireNonNull(peer, "Null peer");
        this.writeLock.lock();
        try {
            Requires.requireTrue(!this.conf.getConf().contains(peer), "Peer already exists in current configuration.");
            Configuration newConf = new Configuration(this.conf.getConf());
            newConf.addPeer(peer);
            this.unsafeRegisterConfChange(this.conf.getConf(), newConf, done);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePeer(PeerId peer, Closure done) {
        Requires.requireNonNull(peer, "Null peer");
        this.writeLock.lock();
        try {
            Requires.requireTrue(this.conf.getConf().contains(peer), "Peer not found in current configuration.");
            Configuration newConf = new Configuration(this.conf.getConf());
            newConf.removePeer(peer);
            this.unsafeRegisterConfChange(this.conf.getConf(), newConf, done);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void changePeers(Configuration newPeers, Closure done) {
        Requires.requireNonNull(newPeers, "Null new peers");
        Requires.requireTrue(!newPeers.isEmpty(), "Empty new peers");
        this.writeLock.lock();
        try {
            LOG.info("Node {} change peers from {} to {}", new Object[]{this.getNodeId(), this.conf.getConf(), newPeers});
            this.unsafeRegisterConfChange(this.conf.getConf(), newPeers, done);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status resetPeers(Configuration newPeers) {
        Requires.requireNonNull(newPeers, "Null new peers");
        Requires.requireTrue(!newPeers.isEmpty(), "Empty new peers");
        this.writeLock.lock();
        try {
            if (newPeers.isEmpty()) {
                LOG.warn("Node {} set empty peers", (Object)this.getNodeId());
                Status status = new Status(RaftError.EINVAL, "newPeers is empty", new Object[0]);
                return status;
            }
            if (!this.state.isActive()) {
                LOG.warn("Node {} is in state {}, can't set peers", (Object)this.getNodeId(), (Object)this.state);
                Status status = new Status(RaftError.EPERM, "Bad state: %s", new Object[]{this.state});
                return status;
            }
            if (this.conf.getConf().isEmpty()) {
                LOG.info("Node {} set peers to {} from empty", (Object)this.getNodeId(), (Object)newPeers);
                this.conf.setConf(newPeers);
                Status st = new Status(RaftError.ESETPEER, "Set peer from empty configuration", new Object[0]);
                this.stepDown(this.currTerm + 1L, false, st);
                Status status = Status.OK();
                return status;
            }
            if (this.state == State.STATE_LEADER && this.confCtx.isBusy()) {
                LOG.warn("Node {} set peers need wait current conf changing", (Object)this.getNodeId());
                Status st = new Status(RaftError.EBUSY, "Changing to another configuration", new Object[0]);
                return st;
            }
            if (this.conf.getConf().equals(newPeers)) {
                Status st = Status.OK();
                return st;
            }
            Configuration newConf = new Configuration(newPeers);
            LOG.info("Node {} set peers from {} to {}", new Object[]{this.getNodeId(), this.conf.getConf(), newPeers});
            this.conf.setConf(newConf);
            this.conf.getOldConf().reset();
            this.stepDown(this.currTerm + 1L, false, new Status(RaftError.ESETPEER, "Raft node set peer normally", new Object[0]));
            Status status = Status.OK();
            return status;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void snapshot(Closure done) {
        this.doSnapshot(done);
    }

    private void doSnapshot(Closure done) {
        if (this.snapshotExecutor != null) {
            this.snapshotExecutor.doSnapshot(done);
        } else if (done != null) {
            Status status = new Status(RaftError.EINVAL, "Snapshot is not supported", new Object[0]);
            Utils.runClosureInThread(done, status);
        }
    }

    @Override
    public void resetElectionTimeoutMs(int electionTimeoutMs) {
        if (electionTimeoutMs <= 0) {
            throw new IllegalArgumentException("Invalid value");
        }
        this.writeLock.lock();
        try {
            this.options.setElectionTimeoutMs(electionTimeoutMs);
            this.replicatorGroup.resetHeartbeatInterval(this.heartbeatTimeout(this.options.getElectionTimeoutMs()));
            this.replicatorGroup.resetElectionTimeoutInterval(electionTimeoutMs);
            LOG.info("Node {} reset electionTimeout, currTimer {} state {} new electionTimeout {}", new Object[]{this.getNodeId(), this.currTerm, this.state, electionTimeoutMs});
            this.electionTimer.reset(electionTimeoutMs);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status transferLeadershipTo(PeerId peer) {
        Requires.requireNonNull(peer, "Null peer");
        this.writeLock.lock();
        try {
            StopTransferArg stopArg;
            if (this.state != State.STATE_LEADER) {
                LOG.warn("Node {} can't transfer leadership to peer {} as it is in state {}", new Object[]{this.getNodeId(), peer, this.state});
                Status status = new Status(this.state == State.STATE_TRANSFERRING ? RaftError.EBUSY : RaftError.EPERM, "Not a leader", new Object[0]);
                return status;
            }
            if (this.confCtx.isBusy()) {
                LOG.warn("Node {} refused to transfer leadership to peer {} when the leader is changing the configuration", (Object)this.getNodeId(), (Object)peer);
                Status status = new Status(RaftError.EBUSY, "Changing the configuration", new Object[0]);
                return status;
            }
            PeerId peerId = peer.copy();
            if (peerId.equals(PeerId.ANY_PEER)) {
                LOG.info("Node {} starts to transfer leadership to any peer.", (Object)this.getNodeId());
                peerId = this.replicatorGroup.findTheNextCandidate(this.conf);
                if (peerId == null) {
                    Status status = new Status(-1, "Candidate not found for any peer");
                    return status;
                }
            }
            if (peerId.equals(this.serverId)) {
                LOG.info("Node {} transferred leadership to self.");
                Status status = Status.OK();
                return status;
            }
            if (!this.conf.contains(peerId)) {
                LOG.info("Node {} refused to transfer leadership to peer {} as it is not in {}", new Object[]{this.getNodeId(), peer, this.conf.getConf()});
                Status status = new Status(RaftError.EINVAL, "Not in current configuration", new Object[0]);
                return status;
            }
            long lastLogIndex = this.logManager.getLastLogIndex();
            if (!this.replicatorGroup.transferLeadershipTo(peerId, lastLogIndex)) {
                LOG.warn("No such peer {}", (Object)peer);
                Status status = new Status(RaftError.EINVAL, "No such peer %s", peer);
                return status;
            }
            this.state = State.STATE_TRANSFERRING;
            Status status = new Status(RaftError.ETRANSFERLEADERSHIP, "Raft leader is transferring leadership to %s", peerId);
            this.onLeaderStop(status);
            LOG.info("Node {} starts to transfer leadership to peer {}", (Object)this.getNodeId(), (Object)peer);
            this.stopTransferArg = stopArg = new StopTransferArg(this, this.currTerm, peerId);
            this.transferTimer = this.timerManager.schedule(() -> this.onTransferTimeout(stopArg), this.options.getElectionTimeoutMs(), TimeUnit.MILLISECONDS);
        }
        finally {
            this.writeLock.unlock();
        }
        return Status.OK();
    }

    private void onLeaderStop(Status status) {
        this.replicatorGroup.clearFailureReplicators();
        this.fsmCaller.onLeaderStop(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message handleTimeoutNowRequest(RpcRequests.TimeoutNowRequest request, RpcRequestClosure done) {
        RpcRequests.TimeoutNowResponse.Builder rb = RpcRequests.TimeoutNowResponse.newBuilder();
        boolean doUnlock = true;
        this.writeLock.lock();
        try {
            if (request.getTerm() != this.currTerm) {
                long savedCurrTerm = this.currTerm;
                if (request.getTerm() > this.currTerm) {
                    this.stepDown(request.getTerm(), false, new Status(RaftError.EHIGHERTERMREQUEST, "Raft node receives higher term request", new Object[0]));
                }
                rb.setTerm(this.currTerm);
                rb.setSuccess(false);
                LOG.info("Node {} received TimeoutNowRequest from {} while currTerm={} didn't match requestTerm={}", new Object[]{this.getNodeId(), request.getPeerId(), savedCurrTerm, request.getTerm()});
                RpcRequests.TimeoutNowResponse timeoutNowResponse = rb.build();
                return timeoutNowResponse;
            }
            if (this.state != State.STATE_FOLLOWER) {
                LOG.info("Node {} received TimeoutNowRequest from {} while state is {} at term={}", new Object[]{this.getNodeId(), request.getServerId(), this.state, this.currTerm});
                rb.setTerm(this.currTerm);
                rb.setSuccess(false);
                RpcRequests.TimeoutNowResponse savedCurrTerm = rb.build();
                return savedCurrTerm;
            }
            long savedTerm = this.currTerm;
            rb.setTerm(this.currTerm + 1L);
            rb.setSuccess(true);
            done.sendResponse((Message)rb.build());
            doUnlock = false;
            this.electSelf();
            LOG.info("Node {} received TimeoutNowRequest from {} at term={}", new Object[]{this.getNodeId(), request.getServerId(), savedTerm});
        }
        finally {
            if (doUnlock) {
                this.writeLock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message handleInstallSnapshot(RpcRequests.InstallSnapshotRequest request, RpcRequestClosure done) {
        if (this.snapshotExecutor == null) {
            return RpcResponseFactory.newResponse(RaftError.EINVAL, "Not supported snapshot", new Object[0]);
        }
        PeerId serverId = new PeerId();
        if (!serverId.parse(request.getServerId())) {
            LOG.warn("Node {} ignore InstallSnapshotRequest from {} bad server id", (Object)this.getNodeId(), (Object)request.getServerId());
            return RpcResponseFactory.newResponse(RaftError.EINVAL, "Parse serverId failed: %s", request.getServerId());
        }
        RpcRequests.InstallSnapshotResponse.Builder responseBuilder = RpcRequests.InstallSnapshotResponse.newBuilder();
        this.writeLock.lock();
        try {
            if (!this.state.isActive()) {
                LOG.warn("Node {} ignore InstallSnapshotRequest as it is not in active state {}", (Object)this.getNodeId(), (Object)this.state);
                RpcRequests.ErrorResponse errorResponse = RpcResponseFactory.newResponse(RaftError.EINVAL, "Node %s:%s is not in active state, state %s.", this.groupId, this.serverId, this.state.name());
                return errorResponse;
            }
            if (request.getTerm() < this.currTerm) {
                LOG.warn("Node {} ignore stale InstallSnapshotRequest from {} in term {} currTerm {}", new Object[]{this.getNodeId(), request.getPeerId(), request.getTerm(), this.currTerm});
                responseBuilder.setTerm(this.currTerm);
                responseBuilder.setSuccess(false);
                RpcRequests.InstallSnapshotResponse installSnapshotResponse = responseBuilder.build();
                return installSnapshotResponse;
            }
            this.checkStepDown(request.getTerm(), serverId);
            if (!serverId.equals(this.leaderId)) {
                LOG.error("Another peer={} declares that it is the leader at term={} which was occupied by leader={}", new Object[]{serverId, this.currTerm, this.leaderId});
                this.stepDown(request.getTerm() + 1L, false, new Status(RaftError.ELEADERCONFLICT, "More than one leader in the same term.", new Object[0]));
                responseBuilder.setSuccess(false);
                responseBuilder.setTerm(request.getTerm() + 1L);
                RpcRequests.InstallSnapshotResponse installSnapshotResponse = responseBuilder.build();
                return installSnapshotResponse;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        long startMs = Utils.monotonicMs();
        try {
            LOG.info("Node {} received InstallSnapshotRequest lastIncludedLogIndex {} lastIncludedLogTerm {} from {} when lastLogId={}", new Object[]{this.getNodeId(), request.getMeta().getLastIncludedIndex(), request.getMeta().getLastIncludedTerm(), request.getServerId(), this.logManager.getLastLogId(false)});
            this.snapshotExecutor.installSnapshot(request, responseBuilder, done);
            Message message = null;
            return message;
        }
        finally {
            this.metrics.recordLatency("install-snapshot", Utils.monotonicMs() - startMs);
        }
    }

    public void updateConfigurationAfterInstallingSnapshot() {
        this.writeLock.lock();
        try {
            this.conf = this.logManager.checkAndSetConfiguration(this.conf);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void stopReplicator(List<PeerId> keep, List<PeerId> drop) {
        if (drop != null) {
            for (PeerId peer : drop) {
                if (keep.contains(peer) || peer.equals(this.serverId)) continue;
                this.replicatorGroup.stopReplicator(peer);
            }
        }
    }

    @Override
    public UserLog readCommittedUserLog(long index) {
        if (index <= 0L) {
            throw new LogIndexOutOfBoundsException("request index is invalid: " + index);
        }
        long savedLastAppliedIndex = this.fsmCaller.getLastAppliedIndex();
        if (index > savedLastAppliedIndex) {
            throw new LogIndexOutOfBoundsException("request index " + index + " is greater than lastAppliedIndex: " + savedLastAppliedIndex);
        }
        long curIndex = index;
        LogEntry entry = this.logManager.getEntry(curIndex);
        if (entry == null) {
            throw new LogNotFoundException("user log is deleted at index: " + index);
        }
        do {
            if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_DATA) {
                return new UserLog(curIndex, entry.getData());
            }
            if (++curIndex <= savedLastAppliedIndex) continue;
            throw new IllegalStateException("No user log between index:" + index + " and last_applied_index:" + savedLastAppliedIndex);
        } while ((entry = this.logManager.getEntry(curIndex)) != null);
        throw new LogNotFoundException("user log is deleted at index: " + curIndex);
    }

    public String toString() {
        return "JRaftNode [nodeId=" + this.getNodeId() + "]";
    }

    private static class StopTransferArg {
        NodeImpl node;
        long term;
        PeerId peer;

        public StopTransferArg(NodeImpl node, long term, PeerId peer) {
            this.node = node;
            this.term = term;
            this.peer = peer;
        }
    }

    private class OnPreVoteRpcDone
    extends RpcResponseClosureAdapter<RpcRequests.RequestVoteResponse> {
        private final long startMs = Utils.monotonicMs();
        PeerId peer;
        long term;
        RpcRequests.RequestVoteRequest request;

        public OnPreVoteRpcDone(PeerId peer, long term) {
            this.peer = peer;
            this.term = term;
        }

        @Override
        public void run(Status status) {
            NodeImpl.this.metrics.recordLatency("pre-vote", Utils.monotonicMs() - this.startMs);
            if (!status.isOk()) {
                LOG.warn("Node {} PreVote to {} error: {}", new Object[]{NodeImpl.this.getNodeId(), this.peer, status});
            } else {
                NodeImpl.this.handlePreVoteResponse(this.peer, this.term, (RpcRequests.RequestVoteResponse)this.getResponse());
            }
        }
    }

    private class OnRequestVoteRpcDone
    extends RpcResponseClosureAdapter<RpcRequests.RequestVoteResponse> {
        long startMs = Utils.monotonicMs();
        PeerId peer;
        long term;
        RpcRequests.RequestVoteRequest request;
        NodeImpl node;

        public OnRequestVoteRpcDone(PeerId peer, long term, NodeImpl node) {
            this.peer = peer;
            this.term = term;
            this.node = node;
        }

        @Override
        public void run(Status status) {
            NodeImpl.this.metrics.recordLatency("request-vote", Utils.monotonicMs() - this.startMs);
            if (!status.isOk()) {
                LOG.warn("Node {} RequestVote to {} error: {}", new Object[]{this.node.getNodeId(), this.peer, status});
            } else {
                this.node.handleRequestVoteResponse(this.peer, this.term, (RpcRequests.RequestVoteResponse)this.getResponse());
            }
        }
    }

    private class ConfigurationChangeDone
    implements Closure {
        private final long term;
        private final boolean leaderStart;

        public ConfigurationChangeDone(long term, boolean leaderStart) {
            this.term = term;
            this.leaderStart = leaderStart;
        }

        @Override
        public void run(Status status) {
            if (status.isOk()) {
                NodeImpl.this.onConfigurationChangeDone(this.term);
                if (this.leaderStart) {
                    NodeImpl.this.getOptions().getFsm().onLeaderStart(this.term);
                }
            } else {
                LOG.error("Fail to run ConfigurationChangeDone, status : {}", (Object)status);
            }
        }
    }

    private static class OnCaughtUp
    extends CatchUpClosure {
        private final NodeImpl node;
        private final long term;
        private final PeerId peer;
        private final long version;

        public OnCaughtUp(NodeImpl node, long term, PeerId peer, long version) {
            this.node = node;
            this.term = term;
            this.peer = peer;
            this.version = version;
        }

        @Override
        public void run(Status status) {
            this.node.onCaughtUp(this.peer, this.term, this.version, status);
        }
    }

    private static class FollowerStableClosure
    extends LogManager.StableClosure {
        final long committedIndex;
        final RpcRequests.AppendEntriesResponse.Builder responseBuilder;
        final NodeImpl node;
        final RpcRequestClosure done;
        final long term;

        public FollowerStableClosure(RpcRequests.AppendEntriesRequest request, RpcRequests.AppendEntriesResponse.Builder responseBuilder, NodeImpl node, RpcRequestClosure done, long term) {
            super(null);
            this.committedIndex = Math.min(request.getCommittedIndex(), request.getPrevLogIndex() + (long)request.getEntriesCount());
            this.responseBuilder = responseBuilder;
            this.node = node;
            this.done = done;
            this.term = term;
        }

        @Override
        public void run(Status status) {
            if (!status.isOk()) {
                this.done.run(status);
                return;
            }
            this.node.readLock.lock();
            try {
                if (this.term != this.node.currTerm) {
                    this.responseBuilder.setSuccess(false);
                    this.responseBuilder.setTerm(this.node.currTerm);
                    this.done.sendResponse((Message)this.responseBuilder.build());
                    return;
                }
            }
            finally {
                this.node.readLock.unlock();
            }
            this.responseBuilder.setSuccess(true);
            this.responseBuilder.setTerm(this.term);
            this.node.ballotBox.setLastCommittedIndex(this.committedIndex);
            this.done.sendResponse((Message)this.responseBuilder.build());
        }
    }

    private class ReadIndexHeartbeatResponseClosure
    extends RpcResponseClosureAdapter<RpcRequests.AppendEntriesResponse> {
        RpcRequests.ReadIndexResponse.Builder respBuilder;
        RpcResponseClosure<RpcRequests.ReadIndexResponse> closure;
        int quorum;
        int failPeersThreshold;
        int ackSuccess;
        int ackFailures;
        boolean isDone;

        public ReadIndexHeartbeatResponseClosure(RpcResponseClosure<RpcRequests.ReadIndexResponse> closure, RpcRequests.ReadIndexResponse.Builder rb, int quorum, int peersCount) {
            this.quorum = quorum;
            this.closure = closure;
            this.respBuilder = rb;
            this.ackSuccess = 0;
            this.ackFailures = 0;
            this.isDone = false;
            this.failPeersThreshold = peersCount % 2 == 0 ? this.quorum - 1 : this.quorum;
        }

        @Override
        public synchronized void run(Status status) {
            if (this.isDone) {
                return;
            }
            if (status.isOk() && ((RpcRequests.AppendEntriesResponse)this.getResponse()).getSuccess()) {
                ++this.ackSuccess;
            } else {
                ++this.ackFailures;
            }
            if (this.ackSuccess + 1 >= this.quorum) {
                this.respBuilder.setSuccess(true);
                this.closure.setResponse(this.respBuilder.build());
                this.closure.run(Status.OK());
                this.isDone = true;
            } else if (this.ackFailures >= this.failPeersThreshold) {
                this.respBuilder.setSuccess(false);
                this.closure.setResponse(this.respBuilder.build());
                this.closure.run(Status.OK());
                this.isDone = true;
            }
        }
    }

    class LeaderStableClosure
    extends LogManager.StableClosure {
        public LeaderStableClosure(List<LogEntry> entries) {
            super(entries);
        }

        @Override
        public void run(Status status) {
            if (status.isOk()) {
                NodeImpl.this.ballotBox.commitAt(this.firstLogIndex, this.firstLogIndex + (long)this.nEntries - 1L, NodeImpl.this.serverId);
            } else {
                LOG.error("Node {} append [{}, {}] failed", new Object[]{NodeImpl.this.getNodeId(), this.firstLogIndex, this.firstLogIndex + (long)this.nEntries - 1L});
            }
        }
    }

    private static class BootstrapStableClosure
    extends LogManager.StableClosure {
        private final SynchronizedClosure done = new SynchronizedClosure();

        public BootstrapStableClosure() {
            super(null);
        }

        public Status await() throws InterruptedException {
            return this.done.await();
        }

        @Override
        public void run(Status status) {
            this.done.run(status);
        }
    }

    private static class ConfigurationCtx {
        NodeImpl node;
        Stage stage;
        int nchanges;
        long version;
        List<PeerId> newPeers = new ArrayList<PeerId>();
        List<PeerId> oldPeers = new ArrayList<PeerId>();
        List<PeerId> addingPeers = new ArrayList<PeerId>();
        Closure done;

        public ConfigurationCtx(NodeImpl node) {
            this.node = node;
            this.stage = Stage.STAGE_NONE;
            this.version = 0L;
            this.done = null;
        }

        void start(Configuration oldConf, Configuration newConf, Closure done) {
            if (this.isBusy()) {
                if (done != null) {
                    Utils.runClosureInThread(done, new Status(RaftError.EBUSY, "Already in busy stage.", new Object[0]));
                }
                throw new IllegalStateException("Busy stage");
            }
            if (this.done != null) {
                if (done != null) {
                    Utils.runClosureInThread(done, new Status(RaftError.EINVAL, "Already have done closure.", new Object[0]));
                }
                throw new IllegalArgumentException("Already have done closure.");
            }
            this.done = done;
            this.stage = Stage.STAGE_CATCHING_UP;
            this.oldPeers = oldConf.listPeers();
            this.newPeers = newConf.listPeers();
            Configuration adding = new Configuration();
            Configuration removing = new Configuration();
            newConf.diff(oldConf, adding, removing);
            this.nchanges = adding.size() + removing.size();
            if (adding.isEmpty()) {
                this.nextStage();
                return;
            }
            this.addingPeers = adding.listPeers();
            LOG.info("Adding peers: {}", this.addingPeers);
            for (PeerId newPeer : this.addingPeers) {
                if (!this.node.replicatorGroup.addReplicator(newPeer)) {
                    LOG.error("Node {} start the replicator failed, peer is {}", (Object)this.node.getNodeId(), (Object)newPeer);
                    this.onCaughtUp(this.version, newPeer, false);
                    return;
                }
                OnCaughtUp caughtUp = new OnCaughtUp(this.node, this.node.currTerm, newPeer, this.version);
                long dueTime = Utils.nowMs() + (long)this.node.options.getElectionTimeoutMs();
                if (this.node.replicatorGroup.waitCaughtUp(newPeer, this.node.options.getCatchupMargin(), dueTime, caughtUp)) continue;
                LOG.error("Node {} waitCaughtUp, peer is {}", (Object)this.node.getNodeId(), (Object)newPeer);
                this.onCaughtUp(this.version, newPeer, false);
                return;
            }
        }

        void onCaughtUp(long version, PeerId peer, boolean success) {
            if (version != this.version) {
                return;
            }
            Requires.requireTrue(this.stage == Stage.STAGE_CATCHING_UP, "stage is not in STAGE_CATCHING_UP.");
            if (success) {
                this.addingPeers.remove(peer);
                if (this.addingPeers.isEmpty()) {
                    this.nextStage();
                    return;
                }
                return;
            }
            LOG.warn("Node {} fail to catch up peer {} when trying to change peers from {} to {}.", new Object[]{this.node.getNodeId(), peer, this.oldPeers, this.newPeers});
            this.reset(new Status(RaftError.ECATCHUP, "Peer %s failed to catch up", peer));
        }

        void reset() {
            this.reset(null);
        }

        void reset(Status st) {
            if (st != null && st.isOk()) {
                this.node.stopReplicator(this.newPeers, this.oldPeers);
            } else {
                this.node.stopReplicator(this.oldPeers, this.newPeers);
            }
            this.newPeers.clear();
            this.oldPeers.clear();
            this.addingPeers.clear();
            ++this.version;
            this.stage = Stage.STAGE_NONE;
            this.nchanges = 0;
            if (this.done != null) {
                if (st == null) {
                    st = new Status(RaftError.EPERM, "leader stepped down.", new Object[0]);
                }
                Utils.runClosureInThread(this.done, st);
                this.done = null;
            }
        }

        void flush(Configuration conf, Configuration oldConf) {
            Requires.requireTrue(!this.isBusy(), "flush when busy");
            this.newPeers = conf.listPeers();
            if (oldConf == null || oldConf.isEmpty()) {
                this.stage = Stage.STAGE_STABLE;
                this.oldPeers = this.newPeers;
            } else {
                this.stage = Stage.STAGE_JOINT;
                this.oldPeers = oldConf.listPeers();
            }
            this.node.unsafeApplyConfiguration(conf, oldConf == null || oldConf.isEmpty() ? null : oldConf, true);
        }

        void nextStage() {
            Requires.requireTrue(this.isBusy(), "Not in busy stage");
            switch (this.stage) {
                case STAGE_CATCHING_UP: {
                    if (this.nchanges > 1) {
                        this.stage = Stage.STAGE_JOINT;
                        this.node.unsafeApplyConfiguration(new Configuration(this.newPeers), new Configuration(this.oldPeers), false);
                        return;
                    }
                }
                case STAGE_JOINT: {
                    this.stage = Stage.STAGE_STABLE;
                    this.node.unsafeApplyConfiguration(new Configuration(this.newPeers), null, false);
                    break;
                }
                case STAGE_STABLE: {
                    boolean shouldStepDown = !this.newPeers.contains(this.node.serverId);
                    this.reset(new Status());
                    if (!shouldStepDown) break;
                    this.node.stepDown(this.node.currTerm, true, new Status(RaftError.ELEADERREMOVED, "This node was removed.", new Object[0]));
                    break;
                }
                case STAGE_NONE: {
                    Requires.requireTrue(false, "Can't reach here.");
                }
            }
        }

        boolean isBusy() {
            return this.stage != Stage.STAGE_NONE;
        }

        static enum Stage {
            STAGE_NONE,
            STAGE_CATCHING_UP,
            STAGE_JOINT,
            STAGE_STABLE;

        }
    }

    private class LogEntryAndClosureHandler
    implements EventHandler<LogEntryAndClosure> {
        private final List<LogEntryAndClosure> tasks;

        private LogEntryAndClosureHandler() {
            this.tasks = new ArrayList<LogEntryAndClosure>(NodeImpl.this.raftOptions.getApplyBatch());
        }

        public void onEvent(LogEntryAndClosure event, long sequence, boolean endOfBatch) throws Exception {
            if (event.shutdownLatch != null) {
                if (!this.tasks.isEmpty()) {
                    NodeImpl.this.executeApplyingTasks(this.tasks);
                }
                GLOBAL_NUM_NODES.decrementAndGet();
                event.shutdownLatch.countDown();
                return;
            }
            this.tasks.add(event);
            if (this.tasks.size() >= NodeImpl.this.raftOptions.getApplyBatch() || endOfBatch) {
                NodeImpl.this.executeApplyingTasks(this.tasks);
                this.tasks.clear();
            }
        }
    }

    private static class LogEntryAndClosureFactory
    implements EventFactory<LogEntryAndClosure> {
        private LogEntryAndClosureFactory() {
        }

        public LogEntryAndClosure newInstance() {
            return new LogEntryAndClosure();
        }
    }

    private static class LogEntryAndClosure {
        LogEntry entry;
        Closure done;
        long expectedTerm;
        CountDownLatch shutdownLatch;

        private LogEntryAndClosure() {
        }

        public void reset() {
            this.entry = null;
            this.done = null;
            this.expectedTerm = 0L;
            this.shutdownLatch = null;
        }
    }
}

