/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.entity;

import com.alipay.sofa.jraft.util.Copiable;
import com.alipay.sofa.jraft.util.Endpoint;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerId
implements Copiable<PeerId>,
Serializable {
    private static final long serialVersionUID = 8083529734784884641L;
    private static final Logger LOG = LoggerFactory.getLogger(PeerId.class);
    private Endpoint endpoint = new Endpoint("0.0.0.0", 0);
    private int idx;
    private String str;
    public static final PeerId ANY_PEER = new PeerId();

    public PeerId() {
    }

    public static PeerId emptyPeer() {
        return new PeerId();
    }

    @Override
    public PeerId copy() {
        return new PeerId(this.endpoint.copy(), this.idx);
    }

    public static PeerId parsePeer(String s) {
        PeerId peer = new PeerId();
        if (peer.parse(s)) {
            return peer;
        }
        return null;
    }

    public PeerId(Endpoint endpoint, int idx) {
        this.endpoint = endpoint;
        this.idx = idx;
    }

    public PeerId(String ip, int port) {
        this(ip, port, 0);
    }

    public PeerId(String ip, int port, int idx) {
        this.endpoint = new Endpoint(ip, port);
        this.idx = idx;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String getIp() {
        return this.endpoint.getIp();
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public int getIdx() {
        return this.idx;
    }

    public boolean isEmpty() {
        return this.getIp().equals("0.0.0.0") && this.getPort() == 0 && this.idx == 0;
    }

    public String toString() {
        if (this.str == null) {
            this.str = this.endpoint.toString();
            if (this.idx != 0) {
                this.str = this.str + ":" + this.idx;
            }
        }
        return this.str;
    }

    public boolean parse(String s) {
        String[] tmps = s.split(":");
        if (tmps.length != 3 && tmps.length != 2) {
            return false;
        }
        try {
            int port = Integer.valueOf(tmps[1]);
            this.endpoint = new Endpoint(tmps[0], port);
            this.idx = tmps.length == 3 ? Integer.valueOf(tmps[2]) : 0;
            this.str = null;
            return true;
        }
        catch (Exception e) {
            LOG.error("Parse peer from string failed: {}", (Object)s, (Object)e);
            return false;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + this.idx;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeerId other = (PeerId)obj;
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        return this.idx == other.idx;
    }
}

