/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage;

import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.error.RetryAgainException;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.rpc.RpcResponseFactory;
import com.alipay.sofa.jraft.storage.io.FileReader;
import com.alipay.sofa.jraft.util.ByteBufferCollector;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.Utils;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroByteStringHelper;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileService {
    private static final Logger LOG = LoggerFactory.getLogger(FileService.class);
    private static final FileService INSTANCE = new FileService();
    private final ConcurrentMap<Long, FileReader> fileReaderMap = new ConcurrentHashMap<Long, FileReader>();
    private final AtomicLong nextId = new AtomicLong();

    public static FileService getInstance() {
        return INSTANCE;
    }

    @OnlyForTest
    void clear() {
        this.fileReaderMap.clear();
    }

    private FileService() {
        long initValue = Math.abs(Utils.getProcessId(ThreadLocalRandom.current().nextLong(10000L, Integer.MAX_VALUE)) << 45 | System.nanoTime() << 17 >> 17);
        this.nextId.set(initValue);
        LOG.info("Initial file reader id in FileService is {}", (Object)this.nextId);
    }

    public Message handleGetFile(RpcRequests.GetFileRequest request, RpcRequestClosure done) {
        if (request.getCount() <= 0L || request.getOffset() < 0L) {
            return RpcResponseFactory.newResponse(RaftError.EREQUEST, "Invalid request: %s", request);
        }
        FileReader reader = (FileReader)this.fileReaderMap.get(request.getReaderId());
        if (reader == null) {
            return RpcResponseFactory.newResponse(RaftError.ENOENT, "Fail to find reader=%d", request.getReaderId());
        }
        LOG.debug("GetFile from {} path={} filename={} offset={} count={}", new Object[]{done.getBizContext().getRemoteAddress(), reader.getPath(), request.getFilename(), request.getOffset(), request.getCount()});
        ByteBufferCollector dataBuffer = ByteBufferCollector.allocate();
        RpcRequests.GetFileResponse.Builder responseBuilder = RpcRequests.GetFileResponse.newBuilder();
        try {
            int read = reader.readFile(dataBuffer, request.getFilename(), request.getOffset(), request.getCount());
            responseBuilder.setReadSize(read);
            if (read == -1) {
                responseBuilder.setEof(true);
            }
            ByteBuffer buf = dataBuffer.getBuffer();
            buf.flip();
            if (!buf.hasRemaining()) {
                return responseBuilder.setData(ByteString.EMPTY).build();
            }
            responseBuilder.setData(ZeroByteStringHelper.wrap(buf));
            return responseBuilder.build();
        }
        catch (RetryAgainException e) {
            return RpcResponseFactory.newResponse(RaftError.EAGAIN, "Fail to read from path=%s filename=%s with error: %s", reader.getPath(), request.getFilename(), e.getMessage());
        }
        catch (IOException e) {
            LOG.error("Fail to read file path={} filename={}", new Object[]{reader.getPath(), request.getFilename(), e});
            return RpcResponseFactory.newResponse(RaftError.EIO, "Fail to read from path=%s filename=%s", reader.getPath(), request.getFilename());
        }
    }

    public long addReader(FileReader reader) {
        long readerId = this.nextId.getAndIncrement();
        if (this.fileReaderMap.putIfAbsent(readerId, reader) == null) {
            return readerId;
        }
        return -1L;
    }

    public boolean removeReader(long readerId) {
        return this.fileReaderMap.remove(readerId) != null;
    }
}

