/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.internal.UnsafeUtf8Util;
import java.io.Serializable;
import java.util.Comparator;

public final class BytesUtil {
    public static final byte[] EMPTY_BYTES = new byte[0];
    private static final ByteArrayComparator BYTES_LEXICO_COMPARATOR = new LexicographicByteArrayComparator();

    public static byte[] nullToEmpty(byte[] bytes) {
        return bytes == null ? EMPTY_BYTES : bytes;
    }

    public static boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static byte[] writeUtf8(String in) {
        if (in == null) {
            return null;
        }
        int len = UnsafeUtf8Util.encodedLength(in);
        byte[] outBytes = new byte[len];
        UnsafeUtf8Util.encodeUtf8(in, outBytes, 0, len);
        return outBytes;
    }

    public static String readUtf8(byte[] in) {
        if (in == null) {
            return null;
        }
        return UnsafeUtf8Util.decodeUtf8(in, 0, in.length);
    }

    public static byte[] nextBytes(byte[] bytes) {
        Requires.requireNonNull(bytes, "bytes");
        int len = bytes.length;
        if (len == 0) {
            return new byte[]{0};
        }
        byte[] nextBytes = new byte[len + 1];
        System.arraycopy(bytes, 0, nextBytes, 0, len);
        nextBytes[len] = 0;
        return nextBytes;
    }

    public static ByteArrayComparator getDefaultByteArrayComparator() {
        return BYTES_LEXICO_COMPARATOR;
    }

    public static int compare(byte[] a, byte[] b) {
        return BytesUtil.getDefaultByteArrayComparator().compare(a, b);
    }

    public static byte[] max(byte[] a, byte[] b) {
        return BytesUtil.getDefaultByteArrayComparator().compare(a, b) > 0 ? a : b;
    }

    public static byte[] min(byte[] a, byte[] b) {
        return BytesUtil.getDefaultByteArrayComparator().compare(a, b) < 0 ? a : b;
    }

    private BytesUtil() {
    }

    private static class LexicographicByteArrayComparator
    implements ByteArrayComparator {
        private static final long serialVersionUID = -8623342242397267864L;

        private LexicographicByteArrayComparator() {
        }

        @Override
        public int compare(byte[] buffer1, byte[] buffer2) {
            return this.compare(buffer1, 0, buffer1.length, buffer2, 0, buffer2.length);
        }

        @Override
        public int compare(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
            if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                return 0;
            }
            int end1 = offset1 + length1;
            int end2 = offset2 + length2;
            int i = offset1;
            for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
                int a = buffer1[i] & 0xFF;
                int b = buffer2[j] & 0xFF;
                if (a == b) continue;
                return a - b;
            }
            return length1 - length2;
        }
    }

    public static interface ByteArrayComparator
    extends Comparator<byte[]>,
    Serializable {
        public int compare(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);
    }
}

