/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util.internal;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public final class UnsafeUtil {
    private static final Logger LOG;
    private static final Unsafe unsafe;
    private static final MemoryAccessor memoryAccessor;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final long BOOLEAN_ARRAY_BASE_OFFSET;
    private static final long BOOLEAN_ARRAY_INDEX_SCALE;
    private static final long INT_ARRAY_BASE_OFFSET;
    private static final long INT_ARRAY_INDEX_SCALE;
    private static final long LONG_ARRAY_BASE_OFFSET;
    private static final long LONG_ARRAY_INDEX_SCALE;
    private static final long FLOAT_ARRAY_BASE_OFFSET;
    private static final long FLOAT_ARRAY_INDEX_SCALE;
    private static final long DOUBLE_ARRAY_BASE_OFFSET;
    private static final long DOUBLE_ARRAY_INDEX_SCALE;
    private static final long OBJECT_ARRAY_BASE_OFFSET;
    private static final long OBJECT_ARRAY_INDEX_SCALE;
    private static final long BUFFER_ADDRESS_OFFSET;
    private static final long STRING_VALUE_OFFSET;

    public static Unsafe getUnsafe() {
        return unsafe;
    }

    public static MemoryAccessor getMemoryAccessor() {
        return memoryAccessor;
    }

    public static byte getByte(Object target, long offset) {
        return memoryAccessor.getByte(target, offset);
    }

    public static void putByte(Object target, long offset, byte value) {
        memoryAccessor.putByte(target, offset, value);
    }

    public static int getInt(Object target, long offset) {
        return memoryAccessor.getInt(target, offset);
    }

    public static void putInt(Object target, long offset, int value) {
        memoryAccessor.putInt(target, offset, value);
    }

    public static long getLong(Object target, long offset) {
        return memoryAccessor.getLong(target, offset);
    }

    public static void putLong(Object target, long offset, long value) {
        memoryAccessor.putLong(target, offset, value);
    }

    public static boolean getBoolean(Object target, long offset) {
        return memoryAccessor.getBoolean(target, offset);
    }

    public static void putBoolean(Object target, long offset, boolean value) {
        memoryAccessor.putBoolean(target, offset, value);
    }

    public static float getFloat(Object target, long offset) {
        return memoryAccessor.getFloat(target, offset);
    }

    public static void putFloat(Object target, long offset, float value) {
        memoryAccessor.putFloat(target, offset, value);
    }

    public static double getDouble(Object target, long offset) {
        return memoryAccessor.getDouble(target, offset);
    }

    public static void putDouble(Object target, long offset, double value) {
        memoryAccessor.putDouble(target, offset, value);
    }

    public static Object getObject(Object target, long offset) {
        return memoryAccessor.getObject(target, offset);
    }

    public static void putObject(Object target, long offset, Object value) {
        memoryAccessor.putObject(target, offset, value);
    }

    public static byte getByte(byte[] target, long index) {
        return memoryAccessor.getByte(target, BYTE_ARRAY_BASE_OFFSET + index);
    }

    public static void putByte(byte[] target, long index, byte value) {
        memoryAccessor.putByte(target, BYTE_ARRAY_BASE_OFFSET + index, value);
    }

    public static int getInt(int[] target, long index) {
        return memoryAccessor.getInt(target, INT_ARRAY_BASE_OFFSET + index * INT_ARRAY_INDEX_SCALE);
    }

    public static void putInt(int[] target, long index, int value) {
        memoryAccessor.putInt(target, INT_ARRAY_BASE_OFFSET + index * INT_ARRAY_INDEX_SCALE, value);
    }

    public static long getLong(long[] target, long index) {
        return memoryAccessor.getLong(target, LONG_ARRAY_BASE_OFFSET + index * LONG_ARRAY_INDEX_SCALE);
    }

    public static void putLong(long[] target, long index, long value) {
        memoryAccessor.putLong(target, LONG_ARRAY_BASE_OFFSET + index * LONG_ARRAY_INDEX_SCALE, value);
    }

    public static boolean getBoolean(boolean[] target, long index) {
        return memoryAccessor.getBoolean(target, BOOLEAN_ARRAY_BASE_OFFSET + index * BOOLEAN_ARRAY_INDEX_SCALE);
    }

    public static void putBoolean(boolean[] target, long index, boolean value) {
        memoryAccessor.putBoolean(target, BOOLEAN_ARRAY_BASE_OFFSET + index * BOOLEAN_ARRAY_INDEX_SCALE, value);
    }

    public static float getFloat(float[] target, long index) {
        return memoryAccessor.getFloat(target, FLOAT_ARRAY_BASE_OFFSET + index * FLOAT_ARRAY_INDEX_SCALE);
    }

    public static void putFloat(float[] target, long index, float value) {
        memoryAccessor.putFloat(target, FLOAT_ARRAY_BASE_OFFSET + index * FLOAT_ARRAY_INDEX_SCALE, value);
    }

    public static double getDouble(double[] target, long index) {
        return memoryAccessor.getDouble(target, DOUBLE_ARRAY_BASE_OFFSET + index * DOUBLE_ARRAY_INDEX_SCALE);
    }

    public static void putDouble(double[] target, long index, double value) {
        memoryAccessor.putDouble(target, DOUBLE_ARRAY_BASE_OFFSET + index * DOUBLE_ARRAY_INDEX_SCALE, value);
    }

    public static Object getObject(Object[] target, long index) {
        return memoryAccessor.getObject(target, OBJECT_ARRAY_BASE_OFFSET + index * OBJECT_ARRAY_INDEX_SCALE);
    }

    public static void putObject(Object[] target, long index, Object value) {
        memoryAccessor.putObject(target, OBJECT_ARRAY_BASE_OFFSET + index * OBJECT_ARRAY_INDEX_SCALE, value);
    }

    public static byte getByte(long address) {
        return memoryAccessor.getByte(address);
    }

    public static void putByte(long address, byte value) {
        memoryAccessor.putByte(address, value);
    }

    public static int getInt(long address) {
        return memoryAccessor.getInt(address);
    }

    public static void putInt(long address, int value) {
        memoryAccessor.putInt(address, value);
    }

    public static long getLong(long address) {
        return memoryAccessor.getLong(address);
    }

    public static void putLong(long address, long value) {
        memoryAccessor.putLong(address, value);
    }

    public static byte getByteVolatile(byte[] target, long index) {
        return memoryAccessor.getByteVolatile(target, BYTE_ARRAY_BASE_OFFSET + index);
    }

    public static void putByteVolatile(byte[] target, long index, byte value) {
        memoryAccessor.putByteVolatile(target, BYTE_ARRAY_BASE_OFFSET + index, value);
    }

    public static int getIntVolatile(int[] target, long index) {
        return memoryAccessor.getIntVolatile(target, INT_ARRAY_BASE_OFFSET + index * INT_ARRAY_INDEX_SCALE);
    }

    public static void putIntVolatile(int[] target, long index, int value) {
        memoryAccessor.putIntVolatile(target, INT_ARRAY_BASE_OFFSET + index * INT_ARRAY_INDEX_SCALE, value);
    }

    public static long getLongVolatile(long[] target, long index) {
        return memoryAccessor.getLongVolatile(target, LONG_ARRAY_BASE_OFFSET + index * LONG_ARRAY_INDEX_SCALE);
    }

    public static void putLongVolatile(long[] target, long index, long value) {
        memoryAccessor.putLongVolatile(target, LONG_ARRAY_BASE_OFFSET + index * LONG_ARRAY_INDEX_SCALE, value);
    }

    public static boolean getBooleanVolatile(boolean[] target, long index) {
        return memoryAccessor.getBooleanVolatile(target, BOOLEAN_ARRAY_BASE_OFFSET + index * BOOLEAN_ARRAY_INDEX_SCALE);
    }

    public static void putBooleanVolatile(boolean[] target, long index, boolean value) {
        memoryAccessor.putBooleanVolatile(target, BOOLEAN_ARRAY_BASE_OFFSET + index * BOOLEAN_ARRAY_INDEX_SCALE, value);
    }

    public static float getFloatVolatile(float[] target, long index) {
        return memoryAccessor.getFloatVolatile(target, FLOAT_ARRAY_BASE_OFFSET + index * FLOAT_ARRAY_INDEX_SCALE);
    }

    public static void putFloatVolatile(float[] target, long index, float value) {
        memoryAccessor.putFloatVolatile(target, FLOAT_ARRAY_BASE_OFFSET + index * FLOAT_ARRAY_INDEX_SCALE, value);
    }

    public static double getDoubleVolatile(double[] target, long index) {
        return memoryAccessor.getDoubleVolatile(target, DOUBLE_ARRAY_BASE_OFFSET + index * DOUBLE_ARRAY_INDEX_SCALE);
    }

    public static void putDoubleVolatile(double[] target, long index, double value) {
        memoryAccessor.putDoubleVolatile(target, DOUBLE_ARRAY_BASE_OFFSET + index * DOUBLE_ARRAY_INDEX_SCALE, value);
    }

    public static Object getObjectVolatile(Object[] target, long index) {
        return memoryAccessor.getObjectVolatile(target, OBJECT_ARRAY_BASE_OFFSET + index * OBJECT_ARRAY_INDEX_SCALE);
    }

    public static void putObjectVolatile(Object[] target, long index, Object value) {
        memoryAccessor.putObjectVolatile(target, OBJECT_ARRAY_BASE_OFFSET + index * OBJECT_ARRAY_INDEX_SCALE, value);
    }

    public static int arrayBaseOffset(Class<?> clazz) {
        return unsafe != null ? unsafe.arrayBaseOffset(clazz) : -1;
    }

    public static int arrayIndexScale(Class<?> clazz) {
        return unsafe != null ? unsafe.arrayIndexScale(clazz) : -1;
    }

    public static long objectFieldOffset(Field field) {
        return field == null || unsafe == null ? -1L : unsafe.objectFieldOffset(field);
    }

    public static long objectFieldOffset(Class<?> clazz, String fieldName) {
        try {
            return UnsafeUtil.objectFieldOffset(clazz.getDeclaredField(fieldName));
        }
        catch (NoSuchFieldException e) {
            unsafe.throwException(e);
            return -1L;
        }
    }

    public static long addressOffset(ByteBuffer buffer) {
        return unsafe.getLong(buffer, BUFFER_ADDRESS_OFFSET);
    }

    public static String moveToString(char[] chars) {
        String str;
        if (STRING_VALUE_OFFSET == -1L) {
            return new String(chars);
        }
        try {
            str = (String)unsafe.allocateInstance(String.class);
        }
        catch (InstantiationException e) {
            return new String(chars);
        }
        unsafe.putObject(str, STRING_VALUE_OFFSET, chars);
        return str;
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    private static Field bufferAddressField() {
        return UnsafeUtil.field(Buffer.class, "address", Long.TYPE);
    }

    private static Field stringValueField() {
        return UnsafeUtil.field(String.class, "value", char[].class);
    }

    private static Field field(Class<?> clazz, String fieldName, Class<?> expectedType) {
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            if (!field.getType().equals(expectedType)) {
                return null;
            }
        }
        catch (Throwable t) {
            field = null;
        }
        return field;
    }

    private UnsafeUtil() {
    }

    static {
        Unsafe _unsafe;
        LOG = LoggerFactory.getLogger(UnsafeUtil.class);
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            _unsafe = (Unsafe)unsafeField.get(null);
        }
        catch (Throwable t) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("sun.misc.Unsafe.theUnsafe: unavailable, {}.", t);
            }
            _unsafe = null;
        }
        unsafe = _unsafe;
        memoryAccessor = new MemoryAccessor(unsafe);
        BYTE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(byte[].class);
        BOOLEAN_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(boolean[].class);
        BOOLEAN_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(boolean[].class);
        INT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(int[].class);
        INT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(int[].class);
        LONG_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(long[].class);
        LONG_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(long[].class);
        FLOAT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(float[].class);
        FLOAT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(float[].class);
        DOUBLE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(double[].class);
        DOUBLE_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(double[].class);
        OBJECT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(Object[].class);
        OBJECT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(Object[].class);
        BUFFER_ADDRESS_OFFSET = UnsafeUtil.objectFieldOffset(UnsafeUtil.bufferAddressField());
        STRING_VALUE_OFFSET = UnsafeUtil.objectFieldOffset(UnsafeUtil.stringValueField());
    }

    public static class MemoryAccessor {
        final Unsafe unsafe;

        MemoryAccessor(Unsafe unsafe) {
            this.unsafe = unsafe;
        }

        public byte getByte(Object target, long offset) {
            return this.unsafe.getByte(target, offset);
        }

        public void putByte(Object target, long offset, byte value) {
            this.unsafe.putByte(target, offset, value);
        }

        public short getShort(Object target, long offset) {
            return this.unsafe.getShort(target, offset);
        }

        public void putShort(Object target, long offset, short value) {
            this.unsafe.putShort(target, offset, value);
        }

        public int getInt(Object target, long offset) {
            return this.unsafe.getInt(target, offset);
        }

        public void putInt(Object target, long offset, int value) {
            this.unsafe.putInt(target, offset, value);
        }

        public long getLong(Object target, long offset) {
            return this.unsafe.getLong(target, offset);
        }

        public void putLong(Object target, long offset, long value) {
            this.unsafe.putLong(target, offset, value);
        }

        public boolean getBoolean(Object target, long offset) {
            return this.unsafe.getBoolean(target, offset);
        }

        public void putBoolean(Object target, long offset, boolean value) {
            this.unsafe.putBoolean(target, offset, value);
        }

        public float getFloat(Object target, long offset) {
            return this.unsafe.getFloat(target, offset);
        }

        public void putFloat(Object target, long offset, float value) {
            this.unsafe.putFloat(target, offset, value);
        }

        public double getDouble(Object target, long offset) {
            return this.unsafe.getDouble(target, offset);
        }

        public void putDouble(Object target, long offset, double value) {
            this.unsafe.putDouble(target, offset, value);
        }

        public Object getObject(Object target, long offset) {
            return this.unsafe.getObject(target, offset);
        }

        public void putObject(Object target, long offset, Object value) {
            this.unsafe.putObject(target, offset, value);
        }

        public byte getByte(long address) {
            return this.unsafe.getByte(address);
        }

        public void putByte(long address, byte value) {
            this.unsafe.putByte(address, value);
        }

        public short getShort(long address) {
            return this.unsafe.getShort(address);
        }

        public void putShort(long address, short value) {
            this.unsafe.putShort(address, value);
        }

        public int getInt(long address) {
            return this.unsafe.getInt(address);
        }

        public void putInt(long address, int value) {
            this.unsafe.putInt(address, value);
        }

        public long getLong(long address) {
            return this.unsafe.getLong(address);
        }

        public void putLong(long address, long value) {
            this.unsafe.putLong(address, value);
        }

        public void copyMemory(Object srcBase, long srcOffset, Object dstBase, long dstOffset, long bytes) {
            this.unsafe.copyMemory(srcBase, srcOffset, dstBase, dstOffset, bytes);
        }

        public void copyMemory(long srcAddress, long dstAddress, long bytes) {
            this.unsafe.copyMemory(srcAddress, dstAddress, bytes);
        }

        public byte getByteVolatile(Object target, long offset) {
            return this.unsafe.getByteVolatile(target, offset);
        }

        public void putByteVolatile(Object target, long offset, byte value) {
            this.unsafe.putByteVolatile(target, offset, value);
        }

        public short getShortVolatile(Object target, long offset) {
            return this.unsafe.getShortVolatile(target, offset);
        }

        public void putShortVolatile(Object target, long offset, short value) {
            this.unsafe.putShortVolatile(target, offset, value);
        }

        public int getIntVolatile(Object target, long offset) {
            return this.unsafe.getIntVolatile(target, offset);
        }

        public void putIntVolatile(Object target, long offset, int value) {
            this.unsafe.putIntVolatile(target, offset, value);
        }

        public long getLongVolatile(Object target, long offset) {
            return this.unsafe.getLongVolatile(target, offset);
        }

        public void putLongVolatile(Object target, long offset, long value) {
            this.unsafe.putLongVolatile(target, offset, value);
        }

        public boolean getBooleanVolatile(Object target, long offset) {
            return this.unsafe.getBooleanVolatile(target, offset);
        }

        public void putBooleanVolatile(Object target, long offset, boolean value) {
            this.unsafe.putBooleanVolatile(target, offset, value);
        }

        public float getFloatVolatile(Object target, long offset) {
            return this.unsafe.getFloatVolatile(target, offset);
        }

        public void putFloatVolatile(Object target, long offset, float value) {
            this.unsafe.putFloatVolatile(target, offset, value);
        }

        public double getDoubleVolatile(Object target, long offset) {
            return this.unsafe.getDoubleVolatile(target, offset);
        }

        public void putDoubleVolatile(Object target, long offset, double value) {
            this.unsafe.putDoubleVolatile(target, offset, value);
        }

        public Object getObjectVolatile(Object target, long offset) {
            return this.unsafe.getObjectVolatile(target, offset);
        }

        public void putObjectVolatile(Object target, long offset, Object value) {
            this.unsafe.putObjectVolatile(target, offset, value);
        }
    }
}

