/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class ZeroByteStringHelper {
    private static MethodHandle WRAP_BUF_HANDLE;
    private static MethodHandle WRAP_BYTES_HANDLE;

    public static ByteString wrap(byte[] bs) {
        if (WRAP_BYTES_HANDLE != null) {
            try {
                return WRAP_BYTES_HANDLE.invoke(bs);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ByteString.copyFrom((byte[])bs);
    }

    public static ByteString wrap(ByteBuffer buf) {
        if (WRAP_BUF_HANDLE != null) {
            try {
                return WRAP_BUF_HANDLE.invoke(buf);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ByteString.copyFrom((ByteBuffer)buf);
    }

    static {
        Method method;
        Class<ByteString> clazz2;
        WRAP_BUF_HANDLE = null;
        WRAP_BYTES_HANDLE = null;
        try {
            clazz2 = ByteString.class;
            method = clazz2.getDeclaredMethod("wrap", ByteBuffer.class);
            if (method != null) {
                WRAP_BUF_HANDLE = MethodHandles.lookup().unreflect(method);
            }
        }
        catch (Throwable clazz2) {
            // empty catch block
        }
        try {
            clazz2 = ByteString.class;
            method = clazz2.getDeclaredMethod("wrap", byte[].class);
            if (method != null) {
                WRAP_BYTES_HANDLE = MethodHandles.lookup().unreflect(method);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

